/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.common.DisconnectedFactHandle;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class UpdateInEntryPointCommand
implements ExecutableCommand<Void> {
    private static final long serialVersionUID = 3255044102543531497L;
    private DisconnectedFactHandle handle;
    private Object object;
    private String entryPoint;
    private String[] modifiedProperties;

    public UpdateInEntryPointCommand() {
    }

    public UpdateInEntryPointCommand(FactHandle handle, Object object, String entryPoint) {
        this.handle = DisconnectedFactHandle.newFrom(handle);
        this.object = object;
        this.entryPoint = entryPoint;
    }

    public UpdateInEntryPointCommand(FactHandle handle, Object object, String entryPoint, String[] modifiedProperties) {
        this(handle, object, entryPoint);
        this.modifiedProperties = modifiedProperties;
    }

    @Override
    public Void execute(Context context) {
        KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
        EntryPoint ep = ksession.getEntryPoint(this.entryPoint);
        if (this.modifiedProperties != null) {
            ep.update((FactHandle)this.handle, this.object, this.modifiedProperties);
        } else {
            ep.update((FactHandle)this.handle, this.object);
        }
        return null;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        if (entryPoint == null) {
            entryPoint = "DEFAULT";
        }
        this.entryPoint = entryPoint;
    }

    public String toString() {
        return "session.getEntryPoint( " + this.entryPoint + " ).update( " + this.handle + ", " + this.object + (this.modifiedProperties != null ? ", " + Arrays.toString(this.modifiedProperties) : "") + " );";
    }

    public Object getObject() {
        return this.object;
    }
}

