/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.spi.PropagationContext;

public class ModifyPreviousTuples {
    private final InternalFactHandle.LinkedTuples linkedTuples;

    public ModifyPreviousTuples(InternalFactHandle.LinkedTuples linkedTuples) {
        this.linkedTuples = linkedTuples;
    }

    public LeftTuple peekLeftTuple() {
        return this.linkedTuples.getFirstLeftTuple();
    }

    public RightTuple peekRightTuple() {
        return this.linkedTuples.getFirstRightTuple();
    }

    public void removeLeftTuple() {
        this.linkedTuples.removeLeftTuple(this.peekLeftTuple());
    }

    public void removeRightTuple() {
        this.linkedTuples.removeRightTuple(this.peekRightTuple());
    }

    public void retractTuples(PropagationContext pctx, InternalWorkingMemory wm) {
        this.linkedTuples.forEachLeftTuple(lt -> this.doDeleteObject(pctx, wm, (LeftTuple)lt));
        this.linkedTuples.forEachRightTuple(rt -> this.doRightDelete(pctx, wm, (RightTuple)rt));
    }

    public void doDeleteObject(PropagationContext pctx, InternalWorkingMemory wm, LeftTuple leftTuple) {
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)leftTuple.getTupleSource();
        LeftInputAdapterNode.LiaNodeMemory lm = wm.getNodeMemory(liaNode);
        LeftInputAdapterNode.doDeleteObject(leftTuple, pctx, lm.getSegmentMemory(), wm, liaNode, true, lm);
    }

    public void doRightDelete(PropagationContext pctx, InternalWorkingMemory wm, RightTuple rightTuple) {
        rightTuple.setPropagationContext(pctx);
        rightTuple.retractTuple(pctx, wm);
    }
}

