/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.Bag;
import org.kie.api.definition.rule.Rule;

public abstract class BaseNode
implements NetworkNode {
    protected int id;
    protected int memoryId = -1;
    protected RuleBasePartitionId partitionId;
    protected boolean partitionsEnabled;
    protected Bag<Rule> associations;
    private boolean streamMode;
    protected int hashcode;

    public BaseNode() {
    }

    public BaseNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this.id = id;
        this.partitionId = partitionId;
        this.partitionsEnabled = partitionsEnabled;
        this.associations = new Bag();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.memoryId = in.readInt();
        this.partitionId = (RuleBasePartitionId)in.readObject();
        this.partitionsEnabled = in.readBoolean();
        this.associations = (Bag)in.readObject();
        this.streamMode = in.readBoolean();
        this.hashcode = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.memoryId);
        out.writeObject(this.partitionId);
        out.writeBoolean(this.partitionsEnabled);
        out.writeObject(this.associations);
        out.writeBoolean(this.streamMode);
        out.writeInt(this.hashcode);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getMemoryId() {
        if (this.memoryId < 0) {
            throw new UnsupportedOperationException();
        }
        return this.memoryId;
    }

    protected void initMemoryId(BuildContext context) {
        if (context != null && this instanceof MemoryFactory) {
            RuleImpl rule = context.getRule();
            String unit = rule != null && rule.getRuleUnitClassName() != null ? rule.getRuleUnitClassName() : "DEFAULT_RULE_UNIT";
            this.memoryId = context.getNextId(unit);
        }
    }

    public boolean isStreamMode() {
        return this.streamMode;
    }

    protected void setStreamMode(boolean streamMode) {
        this.streamMode = streamMode;
    }

    public abstract void attach(BuildContext var1);

    public abstract void networkUpdated(UpdateContext var1);

    public boolean remove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        boolean removed = this.doRemove(context, builder, workingMemories);
        if (!this.isInUse() && !(this instanceof EntryPointNode)) {
            builder.getIdGenerator().releaseId(context.getRule(), this);
        }
        return removed;
    }

    protected abstract boolean doRemove(RuleRemovalContext var1, ReteooBuilder var2, InternalWorkingMemory[] var3);

    public abstract boolean isInUse();

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ")]";
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public void addAssociation(Rule rule) {
        this.associations.add(rule);
    }

    public void addAssociation(BuildContext context, Rule rule) {
        this.addAssociation(rule);
    }

    public boolean removeAssociation(Rule rule) {
        return this.associations.remove(rule);
    }

    @Override
    public int getAssociationsSize() {
        return this.associations.size();
    }

    @Override
    public int getAssociatedRuleSize() {
        return this.associations.getKeySize();
    }

    @Override
    public int getAssociationsSize(Rule rule) {
        return this.associations.sizeFor(rule);
    }

    @Override
    public boolean isAssociatedWith(Rule rule) {
        return this.associations.contains(rule);
    }

    @Override
    public boolean thisNodeEquals(Object object) {
        return this == object || this.internalEquals(object);
    }

    protected abstract boolean internalEquals(Object var1);

    public final int hashCode() {
        return this.hashcode;
    }

    public Sink[] getSinks() {
        Sink[] sinks = null;
        if (this instanceof EntryPointNode) {
            EntryPointNode source = (EntryPointNode)this;
            Collection<ObjectTypeNode> otns = source.getObjectTypeNodes().values();
            sinks = otns.toArray(new Sink[otns.size()]);
        } else if (this instanceof ObjectSource) {
            ObjectSource source = (ObjectSource)this;
            sinks = source.getObjectSinkPropagator().getSinks();
        } else if (this instanceof LeftTupleSource) {
            LeftTupleSource source = (LeftTupleSource)this;
            sinks = source.getSinkPropagator().getSinks();
        }
        return sinks;
    }
}

