/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.concurrent.CountDownLatch;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.impl.PointInTimeTrigger;

public interface PropagationEntry {
    public void execute(InternalWorkingMemory var1);

    public void execute(InternalKnowledgeRuntime var1);

    public PropagationEntry getNext();

    public void setNext(PropagationEntry var1);

    public boolean requiresImmediateFlushing();

    public boolean isCalledFromRHS();

    public boolean isPartitionSplittable();

    public PropagationEntry getSplitForPartition(int var1);

    public static class PartitionedDelete
    extends AbstractPartitionedPropagationEntry {
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        PartitionedDelete(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, int partition) {
            super(partition);
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            ObjectTypeNode[] cachedNodes = this.objectTypeConf.getObjectTypeNodes();
            if (cachedNodes == null) {
                return;
            }
            for (ObjectTypeNode cachedNode : cachedNodes) {
                cachedNode.retractObject(this.handle, this.context, wm, this.partition);
            }
            if (this.handle.isEvent() && this.isMasterPartition()) {
                ((EventFactHandle)this.handle).unscheduleAllJobs(wm);
            }
        }

        public String toString() {
            return "Delete of " + this.handle.getObject() + " for partition " + this.partition;
        }
    }

    public static class Delete
    extends AbstractPropagationEntry {
        private final EntryPointNode epn;
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        public Delete(EntryPointNode epn, InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf) {
            this.epn = epn;
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            this.epn.propagateRetract(this.handle, this.context, this.objectTypeConf, wm);
        }

        @Override
        public boolean isPartitionSplittable() {
            return true;
        }

        @Override
        public PropagationEntry getSplitForPartition(int partitionNr) {
            return new PartitionedDelete(this.handle, this.context, this.objectTypeConf, partitionNr);
        }

        public String toString() {
            return "Delete of " + this.handle.getObject();
        }
    }

    public static class PartitionedUpdate
    extends AbstractPartitionedPropagationEntry {
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        PartitionedUpdate(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, int partition) {
            super(partition);
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(this.handle.detachLinkedTuplesForPartition(this.partition));
            ObjectTypeNode[] cachedNodes = this.objectTypeConf.getObjectTypeNodes();
            int length = cachedNodes.length;
            for (int i = 0; i < length; ++i) {
                ObjectTypeNode otn = cachedNodes[i];
                ((CompositePartitionAwareObjectSinkAdapter)otn.getObjectSinkPropagator()).propagateModifyObjectForPartition(this.handle, modifyPreviousTuples, this.context.adaptModificationMaskForObjectType(otn.getObjectType(), wm), wm, this.partition);
                if (i >= cachedNodes.length - 1) continue;
                EntryPointNode.removeRightTuplesMatchingOTN(this.context, wm, modifyPreviousTuples, otn);
            }
            modifyPreviousTuples.retractTuples(this.context, wm);
        }

        public String toString() {
            return "Update of " + this.handle.getObject() + " for partition " + this.partition;
        }
    }

    public static class Update
    extends AbstractPropagationEntry {
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        public Update(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf) {
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            EntryPointNode.propagateModify(this.handle, this.context, this.objectTypeConf, wm);
        }

        @Override
        public boolean isPartitionSplittable() {
            return true;
        }

        @Override
        public PropagationEntry getSplitForPartition(int partitionNr) {
            return new PartitionedUpdate(this.handle, this.context, this.objectTypeConf, partitionNr);
        }

        public String toString() {
            return "Update of " + this.handle.getObject();
        }
    }

    public static class Insert
    extends AbstractPropagationEntry {
        private static final transient ObjectTypeNode.ExpireJob job = new ObjectTypeNode.ExpireJob();
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        public Insert(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory, ObjectTypeConf objectTypeConf) {
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
            if (objectTypeConf.isEvent()) {
                Insert.scheduleExpiration(workingMemory, handle, context, objectTypeConf, workingMemory.getTimerService().getCurrentTime());
            }
        }

        public static void execute(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory wm, ObjectTypeConf objectTypeConf) {
            if (objectTypeConf.isEvent()) {
                Insert.scheduleExpiration(wm, handle, context, objectTypeConf, wm.getTimerService().getCurrentTime());
            }
            Insert.propagate(handle, context, wm, objectTypeConf);
        }

        private static void propagate(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory wm, ObjectTypeConf objectTypeConf) {
            for (ObjectTypeNode otn : objectTypeConf.getObjectTypeNodes()) {
                otn.propagateAssert(handle, context, wm);
            }
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            Insert.propagate(this.handle, this.context, wm, this.objectTypeConf);
        }

        private static void scheduleExpiration(InternalWorkingMemory wm, InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, long insertionTime) {
            for (ObjectTypeNode otn : objectTypeConf.getObjectTypeNodes()) {
                Insert.scheduleExpiration(wm, handle, context, otn, insertionTime, otn.getExpirationOffset());
            }
            if (objectTypeConf.getConcreteObjectTypeNode() == null) {
                Insert.scheduleExpiration(wm, handle, context, null, insertionTime, ((ClassObjectTypeConf)objectTypeConf).getExpirationOffset());
            }
        }

        private static void scheduleExpiration(InternalWorkingMemory wm, InternalFactHandle handle, PropagationContext context, ObjectTypeNode otn, long insertionTime, long expirationOffset) {
            if (expirationOffset < 0L || expirationOffset == Long.MAX_VALUE || context.getReaderContext() != null) {
                return;
            }
            EventFactHandle eventFactHandle = (EventFactHandle)handle;
            long nextTimestamp = Insert.getNextTimestamp(insertionTime, expirationOffset, eventFactHandle);
            StatefulKnowledgeSessionImpl.WorkingMemoryReteExpireAction action = new StatefulKnowledgeSessionImpl.WorkingMemoryReteExpireAction((EventFactHandle)handle, otn);
            if (nextTimestamp < wm.getTimerService().getCurrentTime()) {
                wm.addPropagation(action);
            } else {
                ObjectTypeNode.ExpireJobContext jobctx = new ObjectTypeNode.ExpireJobContext(action, wm);
                JobHandle jobHandle = wm.getTimerService().scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
                jobctx.setJobHandle(jobHandle);
                eventFactHandle.addJob(jobHandle);
            }
        }

        private static long getNextTimestamp(long insertionTime, long expirationOffset, EventFactHandle eventFactHandle) {
            long effectiveEnd = eventFactHandle.getEndTimestamp() + expirationOffset;
            return Math.max(insertionTime, effectiveEnd >= 0L ? effectiveEnd : Long.MAX_VALUE);
        }

        public String toString() {
            return "Insert of " + this.handle.getObject();
        }
    }

    public static abstract class PropagationEntryWithResult<T>
    extends AbstractPropagationEntry {
        private final CountDownLatch done = new CountDownLatch(1);
        private T result;

        public final T getResult() {
            try {
                this.done.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.result;
        }

        protected void done(T result) {
            this.result = result;
            this.done.countDown();
        }

        @Override
        public boolean requiresImmediateFlushing() {
            return true;
        }
    }

    public static abstract class AbstractPartitionedPropagationEntry
    extends AbstractPropagationEntry {
        protected final int partition;

        protected AbstractPartitionedPropagationEntry(int partition) {
            this.partition = partition;
        }

        protected boolean isMasterPartition() {
            return this.partition == 0;
        }
    }

    public static abstract class AbstractPropagationEntry
    implements PropagationEntry {
        private PropagationEntry next;

        @Override
        public void setNext(PropagationEntry next) {
            this.next = next;
        }

        @Override
        public PropagationEntry getNext() {
            return this.next;
        }

        @Override
        public boolean requiresImmediateFlushing() {
            return false;
        }

        @Override
        public boolean isCalledFromRHS() {
            return false;
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((WorkingMemoryEntryPoint)((Object)kruntime)).getInternalWorkingMemory());
        }

        @Override
        public boolean isPartitionSplittable() {
            return false;
        }

        @Override
        public PropagationEntry getSplitForPartition(int partitionNr) {
            throw new UnsupportedOperationException();
        }
    }
}

