/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedProperties
implements Externalizable {
    protected static transient Logger logger = LoggerFactory.getLogger(ChainedProperties.class);
    private static final int MAX_CACHE_ENTRIES = Integer.parseInt(System.getProperty("org.kie.property.cache.size", "100"));
    private static final boolean CACHE_ENABLED = Boolean.parseBoolean(System.getProperty("org.kie.property.cache.enabled", "false"));
    protected static Map<CacheKey, List<Properties>> propertiesCache = Collections.synchronizedMap(new LinkedHashMap<CacheKey, List<Properties>>(){
        private static final long serialVersionUID = -4728876927433598466L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<CacheKey, List<Properties>> eldest) {
            return this.size() > MAX_CACHE_ENTRIES;
        }
    });
    private List<Properties> props;
    private List<Properties> defaultProps;

    public ChainedProperties() {
    }

    public ChainedProperties(String confFileName, ClassLoader classLoader) {
        this(confFileName, classLoader, true);
    }

    public ChainedProperties(String confFileName, ClassLoader classLoader, boolean populateDefaults) {
        this.props = new ArrayList<Properties>();
        this.defaultProps = new ArrayList<Properties>();
        this.addProperties(System.getProperties());
        this.loadProperties(System.getProperty("drools." + confFileName), this.props);
        this.loadProperties(System.getProperty("user.home") + "/drools." + confFileName, this.props);
        this.loadProperties("drools." + confFileName, this.props);
        this.loadProperties("META-INF/drools." + confFileName, classLoader, this.props);
        this.loadProperties("/META-INF/drools." + confFileName, classLoader, this.props);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && contextClassLoader != classLoader) {
            this.loadProperties(confFileName, contextClassLoader, this.props);
        }
        ClassLoader systemClassLoader = null;
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (systemClassLoader != null && systemClassLoader != classLoader) {
            this.loadProperties(confFileName, systemClassLoader, this.props);
        }
        if (!populateDefaults) {
            return;
        }
        this.loadProperties("META-INF/drools.default." + confFileName, classLoader, this.defaultProps);
        this.loadProperties("/META-INF/drools.default." + confFileName, classLoader, this.defaultProps);
        if (contextClassLoader != null && contextClassLoader != classLoader) {
            this.loadProperties(confFileName, contextClassLoader, this.defaultProps);
        }
        if (systemClassLoader != null && systemClassLoader != classLoader) {
            this.loadProperties(confFileName, systemClassLoader, this.defaultProps);
        }
        if (this.defaultProps.isEmpty()) {
            try {
                Class<?> c = Class.forName("org.drools.compiler.lang.MVELDumper", false, classLoader);
                URL confURL = c.getResource("/META-INF/drools.default." + confFileName);
                this.loadProperties(confURL, this.defaultProps);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.props = (List)in.readObject();
        this.defaultProps = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.props);
        out.writeObject(this.defaultProps);
    }

    public void addProperties(Properties properties) {
        this.props.add(0, properties);
    }

    public String getProperty(String key, String defaultValue) {
        String value;
        block2: {
            Properties props;
            value = null;
            Iterator<Properties> iterator = this.props.iterator();
            while (iterator.hasNext() && (value = (props = iterator.next()).getProperty(key)) == null) {
            }
            if (value != null) break block2;
            iterator = this.defaultProps.iterator();
            while (iterator.hasNext() && (value = (props = iterator.next()).getProperty(key)) == null) {
            }
        }
        return value != null ? value : defaultValue;
    }

    public void mapStartsWith(Map<String, String> map, String startsWith, boolean includeSubProperties) {
        for (Properties props : this.props) {
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
        for (Properties props : this.defaultProps) {
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
    }

    private void mapStartsWith(Map<String, String> map, Properties properties, String startsWith, boolean includeSubProperties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(startsWith) || !includeSubProperties && key.substring(startsWith.length() + 1).indexOf(46) > 0 || map.containsKey(key)) continue;
            map.put(key, properties.getProperty(key));
        }
    }

    private void loadProperties(String fileName, List<Properties> chain) {
        File file;
        if (fileName != null && (file = new File(fileName)) != null && file.exists()) {
            this.loadProperties(fileName, null, chain);
        }
    }

    private void loadProperties(String fileName, ClassLoader classLoader, List<Properties> chain) {
        if (!CACHE_ENABLED) {
            try {
                chain.addAll(this.read(fileName, classLoader));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        CacheKey ck = new CacheKey(fileName, classLoader);
        List<Properties> cached = propertiesCache.get(ck);
        if (cached == null) {
            try {
                cached = this.read(fileName, classLoader);
                propertiesCache.put(ck, cached);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (cached != null) {
            chain.addAll(cached);
        }
    }

    private List<Properties> read(String fileName, ClassLoader classLoader) throws IOException {
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> resources = classLoader != null ? classLoader.getResources(fileName) : Collections.enumeration(Collections.singletonList(new File(fileName).toURI().toURL()));
        while (resources.hasMoreElements()) {
            Properties p = new Properties();
            URL nextElement = resources.nextElement();
            InputStream is = nextElement.openStream();
            Throwable throwable = null;
            try {
                p.load(is);
                properties.add(p);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return properties;
    }

    private void loadProperties(URL confURL, List<Properties> chain) {
        if (confURL == null) {
            return;
        }
        try (InputStream is = confURL.openStream();){
            Properties properties = new Properties();
            properties.load(is);
            chain.add(properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class CacheKey {
        private String confFileName;
        private ClassLoader classLoader;

        CacheKey(String confFileName, ClassLoader classLoader) {
            this.confFileName = confFileName;
            this.classLoader = classLoader;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.classLoader == null ? 0 : this.classLoader.hashCode());
            result = 31 * result + (this.confFileName == null ? 0 : this.confFileName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.classLoader == null ? other.classLoader != null : !this.classLoader.equals(other.classLoader)) {
                return false;
            }
            return !(this.confFileName == null ? other.confFileName != null : !this.confFileName.equals(other.confFileName));
        }

        public String toString() {
            return "CacheKey [confFileName=" + this.confFileName + ", classLoader=" + this.classLoader + "]";
        }
    }
}

