/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.process.core.datatype.impl.type;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.process.core.datatype.DataType;

public class EnumDataType
implements DataType {
    private static final long serialVersionUID = 4L;
    private String className;
    private transient Map<String, Object> valueMap;

    public EnumDataType() {
    }

    public EnumDataType(String className) {
        this.setClassName(className);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
    }

    @Override
    public boolean verifyDataType(Object value) {
        if (value == null) {
            return true;
        }
        return this.getValueMap().containsValue(value);
    }

    @Override
    public Object readValue(String value) {
        return this.getValueMap().get(value);
    }

    @Override
    public String writeValue(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public String getStringType() {
        return this.className == null ? "java.lang.Object" : this.className;
    }

    public Object[] getValues() {
        return this.getValueMap().values().toArray();
    }

    public String[] getValueNames() {
        return this.getValueMap().keySet().toArray(new String[0]);
    }

    public Map<String, Object> getValueMap() {
        if (this.valueMap == null) {
            try {
                Object[] values;
                this.valueMap = new HashMap<String, Object>();
                if (this.className == null) {
                    return null;
                }
                Class<?> clazz = Class.forName(this.className);
                if (!clazz.isEnum()) {
                    return null;
                }
                for (Object value : values = (Object[])clazz.getMethod("values", null).invoke(clazz, null)) {
                    this.valueMap.put(value.toString(), value);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find data type " + this.className);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("IllegalAccessException " + e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("InvocationTargetException " + e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("NoSuchMethodException " + e);
            }
        }
        return this.valueMap;
    }
}

