/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.version.Version;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.Aether;
import org.kie.scanner.DependencyDescriptor;
import org.kie.scanner.MavenRepositoryConfiguration;
import org.kie.scanner.embedder.MavenEmbedder;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.kie.scanner.embedder.MavenSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepository {
    private static final Logger log = LoggerFactory.getLogger(MavenRepository.class);
    public static MavenRepository defaultMavenRepository;
    private final Aether aether;
    private final Collection<RemoteRepository> remoteRepositoriesForRequest;

    protected MavenRepository(Aether aether) {
        this.aether = aether;
        this.remoteRepositoriesForRequest = this.initRemoteRepositoriesForRequest();
    }

    protected MavenRepositoryConfiguration getMavenRepositoryConfiguration() {
        return MavenSettings.getMavenRepositoryConfiguration();
    }

    Collection<RemoteRepository> getRemoteRepositoriesForRequest() {
        return this.remoteRepositoriesForRequest;
    }

    public static synchronized MavenRepository getMavenRepository() {
        if (defaultMavenRepository == null) {
            Aether defaultAether = Aether.getAether();
            defaultMavenRepository = new MavenRepository(defaultAether);
        }
        return defaultMavenRepository;
    }

    private Collection<RemoteRepository> initRemoteRepositoriesForRequest() {
        MavenRepositoryConfiguration repositoryUtils = this.getMavenRepositoryConfiguration();
        HashSet<RemoteRepository> remoteRepos = new HashSet<RemoteRepository>();
        remoteRepos.addAll(repositoryUtils.getRemoteRepositoriesForRequest());
        for (RemoteRepository repo : this.aether.getRepositories()) {
            remoteRepos.add(repositoryUtils.resolveMirroredRepo(repo));
        }
        return remoteRepos;
    }

    public static MavenRepository getMavenRepository(MavenProject mavenProject) {
        return new MavenRepository(new Aether(mavenProject));
    }

    public List<DependencyDescriptor> getArtifactDependecies(String artifactName) {
        CollectResult collectResult;
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        CollectRequest collectRequest = new CollectRequest();
        Dependency root = new Dependency(artifact, "");
        collectRequest.setRoot(root);
        for (RemoteRepository repo : this.remoteRepositoriesForRequest) {
            collectRequest.addRepository(repo);
        }
        try {
            collectResult = this.aether.getSystem().collectDependencies(this.aether.getSession(), collectRequest);
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(e);
        }
        CollectDependencyVisitor visitor = new CollectDependencyVisitor();
        collectResult.getRoot().accept(visitor);
        ArrayList<DependencyDescriptor> descriptors = new ArrayList<DependencyDescriptor>();
        for (DependencyNode node : visitor.getDependencies()) {
            if (node.getDependency().equals(root)) continue;
            descriptors.add(new DependencyDescriptor(node.getDependency().getArtifact()));
        }
        return descriptors;
    }

    public Artifact resolveArtifact(ReleaseId releaseId) {
        String artifactName = releaseId.toString();
        if (DependencyDescriptor.isRangedVersion(releaseId.getVersion())) {
            Version v = this.resolveVersion(artifactName);
            if (v == null) {
                return null;
            }
            artifactName = releaseId.getGroupId() + ":" + releaseId.getArtifactId() + ":" + v;
        }
        return this.resolveArtifact(artifactName);
    }

    public Artifact resolveArtifact(String artifactName) {
        return this.resolveArtifact(artifactName, true);
    }

    public Artifact resolveArtifact(String artifactName, boolean logUnresolvedArtifact) {
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        for (RemoteRepository repo : this.remoteRepositoriesForRequest) {
            artifactRequest.addRepository(repo);
        }
        try {
            ArtifactResult artifactResult = this.aether.getSystem().resolveArtifact(this.aether.getSession(), artifactRequest);
            return artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            if (logUnresolvedArtifact) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to resolve artifact: " + artifactName, (Throwable)e);
                } else {
                    log.warn("Unable to resolve artifact: " + artifactName);
                }
            }
            return null;
        }
    }

    public Version resolveVersion(String artifactName) {
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        VersionRangeRequest versionRequest = new VersionRangeRequest();
        versionRequest.setArtifact(artifact);
        for (RemoteRepository repo : this.remoteRepositoriesForRequest) {
            versionRequest.addRepository(repo);
        }
        try {
            VersionRangeResult versionRangeResult = this.aether.getSystem().resolveVersionRange(this.aether.getSession(), versionRequest);
            return versionRangeResult.getHighestVersion();
        }
        catch (VersionRangeResolutionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to resolve version range for artifact: " + artifactName, (Throwable)e);
            } else {
                log.warn("Unable to resolve version range for artifact: " + artifactName);
            }
            return null;
        }
    }

    public void deployArtifact(ReleaseId releaseId, InternalKieModule kieModule, File pomfile) {
        RemoteRepository repository = this.getRemoteRepositoryFromDistributionManagement(pomfile);
        if (repository == null) {
            log.warn("No Distribution Management configured: unknown repository");
            return;
        }
        this.deployArtifact(repository, releaseId, kieModule, pomfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteRepository getRemoteRepositoryFromDistributionManagement(File pomfile) {
        DeploymentRepository deployRepo;
        MavenProject mavenProject = MavenProjectLoader.parseMavenPom(pomfile);
        DistributionManagement distMan = mavenProject.getDistributionManagement();
        if (distMan == null) {
            return null;
        }
        DeploymentRepository deploymentRepository = deployRepo = distMan.getSnapshotRepository() != null && mavenProject.getVersion().endsWith("SNAPSHOT") ? distMan.getSnapshotRepository() : distMan.getRepository();
        if (deployRepo == null) {
            return null;
        }
        RemoteRepository.Builder remoteRepoBuilder = new RemoteRepository.Builder(deployRepo.getId(), deployRepo.getLayout(), deployRepo.getUrl()).setSnapshotPolicy(new RepositoryPolicy(true, "daily", "warn")).setReleasePolicy(new RepositoryPolicy(true, "always", "warn"));
        Server server = MavenSettings.getSettings().getServer(deployRepo.getId());
        if (server != null) {
            MavenEmbedder embedder = MavenProjectLoader.newMavenEmbedder(false);
            try {
                Authentication authentication = embedder.getMavenSession().getRepositorySession().getAuthenticationSelector().getAuthentication(remoteRepoBuilder.build());
                remoteRepoBuilder.setAuthentication(authentication);
            }
            finally {
                embedder.dispose();
            }
        }
        return remoteRepoBuilder.build();
    }

    public void deployArtifact(RemoteRepository repository, ReleaseId releaseId, InternalKieModule kieModule, File pomfile) {
        File jarFile = this.bytesToFile(releaseId, kieModule.getBytes(), ".jar");
        this.deployArtifact(repository, releaseId, jarFile, pomfile);
    }

    public void deployArtifact(RemoteRepository repository, ReleaseId releaseId, File jar, File pomfile) {
        Artifact jarArtifact = new DefaultArtifact(releaseId.getGroupId(), releaseId.getArtifactId(), "jar", releaseId.getVersion());
        jarArtifact = jarArtifact.setFile(jar);
        Artifact pomArtifact = new SubArtifact(jarArtifact, "", "pom");
        pomArtifact = pomArtifact.setFile(pomfile);
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.addArtifact(jarArtifact).addArtifact(pomArtifact).setRepository(repository);
        try {
            this.aether.getSystem().deploy(this.aether.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    private File bytesToFile(ReleaseId releaseId, byte[] bytes, String extension) {
        File file = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName(releaseId, null) + extension);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public void installArtifact(ReleaseId releaseId, InternalKieModule kieModule, File pomfile) {
        File jarFile = this.bytesToFile(releaseId, kieModule.getBytes(), ".jar");
        this.installArtifact(releaseId, jarFile, pomfile);
    }

    public void installArtifact(ReleaseId releaseId, byte[] jarContent, byte[] pomContent) {
        File jarFile = this.bytesToFile(releaseId, jarContent, ".jar");
        File pomFile = this.bytesToFile(releaseId, pomContent, ".pom");
        this.installArtifact(releaseId, jarFile, pomFile);
    }

    public void installArtifact(ReleaseId releaseId, File jar, File pomfile) {
        Artifact jarArtifact = new DefaultArtifact(releaseId.getGroupId(), releaseId.getArtifactId(), "jar", releaseId.getVersion());
        jarArtifact = jarArtifact.setFile(jar);
        Artifact pomArtifact = new SubArtifact(jarArtifact, "", "pom");
        pomArtifact = pomArtifact.setFile(pomfile);
        InstallRequest installRequest = new InstallRequest();
        installRequest.addArtifact(jarArtifact).addArtifact(pomArtifact);
        try {
            this.aether.getSystem().install(this.aether.getSession(), installRequest);
        }
        catch (InstallationException e) {
            throw new RuntimeException(e);
        }
    }

    public void deployPomArtifact(String groupId, String artifactId, String version, File pomfile) {
        Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "pom", version);
        pomArtifact = pomArtifact.setFile(pomfile);
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.addArtifact(pomArtifact).setRepository(this.aether.getLocalRepository());
        try {
            this.aether.getSystem().deploy(this.aether.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toFileName(ReleaseId releaseId, String classifier) {
        if (classifier != null) {
            return releaseId.getArtifactId() + "-" + releaseId.getVersion() + "-" + classifier;
        }
        return releaseId.getArtifactId() + "-" + releaseId.getVersion();
    }

    private static class CollectDependencyVisitor
    implements DependencyVisitor {
        private final List<DependencyNode> dependencies = new ArrayList<DependencyNode>();

        private CollectDependencyVisitor() {
        }

        @Override
        public boolean visitEnter(DependencyNode node) {
            this.dependencies.add(node);
            return true;
        }

        @Override
        public boolean visitLeave(DependencyNode node) {
            return true;
        }

        public List<DependencyNode> getDependencies() {
            return this.dependencies;
        }
    }
}

