/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.compilers;

import org.codehaus.janino.Location;
import org.codehaus.janino.util.LocatedException;
import org.drools.compiler.commons.jci.problems.CompilationProblem;

public final class JaninoCompilationProblem
implements CompilationProblem {
    private final Location location;
    private final String fileName;
    private final String message;
    private final boolean error;

    public JaninoCompilationProblem(LocatedException pLocatedException) {
        this(pLocatedException.getLocation(), pLocatedException.getMessage(), true);
    }

    public JaninoCompilationProblem(Location pLocation, String pMessage, boolean pError) {
        this(pLocation.getFileName(), pLocation, pMessage, pError);
    }

    public JaninoCompilationProblem(String pFilename, String pMessage, boolean pError) {
        this(pFilename, null, pMessage, pError);
    }

    public JaninoCompilationProblem(String pFilename, Location pLocation, String pMessage, boolean pError) {
        this.location = pLocation;
        this.fileName = pFilename;
        this.message = pMessage;
        this.error = pError;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getStartLine() {
        if (this.location == null) {
            return 0;
        }
        return this.location.getLineNumber();
    }

    @Override
    public int getStartColumn() {
        if (this.location == null) {
            return 0;
        }
        return this.location.getColumnNumber();
    }

    @Override
    public int getEndLine() {
        return this.getStartLine();
    }

    @Override
    public int getEndColumn() {
        return this.getStartColumn();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFileName()).append(" (");
        sb.append(this.getStartLine());
        sb.append(":");
        sb.append(this.getStartColumn());
        sb.append(") : ");
        sb.append(this.getMessage());
        return sb.toString();
    }
}

