/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.datasources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.datasources.InternalDataSource;
import org.drools.core.factmodel.traits.TraitTypeEnum;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.drools.core.phreak.SynchronizedPropagationList;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.RuleUnit;

public class CursoredDataSource<T>
implements InternalDataSource<T> {
    private InternalWorkingMemory workingMemory;
    private ObjectStore objectStore = new ClassAwareObjectStore(RuleBaseConfiguration.AssertBehaviour.IDENTITY, null);
    private Map<RuleUnit.Identity, PropagationList> propagationsMap = new HashMap<RuleUnit.Identity, PropagationList>();
    private RuleUnit.Identity currentUnit;
    private EntryPoint currentEntryPoint;
    private List<T> inserted;

    public CursoredDataSource() {
    }

    public CursoredDataSource(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        if (this.inserted != null) {
            this.inserted.forEach(this::insertIntoWm);
            this.inserted = null;
        }
    }

    public FactHandle insert(T object) {
        if (this.workingMemory != null) {
            return this.insertIntoWm(object);
        }
        if (this.inserted == null) {
            this.inserted = new ArrayList<T>();
        }
        this.inserted.add(object);
        return null;
    }

    private FactHandle insertIntoWm(T object) {
        FactHandleFactory fhFactory = this.workingMemory.getFactHandleFactory();
        DataSourceFactHandle factHandle = new DataSourceFactHandle(this, fhFactory.getNextId(), fhFactory.getNextRecency(), object);
        this.objectStore.addHandle(factHandle, object);
        this.propagate(() -> new Insert(factHandle));
        return factHandle;
    }

    public void update(FactHandle handle, T object, String ... modifiedProperties) {
        BitMask mask = modifiedProperties == null || modifiedProperties.length == 0 ? PropertySpecificUtil.allSetButTraitBitMask() : PropertySpecificUtil.calculatePositiveMask(Arrays.asList(modifiedProperties), PropertySpecificUtil.getAccessibleProperties(this.workingMemory.getKnowledgeBase(), object.getClass()));
        this.internalUpdate((DataSourceFactHandle)handle, object, mask, Object.class, null);
    }

    @Override
    public void update(FactHandle fh, Object obj, BitMask mask, Class<?> modifiedClass, Activation activation) {
        DataSourceFactHandle dataSourceFactHandle = (DataSourceFactHandle)((InternalFactHandle)fh).getParentHandle();
        this.internalUpdate(dataSourceFactHandle, obj, mask, modifiedClass, activation);
    }

    private void internalUpdate(DataSourceFactHandle dataSourceFactHandle, Object obj, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.propagate(() -> new Update(dataSourceFactHandle, obj, mask, modifiedClass, activation));
    }

    private void propagate(Supplier<AbstractDataSourcePropagation> s) {
        this.propagationsMap.forEach((ruId, list) -> {
            if (ruId.equals((Object)this.currentUnit)) {
                this.workingMemory.getPropagationList().addEntry(((AbstractDataSourcePropagation)s.get()).setEntryPoint(this.currentEntryPoint));
            } else {
                list.addEntry((PropagationEntry)s.get());
            }
        });
    }

    public void delete(FactHandle fh) {
        DataSourceFactHandle dsFh = (DataSourceFactHandle)fh;
        this.objectStore.removeHandle(dsFh);
        this.propagate(() -> new Delete(dsFh, null));
    }

    @Override
    public void bind(RuleUnit unit, WorkingMemoryEntryPoint ep) {
        this.setWorkingMemory(ep.getInternalWorkingMemory());
        PropagationList propagationList = this.propagationsMap.get(unit.getUnitIdentity());
        if (propagationList != null) {
            this.flush(ep, propagationList.takeAll());
        } else {
            Iterator<InternalFactHandle> fhs = this.objectStore.iterateFactHandles();
            while (fhs.hasNext()) {
                new Insert((DataSourceFactHandle)fhs.next()).execute(ep);
            }
            this.propagationsMap.put(unit.getUnitIdentity(), new SynchronizedPropagationList(ep.getInternalWorkingMemory()));
        }
        this.currentUnit = unit.getUnitIdentity();
        this.currentEntryPoint = ep;
    }

    private void flush(EntryPoint ep, PropagationEntry currentHead) {
        for (PropagationEntry entry = currentHead; entry != null; entry = entry.getNext()) {
            ((AbstractDataSourcePropagation)entry).execute(ep);
        }
    }

    @Override
    public void unbind(RuleUnit unit) {
        this.currentUnit = null;
        this.currentEntryPoint = null;
    }

    public Iterator<T> iterator() {
        return this.inserted != null ? this.inserted.iterator() : this.objectStore.iterateObjects();
    }

    public static class DataSourceFactHandle
    implements InternalFactHandle {
        private final InternalDataSource<?> dataSource;
        private Object object;
        private final Map<RuleUnit.Identity, InternalFactHandle> childHandles = new HashMap<RuleUnit.Identity, InternalFactHandle>();
        private final int id;
        private long recency;
        private final int identityHashCode;
        private boolean negated = false;

        DataSourceFactHandle(InternalDataSource<?> dataSource, int id, long recency, Object object) {
            this.dataSource = dataSource;
            this.id = id;
            this.recency = recency;
            this.object = object;
            this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(object);
        }

        InternalFactHandle createFactHandleFor(WorkingMemoryEntryPoint ep, ObjectTypeConf conf) {
            InternalFactHandle fh = ep.getHandleFactory().newFactHandle(this.id, this.object, this.recency, conf, ep.getInternalWorkingMemory(), ep);
            fh.setNegated(this.negated);
            fh.setParentHandle(this);
            return fh;
        }

        @Override
        public InternalDataSource<?> getDataSource() {
            return this.dataSource;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        @Override
        public boolean isNegated() {
            return this.negated;
        }

        @Override
        public void setNegated(boolean negated) {
            this.negated = negated;
        }

        @Override
        public int getIdentityHashCode() {
            return this.identityHashCode;
        }

        @Override
        public long getRecency() {
            return this.recency;
        }

        @Override
        public void setRecency(long recency) {
            this.recency = recency;
        }

        @Override
        public String getObjectClassName() {
            return this.object.getClass().getName();
        }

        @Override
        public void setObject(Object object) {
            this.object = object;
        }

        @Override
        public void setEqualityKey(EqualityKey key) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.setEqualityKey -> TODO");
        }

        @Override
        public EqualityKey getEqualityKey() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.getEqualityKey -> TODO");
        }

        @Override
        public void invalidate() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.invalidate -> TODO");
        }

        @Override
        public boolean isValid() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.isValid -> TODO");
        }

        @Override
        public int getObjectHashCode() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.getObjectHashCode -> TODO");
        }

        @Override
        public boolean isDisconnected() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.isDisconnected -> TODO");
        }

        @Override
        public boolean isEvent() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.isEvent -> TODO");
        }

        @Override
        public boolean isTraitOrTraitable() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.isTraitOrTraitable -> TODO");
        }

        @Override
        public boolean isTraitable() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.isTraitable -> TODO");
        }

        @Override
        public boolean isTraiting() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.isTraiting -> TODO");
        }

        @Override
        public TraitTypeEnum getTraitType() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.getTraitType -> TODO");
        }

        @Override
        public RightTuple getFirstRightTuple() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.getFirstRightTuple -> TODO");
        }

        @Override
        public LeftTuple getFirstLeftTuple() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.getFirstLeftTuple -> TODO");
        }

        @Override
        public WorkingMemoryEntryPoint getEntryPoint() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.getEntryPoint -> TODO");
        }

        @Override
        public void setEntryPoint(WorkingMemoryEntryPoint ep) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.setEntryPoint -> TODO");
        }

        @Override
        public InternalFactHandle clone() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.clone -> TODO");
        }

        @Override
        public String toExternalForm() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.toExternalForm -> TODO");
        }

        @Override
        public void disconnect() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.disconnect -> TODO");
        }

        @Override
        public void addFirstLeftTuple(LeftTuple leftTuple) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.addFirstLeftTuple -> TODO");
        }

        @Override
        public void addLastLeftTuple(LeftTuple leftTuple) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.addLastLeftTuple -> TODO");
        }

        @Override
        public void removeLeftTuple(LeftTuple leftTuple) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.removeLeftTuple -> TODO");
        }

        @Override
        public void clearLeftTuples() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.clearLeftTuples -> TODO");
        }

        @Override
        public void clearRightTuples() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.clearRightTuples -> TODO");
        }

        @Override
        public void addFirstRightTuple(RightTuple rightTuple) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.addFirstRightTuple -> TODO");
        }

        @Override
        public void addLastRightTuple(RightTuple rightTuple) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.addLastRightTuple -> TODO");
        }

        @Override
        public void removeRightTuple(RightTuple rightTuple) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.removeRightTuple -> TODO");
        }

        @Override
        public void addTupleInPosition(Tuple tuple) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.addTupleInPosition -> TODO");
        }

        @Override
        public <K> K as(Class<K> klass) throws ClassCastException {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.as -> TODO");
        }

        @Override
        public boolean isExpired() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.isExpired -> TODO");
        }

        @Override
        public boolean isPendingRemoveFromStore() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.isPendingRemoveFromStore -> TODO");
        }

        @Override
        public void forEachRightTuple(Consumer<RightTuple> rightTupleConsumer) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.forEachRightTuple -> TODO");
        }

        @Override
        public void forEachLeftTuple(Consumer<LeftTuple> leftTupleConsumer) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.forEachLeftTuple -> TODO");
        }

        @Override
        public RightTuple findFirstRightTuple(Predicate<RightTuple> rightTuplePredicate) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.findFirstRightTuple -> TODO");
        }

        @Override
        public LeftTuple findFirstLeftTuple(Predicate<LeftTuple> lefttTuplePredicate) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.findFirstLeftTuple -> TODO");
        }

        @Override
        public void setFirstLeftTuple(LeftTuple firstLeftTuple) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.setFirstLeftTuple -> TODO");
        }

        @Override
        public InternalFactHandle.LinkedTuples detachLinkedTuples() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.detachLinkedTuples -> TODO");
        }

        @Override
        public InternalFactHandle.LinkedTuples detachLinkedTuplesForPartition(int i) {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.detachLinkedTuplesForPartition -> TODO");
        }

        @Override
        public InternalFactHandle.LinkedTuples getLinkedTuples() {
            throw new UnsupportedOperationException("org.drools.core.datasources.CursoredDataSource.DataSourceFactHandle.getLinkedTuples -> TODO");
        }
    }

    static class Delete
    extends AbstractDataSourcePropagation {
        private final DataSourceFactHandle dsFactHandle;
        private final Activation activation;

        Delete(DataSourceFactHandle factHandle, Activation activation) {
            this.dsFactHandle = factHandle;
            this.activation = activation;
        }

        @Override
        public void execute(EntryPoint entryPoint) {
            WorkingMemoryEntryPoint ep = (WorkingMemoryEntryPoint)entryPoint;
            ObjectTypeConf typeConf = ep.getObjectTypeConfigurationRegistry().getObjectTypeConf(ep.getEntryPoint(), this.dsFactHandle.getObject());
            RuleUnit ruleUnit = ep.getInternalWorkingMemory().getRuleUnitExecutor().getCurrentRuleUnit();
            InternalFactHandle handle = (InternalFactHandle)this.dsFactHandle.childHandles.get(ruleUnit.getUnitIdentity());
            PropagationContextFactory pctxFactory = ((InternalWorkingMemoryEntryPoint)ep).getPctxFactory();
            PropagationContext context = pctxFactory.createPropagationContext(ep.getInternalWorkingMemory().getNextPropagationIdCounter(), PropagationContext.Type.DELETION, this.activation == null ? null : this.activation.getRule(), this.activation == null ? null : (TerminalNode)this.activation.getTuple().getTupleSink(), handle, ep.getEntryPoint());
            ep.getEntryPointNode().propagateRetract(handle, context, typeConf, ep.getInternalWorkingMemory());
        }
    }

    static class Update
    extends AbstractDataSourcePropagation {
        private final DataSourceFactHandle dsFactHandle;
        private final Object object;
        private final BitMask mask;
        private final Class<?> modifiedClass;
        private final Activation activation;

        Update(DataSourceFactHandle factHandle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
            this.dsFactHandle = factHandle;
            this.object = object;
            this.mask = mask;
            this.modifiedClass = modifiedClass;
            this.activation = activation;
        }

        @Override
        public void execute(EntryPoint entryPoint) {
            WorkingMemoryEntryPoint ep = (WorkingMemoryEntryPoint)entryPoint;
            ObjectTypeConf typeConf = ep.getObjectTypeConfigurationRegistry().getObjectTypeConf(ep.getEntryPoint(), this.object);
            RuleUnit ruleUnit = ep.getInternalWorkingMemory().getRuleUnitExecutor().getCurrentRuleUnit();
            InternalFactHandle handle = (InternalFactHandle)this.dsFactHandle.childHandles.get(ruleUnit.getUnitIdentity());
            PropagationContextFactory pctxFactory = ((InternalWorkingMemoryEntryPoint)ep).getPctxFactory();
            PropagationContext context = pctxFactory.createPropagationContext(ep.getInternalWorkingMemory().getNextPropagationIdCounter(), PropagationContext.Type.MODIFICATION, this.activation == null ? null : this.activation.getRule(), this.activation == null ? null : (TerminalNode)this.activation.getTuple().getTupleSink(), handle, ep.getEntryPoint(), this.mask, this.modifiedClass, null);
            EntryPointNode.propagateModify(handle, context, typeConf, ep.getInternalWorkingMemory());
        }
    }

    static class Insert
    extends AbstractDataSourcePropagation {
        private final DataSourceFactHandle dsFactHandle;

        Insert(DataSourceFactHandle factHandle) {
            this.dsFactHandle = factHandle;
        }

        @Override
        public void execute(EntryPoint entryPoint) {
            WorkingMemoryEntryPoint ep = (WorkingMemoryEntryPoint)entryPoint;
            ObjectTypeConf typeConf = ep.getObjectTypeConfigurationRegistry().getObjectTypeConf(ep.getEntryPoint(), this.dsFactHandle.getObject());
            InternalFactHandle handleForEp = this.dsFactHandle.createFactHandleFor(ep, typeConf);
            RuleUnit ruleUnit = ep.getInternalWorkingMemory().getRuleUnitExecutor().getCurrentRuleUnit();
            this.dsFactHandle.childHandles.put(ruleUnit.getUnitIdentity(), handleForEp);
            PropagationContextFactory pctxFactory = ((InternalWorkingMemoryEntryPoint)ep).getPctxFactory();
            PropagationContext context = pctxFactory.createPropagationContext(ep.getInternalWorkingMemory().getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handleForEp, ep.getEntryPoint());
            for (ObjectTypeNode otn : typeConf.getObjectTypeNodes()) {
                otn.propagateAssert(handleForEp, context, ep.getInternalWorkingMemory());
            }
        }
    }

    static abstract class AbstractDataSourcePropagation
    extends PropagationEntry.AbstractPropagationEntry {
        private EntryPoint ep;

        AbstractDataSourcePropagation() {
        }

        public AbstractDataSourcePropagation setEntryPoint(EntryPoint ep) {
            this.ep = ep;
            return this;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            this.execute(this.ep);
        }

        public abstract void execute(EntryPoint var1);
    }
}

