/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.phreak.Reactive;
import org.drools.core.util.ClassUtils;
import org.kie.api.definition.type.Annotation;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;

public class ClassDefinition
implements FactType {
    private String className;
    private String superClass;
    private String[] interfaces;
    private transient Class<?> definedClass;
    private TRAITING_MODE traitable;
    private boolean abstrakt = false;
    private Map<String, Object> metaData;
    private LinkedHashMap<String, FieldDefinition> fields = new LinkedHashMap();
    private Map<String, AnnotationDefinition> annotations;
    private Map<String, List<String>> modifiedPropsByMethod;

    public ClassDefinition() {
        this(null, null, null);
    }

    public ClassDefinition(String className) {
        this(className, null, null);
    }

    public ClassDefinition(String className, String superClass, String[] interfaces) {
        this.setClassName(className);
        this.setSuperClass(superClass);
        this.setInterfaces(interfaces);
    }

    public ClassDefinition(Class<?> cls) {
        this.definedClass = cls;
        this.setClassName(cls.getCanonicalName());
        this.setSuperClass(cls.getSuperclass() != null ? cls.getSuperclass().getCanonicalName() : null);
        String[] interfaces = new String[cls.getInterfaces().length];
        int i = 0;
        for (Class<?> interfaze : cls.getInterfaces()) {
            interfaces[i++] = interfaze.getCanonicalName();
        }
        this.setInterfaces(interfaces);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.superClass = (String)in.readObject();
        this.interfaces = (String[])in.readObject();
        this.fields = (LinkedHashMap)in.readObject();
        this.annotations = (Map)in.readObject();
        this.modifiedPropsByMethod = (Map)in.readObject();
        this.traitable = (TRAITING_MODE)((Object)in.readObject());
        this.abstrakt = in.readBoolean();
        this.metaData = (HashMap)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.superClass);
        out.writeObject(this.interfaces);
        out.writeObject(this.fields);
        out.writeObject(this.annotations);
        out.writeObject(this.modifiedPropsByMethod);
        out.writeObject((Object)this.traitable);
        out.writeBoolean(this.abstrakt);
        out.writeObject(this.metaData);
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setClassName(String className) {
        this.className = className;
    }

    public final Class<?> getDefinedClass() {
        return this.definedClass;
    }

    public void setDefinedClass(Class<?> definedClass) {
        this.definedClass = definedClass;
    }

    public final void addField(FieldDefinition attr) {
        this.fields.put(attr.getName(), attr);
    }

    public final Collection<FieldDefinition> getFieldsDefinitions() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    public final FieldDefinition getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public FieldDefinition getFieldByAlias(String alias) {
        for (FactField factField : this.getFields()) {
            FieldDefinition def = (FieldDefinition)factField;
            if (!def.resolveAlias().equals(alias)) continue;
            return def;
        }
        return null;
    }

    public FieldDefinition getField(int index) {
        if (index >= this.fields.size() || index < 0) {
            return null;
        }
        Iterator<FieldDefinition> iter = this.fields.values().iterator();
        for (int j = 0; j < index; ++j) {
            iter.next();
        }
        return iter.next();
    }

    public final String[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces != null ? interfaces : new String[]{};
    }

    public final String getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(String superClass) {
        this.superClass = superClass != null ? superClass : "java.lang.Object";
    }

    public String getName() {
        return this.getClassName();
    }

    public String getSimpleName() {
        return this.getClassName().substring(this.getClassName().lastIndexOf(46) + 1);
    }

    public String getPackageName() {
        return this.getClassName().substring(0, this.getClassName().lastIndexOf(46));
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return this.definedClass.newInstance();
    }

    public Class<?> getFactClass() {
        return this.getDefinedClass();
    }

    public List<FactField> getFields() {
        return new ArrayList<FactField>(this.fields.values());
    }

    public Object get(Object bean, String field) {
        FieldDefinition fieldDefinition = this.getField(field);
        if (fieldDefinition != null) {
            return fieldDefinition.getFieldAccessor().getValue(bean);
        }
        Field f = ClassUtils.getField(this.definedClass, field);
        if (f != null) {
            f.setAccessible(true);
            try {
                return f.get(bean);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void set(Object bean, String field, Object value) {
        FieldDefinition fieldDefinition = this.getField(field);
        if (fieldDefinition != null) {
            fieldDefinition.getFieldAccessor().setValue(bean, value);
        } else {
            Field f = ClassUtils.getField(this.definedClass, field);
            if (f != null) {
                f.setAccessible(true);
                try {
                    f.set(bean, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Map<String, Object> getAsMap(Object bean) {
        HashMap<String, Object> m = new HashMap<String, Object>(this.fields.size());
        for (Map.Entry<String, FieldDefinition> ent : this.fields.entrySet()) {
            Object val = ent.getValue().getFieldAccessor().getValue(bean);
            m.put(ent.getKey(), val);
        }
        return m;
    }

    public void setFromMap(Object bean, Map<String, Object> data) {
        for (Map.Entry<String, Object> ent : data.entrySet()) {
            this.set(bean, ent.getKey(), ent.getValue());
        }
    }

    public void addAnnotation(AnnotationDefinition annotationDefinition) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, AnnotationDefinition>();
        }
        this.annotations.put(annotationDefinition.getName(), annotationDefinition);
    }

    public Collection<AnnotationDefinition> getAnnotations() {
        return this.annotations != null ? this.annotations.values() : Collections.emptyList();
    }

    public AnnotationDefinition getAnnotation(Class<?> annotationClass) {
        return this.annotations != null ? this.annotations.get(annotationClass.getName()) : null;
    }

    public List<Annotation> getClassAnnotations() {
        return Collections.unmodifiableList(new ArrayList<AnnotationDefinition>(this.getAnnotations()));
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void addMetaData(String key, Object value) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>();
        }
        this.metaData.put(key, value);
    }

    public void addModifiedPropsByMethod(Method method, List<String> props) {
        if (this.modifiedPropsByMethod == null) {
            this.modifiedPropsByMethod = new HashMap<String, List<String>>();
        }
        String methodName = ClassDefinition.modifiedPropsByMethodKey(method);
        this.modifiedPropsByMethod.put(methodName, props);
    }

    public List<String> getModifiedPropsByMethod(Method method) {
        return this.getModifiedPropsByMethod(method.getName(), method.getParameterTypes().length);
    }

    public List<String> getModifiedPropsByMethod(String methodName, int args) {
        if (this.modifiedPropsByMethod == null) {
            return null;
        }
        List<String> byExactNumberOfArgs = this.modifiedPropsByMethod.get(methodName + "_" + args);
        List<String> bestEffortVarArgs = this.modifiedPropsByMethod.get(methodName + "_*");
        if (byExactNumberOfArgs != null) {
            return byExactNumberOfArgs;
        }
        return bestEffortVarArgs;
    }

    public static String modifiedPropsByMethodKey(Method method) {
        return method.getName() + "_" + (method.isVarArgs() ? "*" : Integer.valueOf(method.getParameterTypes().length));
    }

    public boolean isReactive() {
        return this.getAnnotation(Reactive.class) != null;
    }

    public boolean isTraitable() {
        return this.traitable != null && this.traitable != TRAITING_MODE.NONE;
    }

    public void setTraitable(boolean traitable) {
        this.setTraitable(traitable, false);
    }

    public void setTraitable(boolean traitable, boolean enableLogical) {
        this.traitable = !traitable ? TRAITING_MODE.NONE : (enableLogical ? TRAITING_MODE.LOGICAL : TRAITING_MODE.BASIC);
    }

    public boolean isFullTraiting() {
        return this.traitable == TRAITING_MODE.LOGICAL;
    }

    public boolean isAbstrakt() {
        return this.abstrakt;
    }

    public void setAbstrakt(boolean abstrakt) {
        this.abstrakt = abstrakt;
    }

    public String toString() {
        return "ClassDefinition{className='" + this.className + '\'' + ", superClass='" + this.superClass + '\'' + ", interfaces=" + (this.interfaces == null ? null : Arrays.asList(this.interfaces)) + ", definedClass=" + this.definedClass + ", traitable=" + (Object)((Object)this.traitable) + ", abstract=" + this.abstrakt + ", fields=" + this.fields + ", annotations=" + this.annotations + '}';
    }

    public static enum TRAITING_MODE {
        NONE,
        BASIC,
        LOGICAL;

    }
}

