/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.drools.compiler.builder.impl.CompositeKnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.AnnotationDeclarationError;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.BaseKnowledgeBuilderResultImpl;
import org.drools.compiler.compiler.CMMNCaseFactory;
import org.drools.compiler.compiler.ConfigurableSeverityResult;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.DeprecatedResourceTypeWarning;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.DroolsErrorWrapper;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.DroolsWarning;
import org.drools.compiler.compiler.DroolsWarningWrapper;
import org.drools.compiler.compiler.DuplicateFunction;
import org.drools.compiler.compiler.DuplicateRule;
import org.drools.compiler.compiler.GlobalError;
import org.drools.compiler.compiler.GuidedDecisionTableFactory;
import org.drools.compiler.compiler.GuidedDecisionTableProvider;
import org.drools.compiler.compiler.GuidedRuleTemplateFactory;
import org.drools.compiler.compiler.GuidedRuleTemplateProvider;
import org.drools.compiler.compiler.GuidedScoreCardFactory;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.compiler.PackageBuilderResults;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.ParserError;
import org.drools.compiler.compiler.ProcessBuilder;
import org.drools.compiler.compiler.ProcessBuilderFactory;
import org.drools.compiler.compiler.ProcessLoadError;
import org.drools.compiler.compiler.ResourceConversionResult;
import org.drools.compiler.compiler.ResourceTypeDeclarationWarning;
import org.drools.compiler.compiler.RuleBuildError;
import org.drools.compiler.compiler.ScoreCardFactory;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.compiler.xml.XmlPackageReader;
import org.drools.compiler.lang.ExpanderException;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AccumulateImportDescr;
import org.drools.compiler.lang.descr.AnnotatedBaseDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.ConditionalElementDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PatternDestinationDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.drools.compiler.lang.dsl.DSLMappingFile;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleBuilder;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.DialectError;
import org.drools.compiler.runtime.pipeline.impl.DroolsJaxbHelperProviderImpl;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.io.impl.BaseResource;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.io.impl.DescrResource;
import org.drools.core.io.impl.ReaderResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.rule.Function;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.xml.XmlChangeSetReader;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Rule;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.assembler.KieAssemblers;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.ChangeSet;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.ScoreCardConfiguration;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.io.ResourceWithConfigurationImpl;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class KnowledgeBuilderImpl
implements KnowledgeBuilder {
    private static final String JAVA_ROOT = "src/main/java/";
    protected static final transient Logger logger = LoggerFactory.getLogger(KnowledgeBuilderImpl.class);
    private final Map<String, PackageRegistry> pkgRegistryMap = new ConcurrentHashMap<String, PackageRegistry>();
    private List<KnowledgeBuilderResult> results;
    private final KnowledgeBuilderConfigurationImpl configuration;
    private InternalKnowledgeBase kBase;
    private final String defaultDialect;
    private ClassLoader rootClassLoader;
    private int parallelRulesBuildThreshold;
    private final Map<String, Class<?>> globals = new HashMap();
    private Resource resource;
    private List<DSLTokenizedMappingFile> dslFiles;
    private final ProcessBuilder processBuilder;
    private final Map<String, Map<String, AttributeDescr>> packageAttributes = new HashMap<String, Map<String, AttributeDescr>>();
    private final Map<String, List<PackageDescr>> packages = new ConcurrentHashMap<String, List<PackageDescr>>();
    private final Stack<List<Resource>> buildResources = new Stack();
    private AssetFilter assetFilter = null;
    private final TypeDeclarationBuilder typeBuilder;
    private Map<String, Object> builderCache;

    public KnowledgeBuilderImpl() {
        this((InternalKnowledgeBase)null, null);
    }

    public KnowledgeBuilderImpl(InternalKnowledgePackage pkg) {
        this(pkg, null);
    }

    public KnowledgeBuilderImpl(InternalKnowledgeBase kBase) {
        this(kBase, null);
    }

    public KnowledgeBuilderImpl(KnowledgeBuilderConfigurationImpl configuration) {
        this((InternalKnowledgeBase)null, configuration);
    }

    public KnowledgeBuilderImpl(InternalKnowledgePackage pkg, KnowledgeBuilderConfigurationImpl configuration) {
        this.configuration = configuration == null ? new KnowledgeBuilderConfigurationImpl() : configuration;
        this.rootClassLoader = this.configuration.getClassLoader();
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.parallelRulesBuildThreshold = this.configuration.getParallelRulesBuildThreshold();
        this.results = new ArrayList<KnowledgeBuilderResult>();
        PackageRegistry pkgRegistry = new PackageRegistry(this.rootClassLoader, this.configuration, pkg);
        pkgRegistry.setDialect(this.defaultDialect);
        this.pkgRegistryMap.put(pkg.getName(), pkgRegistry);
        for (ImportDeclaration implDecl : pkg.getImports().values()) {
            pkgRegistry.addImport(new ImportDescr(implDecl.getTarget()));
        }
        this.processBuilder = ProcessBuilderFactory.newProcessBuilder(this);
        this.typeBuilder = new TypeDeclarationBuilder(this);
    }

    public KnowledgeBuilderImpl(InternalKnowledgeBase kBase, KnowledgeBuilderConfigurationImpl configuration) {
        this.configuration = configuration == null ? new KnowledgeBuilderConfigurationImpl() : configuration;
        this.rootClassLoader = kBase != null ? kBase.getRootClassLoader() : this.configuration.getClassLoader();
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.parallelRulesBuildThreshold = this.configuration.getParallelRulesBuildThreshold();
        this.results = new ArrayList<KnowledgeBuilderResult>();
        this.kBase = kBase;
        this.processBuilder = ProcessBuilderFactory.newProcessBuilder(this);
        this.typeBuilder = new TypeDeclarationBuilder(this);
    }

    Resource getCurrentResource() {
        return this.resource;
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    TypeDeclarationBuilder getTypeBuilder() {
        return this.typeBuilder;
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        this.addPackageFromDrl(reader, (Resource)new ReaderResource(reader, ResourceType.DRL));
    }

    public void addPackageFromDrl(Reader reader, Resource sourceResource) throws DroolsParserException, IOException {
        this.resource = sourceResource;
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(sourceResource, reader);
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.addBuilderResult(new ParserError(sourceResource, "Parser returned a null Package", 0, 0));
        }
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
        this.resource = null;
    }

    public void addPackageFromDecisionTable(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.decisionTableToPackageDescr(resource, configuration));
        this.resource = null;
    }

    PackageDescr decisionTableToPackageDescr(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        DecisionTableConfiguration dtableConfiguration;
        DecisionTableConfiguration decisionTableConfiguration = dtableConfiguration = configuration instanceof DecisionTableConfiguration ? (DecisionTableConfiguration)configuration : null;
        if (dtableConfiguration != null && !dtableConfiguration.getRuleTemplateConfigurations().isEmpty()) {
            List<String> generatedDrls = DecisionTableFactory.loadFromInputStreamWithTemplates(resource, dtableConfiguration);
            if (generatedDrls.size() == 1) {
                return this.generatedDrlToPackageDescr(resource, generatedDrls.get(0));
            }
            CompositePackageDescr compositePackageDescr = null;
            for (String generatedDrl : generatedDrls) {
                PackageDescr packageDescr = this.generatedDrlToPackageDescr(resource, generatedDrl);
                if (packageDescr == null) continue;
                if (compositePackageDescr == null) {
                    compositePackageDescr = new CompositePackageDescr(resource, packageDescr);
                    continue;
                }
                compositePackageDescr.addPackageDescr(resource, packageDescr);
            }
            return compositePackageDescr;
        }
        String generatedDrl = DecisionTableFactory.loadFromResource(resource, dtableConfiguration);
        return this.generatedDrlToPackageDescr(resource, generatedDrl);
    }

    public void addPackageFromGuidedDecisionTable(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.guidedDecisionTableToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr guidedDecisionTableToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        GuidedDecisionTableProvider guidedDecisionTableProvider = GuidedDecisionTableFactory.getGuidedDecisionTableProvider();
        ResourceConversionResult conversionResult = guidedDecisionTableProvider.loadFromInputStream(resource.getInputStream());
        return this.conversionResultToPackageDescr(resource, conversionResult);
    }

    private PackageDescr generatedDrlToPackageDescr(Resource resource, String generatedDrl) throws DroolsParserException {
        if (this.configuration.getDumpDir() != null) {
            this.dumpDrlGeneratedFromDTable(this.configuration.getDumpDir(), generatedDrl, resource.getSourcePath());
        }
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(resource, (Reader)new StringReader(generatedDrl));
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.addBuilderResult(new ParserError(resource, "Parser returned a null Package", 0, 0));
        } else {
            pkg.setResource(resource);
        }
        return parser.hasErrors() ? null : pkg;
    }

    PackageDescr generatedDslrToPackageDescr(Resource resource, String dslr) throws DroolsParserException {
        return this.dslrReaderToPackageDescr(resource, new StringReader(dslr));
    }

    private void dumpDrlGeneratedFromDTable(File dumpDir, String generatedDrl, String srcPath) {
        File dumpFile = srcPath != null ? KnowledgeBuilderImpl.createDumpDrlFile(dumpDir, srcPath, ".drl") : KnowledgeBuilderImpl.createDumpDrlFile(dumpDir, "decision-table-" + UUID.randomUUID(), ".drl");
        try {
            IoUtils.write((File)dumpFile, (byte[])generatedDrl.getBytes(IoUtils.UTF8_CHARSET));
        }
        catch (IOException ex) {
            logger.warn("Can't write the DRL generated from decision table to file " + dumpFile.getAbsolutePath() + "!\n" + Arrays.toString(ex.getStackTrace()));
        }
    }

    protected static File createDumpDrlFile(File dumpDir, String fileName, String extension) {
        return new File(dumpDir, fileName.replaceAll("[^a-zA-Z0-9\\.\\-_]+", "_") + extension);
    }

    public void addPackageFromScoreCard(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        this.resource = resource;
        ScoreCardConfiguration scardConfiguration = configuration instanceof ScoreCardConfiguration ? (ScoreCardConfiguration)configuration : null;
        String pmmlString = ScoreCardFactory.getPMMLStringFromInputStream(resource.getInputStream(), scardConfiguration);
        if (pmmlString != null) {
            this.addPackageFromScoreCard(pmmlString, "scorecard_generated.pmml");
        }
        this.resource = null;
    }

    public void addPackageFromGuidedScoreCard(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        String pmmlString = GuidedScoreCardFactory.getPMMLStringFromInputStream(resource.getInputStream());
        if (pmmlString != null) {
            this.addPackageFromScoreCard(pmmlString, "guided_scorecard_generated.pmml");
        }
        this.resource = null;
    }

    private void addPackageFromScoreCard(String pmmlString, String fileName) throws DroolsParserException, IOException {
        File dumpDir = this.configuration.getDumpDir();
        if (dumpDir != null) {
            String dirName = dumpDir.getCanonicalPath().endsWith("/") ? dumpDir.getCanonicalPath() : dumpDir.getCanonicalPath() + "/";
            String outputPath = dirName + fileName;
            try (FileOutputStream fos = new FileOutputStream(outputPath);){
                fos.write(pmmlString.getBytes());
            }
        }
        Resource res = ResourceFactory.newByteArrayResource((byte[])pmmlString.getBytes());
        try {
            ResourceWithConfigurationImpl resCon = new ResourceWithConfigurationImpl(res, null, null, null);
            this.addPackageForExternalType(ResourceType.PMML, Arrays.asList(resCon));
        }
        catch (Exception e) {
            throw new DroolsParserException(e);
        }
    }

    public void addPackageFromTemplate(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.templateToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr templateToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        GuidedRuleTemplateProvider guidedRuleTemplateProvider = GuidedRuleTemplateFactory.getGuidedRuleTemplateProvider();
        ResourceConversionResult conversionResult = guidedRuleTemplateProvider.loadFromInputStream(resource.getInputStream());
        return this.conversionResultToPackageDescr(resource, conversionResult);
    }

    private PackageDescr conversionResultToPackageDescr(Resource resource, ResourceConversionResult resourceConversionResult) throws DroolsParserException {
        ResourceType resourceType = resourceConversionResult.getType();
        if (ResourceType.DSLR.equals((Object)resourceType)) {
            return this.generatedDslrToPackageDescr(resource, resourceConversionResult.getContent());
        }
        if (ResourceType.DRL.equals((Object)resourceType)) {
            return this.generatedDrlToPackageDescr(resource, resourceConversionResult.getContent());
        }
        throw new RuntimeException("Converting generated " + resourceType + " into PackageDescr is not supported!");
    }

    public void addPackageFromDrl(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.drlToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr drlToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        PackageDescr pkg;
        boolean hasErrors = false;
        if (resource instanceof DescrResource) {
            pkg = (PackageDescr)((DescrResource)resource).getDescr();
        } else {
            DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
            pkg = parser.parse(resource);
            this.results.addAll(parser.getErrors());
            if (pkg == null) {
                this.addBuilderResult(new ParserError(resource, "Parser returned a null Package", 0, 0));
            }
            hasErrors = parser.hasErrors();
        }
        if (pkg != null) {
            pkg.setResource(resource);
        }
        return hasErrors ? null : pkg;
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        this.resource = new ReaderResource(reader, ResourceType.XDRL);
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        xmlReader.getParser().setClassLoader(this.rootClassLoader);
        try {
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
        this.resource = null;
    }

    public void addPackageFromXml(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.xmlToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr xmlToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        xmlReader.getParser().setClassLoader(this.rootClassLoader);
        try (Reader reader = null;){
            reader = resource.getReader();
            xmlReader.read(reader);
        }
        return xmlReader.getPackageDescr();
    }

    public void addPackageFromDrl(Reader source, Reader dsl) throws DroolsParserException, IOException {
        this.resource = new ReaderResource(source, ResourceType.DSLR);
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(source, dsl);
        this.results.addAll(parser.getErrors());
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
        this.resource = null;
    }

    public void addPackageFromDslr(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.dslrToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr dslrToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        return this.dslrReaderToPackageDescr(resource, resource.getReader());
    }

    private PackageDescr dslrReaderToPackageDescr(Resource resource, Reader dslrReader) throws DroolsParserException {
        boolean hasErrors;
        PackageDescr pkg;
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        DefaultExpander expander = this.getDslExpander();
        try {
            if (expander == null) {
                expander = new DefaultExpander();
            }
            String str = expander.expand(dslrReader);
            if (expander.hasErrors()) {
                for (ExpanderException error : expander.getErrors()) {
                    error.setResource(resource);
                    this.addBuilderResult(error);
                }
            }
            pkg = parser.parse(resource, str);
            this.results.addAll(parser.getErrors());
            hasErrors = parser.hasErrors();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dslrReader != null) {
                try {
                    dslrReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hasErrors ? null : pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDsl(Resource resource) throws IOException {
        this.resource = resource;
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        Reader reader = null;
        try {
            reader = resource.getReader();
            if (!file.parseAndLoad(reader)) {
                this.results.addAll(file.getErrors());
            }
            if (this.dslFiles == null) {
                this.dslFiles = new ArrayList<DSLTokenizedMappingFile>();
            }
            this.dslFiles.add(file);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            this.resource = null;
        }
    }

    public void addRuleFlow(Reader processSource) {
        this.addProcessFromXml(processSource);
    }

    public void addProcessFromXml(Resource resource) {
        if (this.processBuilder == null) {
            throw new RuntimeException("Unable to instantiate a process assembler");
        }
        if (ResourceType.DRF.equals((Object)resource.getResourceType())) {
            this.addBuilderResult(new DeprecatedResourceTypeWarning(resource, "RF"));
        }
        this.resource = resource;
        try {
            List<Process> processes = this.processBuilder.addProcessFromXml(resource);
            List<BaseKnowledgeBuilderResultImpl> errors = this.processBuilder.getErrors();
            if (errors.isEmpty()) {
                if (this.kBase != null && processes != null) {
                    for (Process process : processes) {
                        if (!this.filterAccepts(ResourceChange.Type.PROCESS, process.getNamespace(), process.getId())) continue;
                        this.kBase.addProcess(process);
                    }
                }
            } else {
                this.results.addAll(errors);
                errors.clear();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.addBuilderResult(new ProcessLoadError(resource, "Unable to load process.", e));
        }
        this.results = this.getResults(this.results);
        this.resource = null;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public void addProcessFromXml(Reader processSource) {
        this.addProcessFromXml((Resource)new ReaderResource(processSource, ResourceType.DRF));
    }

    public void addKnowledgeResource(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        try {
            ((InternalResource)resource).setResourceType(type);
            if (ResourceType.DRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.GDRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.RDRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.DESCR.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.DSLR.equals((Object)type)) {
                this.addPackageFromDslr(resource);
            } else if (ResourceType.RDSLR.equals((Object)type)) {
                this.addPackageFromDslr(resource);
            } else if (ResourceType.DSL.equals((Object)type)) {
                this.addDsl(resource);
            } else if (ResourceType.XDRL.equals((Object)type)) {
                this.addPackageFromXml(resource);
            } else if (ResourceType.DRF.equals((Object)type)) {
                this.addProcessFromXml(resource);
            } else if (ResourceType.BPMN2.equals((Object)type)) {
                BPMN2ProcessFactory.configurePackageBuilder(this);
                this.addProcessFromXml(resource);
            } else if (ResourceType.CMMN.equals((Object)type)) {
                CMMNCaseFactory.configurePackageBuilder(this);
                this.addProcessFromXml(resource);
            } else if (ResourceType.DTABLE.equals((Object)type)) {
                this.addPackageFromDecisionTable(resource, configuration);
            } else if (ResourceType.PKG.equals((Object)type)) {
                this.addPackageFromInputStream(resource);
            } else if (ResourceType.CHANGE_SET.equals((Object)type)) {
                this.addPackageFromChangeSet(resource);
            } else if (ResourceType.XSD.equals((Object)type)) {
                this.addPackageFromXSD(resource, (JaxbConfigurationImpl)configuration);
            } else if (ResourceType.SCARD.equals((Object)type)) {
                this.addPackageFromScoreCard(resource, configuration);
            } else if (ResourceType.TDRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.TEMPLATE.equals((Object)type)) {
                this.addPackageFromTemplate(resource);
            } else if (ResourceType.GDST.equals((Object)type)) {
                this.addPackageFromGuidedDecisionTable(resource);
            } else if (ResourceType.SCGD.equals((Object)type)) {
                this.addPackageFromGuidedScoreCard(resource);
            } else {
                this.addPackageForExternalType(resource, type, configuration);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    void addPackageForExternalType(Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        KieAssemblers assemblers = (KieAssemblers)ServiceRegistry.getInstance().get(KieAssemblers.class);
        KieAssemblerService assembler = (KieAssemblerService)assemblers.getAssemblers().get(type);
        if (assembler == null) {
            throw new RuntimeException("Unknown resource type: " + type);
        }
        assembler.addResource((Object)this, resource, type, configuration);
    }

    void addPackageForExternalType(ResourceType type, List<ResourceWithConfiguration> resources) throws Exception {
        KieAssemblers assemblers = (KieAssemblers)ServiceRegistry.getInstance().get(KieAssemblers.class);
        KieAssemblerService assembler = (KieAssemblerService)assemblers.getAssemblers().get(type);
        if (assembler == null) {
            throw new RuntimeException("Unknown resource type: " + type);
        }
        assembler.addResources((Object)this, resources, type);
    }

    void addPackageFromXSD(Resource resource, JaxbConfigurationImpl configuration) throws IOException {
        if (configuration != null) {
            String[] classes;
            for (String cls : classes = DroolsJaxbHelperProviderImpl.addXsdModel(resource, this, configuration.getXjcOpts(), configuration.getSystemId())) {
                configuration.getClasses().add(cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPackageFromChangeSet(Resource resource) throws SAXException, IOException {
        XmlChangeSetReader reader = new XmlChangeSetReader(this.configuration.getSemanticModules());
        if (resource instanceof ClassPathResource) {
            reader.setClassLoader(((ClassPathResource)resource).getClassLoader(), ((ClassPathResource)resource).getClazz());
        } else {
            reader.setClassLoader(this.configuration.getClassLoader(), null);
        }
        try (Reader resourceReader = null;){
            resourceReader = resource.getReader();
            ChangeSet changeSet = reader.read(resourceReader);
            if (changeSet == null) {
                // empty if block
            }
            for (Resource nestedResource : changeSet.getResourcesAdded()) {
                InternalResource iNestedResourceResource = (InternalResource)nestedResource;
                if (iNestedResourceResource.isDirectory()) {
                    for (Resource childResource : iNestedResourceResource.listResources()) {
                        if (((InternalResource)childResource).isDirectory()) continue;
                        ((InternalResource)childResource).setResourceType(iNestedResourceResource.getResourceType());
                        this.addKnowledgeResource(childResource, iNestedResourceResource.getResourceType(), iNestedResourceResource.getConfiguration());
                    }
                    continue;
                }
                this.addKnowledgeResource((Resource)iNestedResourceResource, iNestedResourceResource.getResourceType(), iNestedResourceResource.getConfiguration());
            }
        }
    }

    void addPackageFromInputStream(final Resource resource) throws IOException, ClassNotFoundException {
        InputStream is = resource.getInputStream();
        Object object = DroolsStreamUtils.streamIn((InputStream)is, (ClassLoader)this.configuration.getClassLoader());
        is.close();
        if (object instanceof Collection) {
            Collection pkgs = (Collection)object;
            for (KiePackage kpkg : pkgs) {
                this.overrideReSource((InternalKnowledgePackage)((KnowledgePackageImpl)kpkg), resource);
                this.addPackage((InternalKnowledgePackage)((KnowledgePackageImpl)kpkg));
            }
        } else if (object instanceof KnowledgePackageImpl) {
            KnowledgePackageImpl kpkg = (KnowledgePackageImpl)object;
            this.overrideReSource((InternalKnowledgePackage)kpkg, resource);
            this.addPackage((InternalKnowledgePackage)kpkg);
        } else {
            this.results.add(new DroolsError(resource){

                @Override
                public String getMessage() {
                    return "Unknown binary format trying to load resource " + resource.toString();
                }

                @Override
                public int[] getLines() {
                    return new int[0];
                }
            });
        }
    }

    private void overrideReSource(InternalKnowledgePackage pkg, Resource res) {
        for (Rule r : pkg.getRules()) {
            if (!this.isSwappable(((RuleImpl)r).getResource(), res)) continue;
            ((RuleImpl)r).setResource(res);
        }
        for (TypeDeclaration d : pkg.getTypeDeclarations().values()) {
            if (!this.isSwappable(d.getResource(), res)) continue;
            d.setResource(res);
        }
        for (Function f : pkg.getFunctions().values()) {
            if (!this.isSwappable(f.getResource(), res)) continue;
            f.setResource(res);
        }
        for (Process p : pkg.getRuleFlows().values()) {
            if (!this.isSwappable(p.getResource(), res)) continue;
            p.setResource(res);
        }
    }

    private boolean isSwappable(Resource original, Resource source) {
        return original == null || original instanceof ReaderResource && ((ReaderResource)original).getReader() == null;
    }

    public void addPackage(PackageDescr packageDescr) {
        PackageRegistry pkgRegistry = this.getOrCreatePackageRegistry(packageDescr);
        if (pkgRegistry == null) {
            return;
        }
        this.mergePackage(pkgRegistry, packageDescr);
        this.compileKnowledgePackages(packageDescr, pkgRegistry);
        this.wireAllRules();
        this.compileRete(packageDescr);
    }

    protected void compileKnowledgePackages(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        pkgRegistry.setDialect(this.getPackageDialect(packageDescr));
        this.validateUniqueRuleNames(packageDescr);
        this.compileFunctions(packageDescr, pkgRegistry);
        this.compileRules(packageDescr, pkgRegistry);
    }

    protected void wireAllRules() {
        this.compileAll();
        try {
            this.reloadAll();
        }
        catch (Exception e) {
            this.addBuilderResult(new DialectError(null, "Unable to wire compiled classes, probably related to compilation failures:" + e.getMessage()));
        }
        this.updateResults();
    }

    protected void processKieBaseTypes() {
        if (!this.hasErrors() && this.kBase != null) {
            ArrayList<InternalKnowledgePackage> pkgs = new ArrayList<InternalKnowledgePackage>();
            for (PackageRegistry pkgReg : this.pkgRegistryMap.values()) {
                pkgs.add(pkgReg.getPackage());
            }
            this.kBase.processAllTypesDeclaration(pkgs);
        }
    }

    protected void compileRete(PackageDescr packageDescr) {
        if (!this.hasErrors() && this.kBase != null) {
            ArrayList<RuleImpl> rulesToBeAdded = new ArrayList<RuleImpl>();
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())) continue;
                InternalKnowledgePackage pkg = this.pkgRegistryMap.get(ruleDescr.getNamespace()).getPackage();
                rulesToBeAdded.add(pkg.getRule(ruleDescr.getName()));
            }
            if (!rulesToBeAdded.isEmpty()) {
                this.kBase.addRules(rulesToBeAdded);
            }
        }
    }

    public void addBuilderResult(KnowledgeBuilderResult result) {
        this.results.add(result);
    }

    public PackageRegistry getOrCreatePackageRegistry(PackageDescr packageDescr) {
        if (packageDescr == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)packageDescr.getNamespace())) {
            packageDescr.setNamespace(this.configuration.getDefaultPackageName());
        }
        return this.pkgRegistryMap.computeIfAbsent(packageDescr.getName(), name -> this.createPackageRegistry(packageDescr));
    }

    private PackageRegistry createPackageRegistry(PackageDescr packageDescr) {
        KnowledgePackageImpl pkg;
        this.initPackage(packageDescr);
        if (this.kBase == null || (pkg = this.kBase.getPackage(packageDescr.getName())) == null) {
            pkg = new KnowledgePackageImpl(packageDescr.getName());
            pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.rootClassLoader));
            if (this.kBase != null) {
                try {
                    pkg = (InternalKnowledgePackage)this.kBase.addPackage((KiePackage)pkg).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                pkg.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
            }
        }
        PackageRegistry pkgRegistry = new PackageRegistry(this.rootClassLoader, this.configuration, (InternalKnowledgePackage)pkg);
        pkgRegistry.addImport(new ImportDescr(packageDescr.getNamespace() + ".*"));
        for (ImportDescr importDescr : packageDescr.getImports()) {
            pkgRegistry.registerImport(importDescr.getTarget());
        }
        return pkgRegistry;
    }

    private void initPackage(PackageDescr packageDescr) {
        List packageDescrsForPackage = this.packages.computeIfAbsent(packageDescr.getName(), k -> new ArrayList());
        packageDescrsForPackage.add(packageDescr);
        HashSet<ImportDescr> imports = new HashSet<ImportDescr>();
        for (PackageDescr pd : packageDescrsForPackage) {
            imports.addAll(pd.getImports());
        }
        for (PackageDescr pd : packageDescrsForPackage) {
            pd.getImports().clear();
            pd.addAllImports(imports);
        }
        if (!packageDescr.getAttributes().isEmpty()) {
            Map<String, AttributeDescr> pkgAttributes = this.packageAttributes.get(packageDescr.getNamespace());
            if (pkgAttributes == null) {
                pkgAttributes = new HashMap<String, AttributeDescr>();
                this.packageAttributes.put(packageDescr.getNamespace(), pkgAttributes);
            }
            for (AttributeDescr attr : packageDescr.getAttributes()) {
                pkgAttributes.put(attr.getName(), attr);
            }
        }
    }

    private void compileFunctions(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        List<FunctionDescr> functions = packageDescr.getFunctions();
        if (!functions.isEmpty()) {
            for (FunctionDescr functionDescr : functions) {
                if (StringUtils.isEmpty((CharSequence)functionDescr.getNamespace())) {
                    functionDescr.setNamespace(packageDescr.getNamespace());
                }
                functionDescr.setDialect("java");
                this.preCompileAddFunction(functionDescr, pkgRegistry);
            }
            for (FunctionDescr functionDescr : functions) {
                if (!this.filterAccepts(ResourceChange.Type.FUNCTION, functionDescr.getNamespace(), functionDescr.getName())) continue;
                this.addFunction(functionDescr, pkgRegistry);
            }
            this.compileAll();
            for (FunctionDescr functionDescr : functions) {
                if (!this.filterAccepts(ResourceChange.Type.FUNCTION, functionDescr.getNamespace(), functionDescr.getName())) continue;
                this.postCompileAddFunction(functionDescr, pkgRegistry);
            }
        }
    }

    private void compileRules(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        this.preProcessRules(packageDescr, pkgRegistry);
        SortedRules sortedRules = this.sortRulesByDependency(packageDescr, pkgRegistry);
        if (!sortedRules.queries.isEmpty()) {
            this.compileAllQueries(packageDescr, pkgRegistry, sortedRules.queries);
        }
        for (List<RuleDescr> rulesLevel : sortedRules.rules) {
            this.compileRulesLevel(packageDescr, pkgRegistry, rulesLevel);
        }
    }

    private void compileAllQueries(PackageDescr packageDescr, PackageRegistry pkgRegistry, List<RuleDescr> rules) {
        Map<String, RuleBuildContext> ruleCxts = this.buildRuleBuilderContexts(rules, pkgRegistry);
        for (RuleDescr ruleDescr : rules) {
            if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())) continue;
            this.initRuleDescr(packageDescr, pkgRegistry, ruleDescr);
            this.results.addAll(this.addRule(ruleCxts.get(ruleDescr.getName())));
        }
    }

    private void compileRulesLevel(PackageDescr packageDescr, PackageRegistry pkgRegistry, List<RuleDescr> rules) {
        boolean parallelRulesBuild;
        boolean bl = parallelRulesBuild = this.kBase == null && this.parallelRulesBuildThreshold != -1 && rules.size() > this.parallelRulesBuildThreshold;
        if (parallelRulesBuild) {
            ConcurrentHashMap ruleCxts = new ConcurrentHashMap();
            ForkJoinPool pool = new ForkJoinPool();
            try {
                ((ForkJoinTask)pool.submit(() -> ((Stream)rules.stream().parallel()).filter(ruleDescr -> this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())).forEach(ruleDescr -> {
                    this.initRuleDescr(packageDescr, pkgRegistry, (RuleDescr)ruleDescr);
                    RuleBuildContext context = this.buildRuleBuilderContext(pkgRegistry, (RuleDescr)ruleDescr);
                    ruleCxts.put(ruleDescr.getName(), context);
                    List<? extends KnowledgeBuilderResult> results = this.addRule(context);
                    if (!results.isEmpty()) {
                        List<KnowledgeBuilderResult> list = this.results;
                        synchronized (list) {
                            this.results.addAll(results);
                        }
                    }
                }))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Rules compilation failed or interrupted", e);
            }
            for (RuleDescr ruleDescr : rules) {
                RuleBuildContext context = (RuleBuildContext)ruleCxts.get(ruleDescr.getName());
                if (context == null) continue;
                pkgRegistry.getPackage().addRule(context.getRule());
            }
        } else {
            for (RuleDescr ruleDescr : rules) {
                if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())) continue;
                this.initRuleDescr(packageDescr, pkgRegistry, ruleDescr);
                RuleBuildContext context = this.buildRuleBuilderContext(pkgRegistry, ruleDescr);
                this.results.addAll(this.addRule(context));
                pkgRegistry.getPackage().addRule(context.getRule());
            }
        }
    }

    private void initRuleDescr(PackageDescr packageDescr, PackageRegistry pkgRegistry, RuleDescr ruleDescr) {
        if (StringUtils.isEmpty((CharSequence)ruleDescr.getNamespace())) {
            ruleDescr.setNamespace(packageDescr.getNamespace());
        }
        this.inheritPackageAttributes(this.packageAttributes.get(packageDescr.getNamespace()), ruleDescr);
        if (StringUtils.isEmpty((CharSequence)ruleDescr.getDialect())) {
            ruleDescr.addAttribute(new AttributeDescr("dialect", pkgRegistry.getDialect()));
        }
    }

    private List<? extends KnowledgeBuilderResult> addRule(RuleBuildContext context) {
        RuleBuilder.build(context);
        context.getRule().setResource(context.getRuleDescr().getResource());
        context.getDialect().addRule(context);
        if (context.needsStreamMode()) {
            context.getPkg().setNeedStreamMode();
        }
        if (context.getErrors().isEmpty()) {
            return context.getWarnings();
        }
        if (context.getWarnings().isEmpty()) {
            return context.getErrors();
        }
        ArrayList<BaseKnowledgeBuilderResultImpl> result = new ArrayList<BaseKnowledgeBuilderResultImpl>();
        result.addAll(context.getErrors());
        result.addAll(context.getWarnings());
        return result;
    }

    boolean filterAccepts(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter == null || !AssetFilter.Action.DO_NOTHING.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private boolean filterAcceptsRemoval(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter != null && AssetFilter.Action.REMOVE.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private void preProcessRules(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        if (this.kBase == null) {
            return;
        }
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        boolean needsRemoval = false;
        for (Rule rule : pkg.getRules()) {
            if (!this.filterAcceptsRemoval(ResourceChange.Type.RULE, rule.getPackageName(), rule.getName())) continue;
            needsRemoval = true;
            break;
        }
        if (!needsRemoval) {
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName()) || pkg.getRule(ruleDescr.getName()) == null) continue;
                needsRemoval = true;
                break;
            }
        }
        if (needsRemoval) {
            this.kBase.enqueueModification(() -> {
                HashSet<RuleImpl> rulesToBeRemoved = new HashSet<RuleImpl>();
                for (Rule rule : pkg.getRules()) {
                    if (!this.filterAcceptsRemoval(ResourceChange.Type.RULE, rule.getPackageName(), rule.getName())) continue;
                    rulesToBeRemoved.add((RuleImpl)rule);
                }
                rulesToBeRemoved.forEach(arg_0 -> ((InternalKnowledgePackage)pkg).removeRule(arg_0));
                for (RuleDescr ruleDescr : packageDescr.getRules()) {
                    RuleImpl rule;
                    if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName()) || (rule = pkg.getRule(ruleDescr.getName())) == null) continue;
                    rulesToBeRemoved.add(rule);
                }
                if (!rulesToBeRemoved.isEmpty()) {
                    this.kBase.removeRules(rulesToBeRemoved);
                }
            });
        }
    }

    private Map<String, RuleBuildContext> buildRuleBuilderContexts(List<RuleDescr> rules, PackageRegistry pkgRegistry) {
        HashMap<String, RuleBuildContext> map = new HashMap<String, RuleBuildContext>();
        for (RuleDescr ruleDescr : rules) {
            RuleBuildContext context = this.buildRuleBuilderContext(pkgRegistry, ruleDescr);
            map.put(ruleDescr.getName(), context);
            pkgRegistry.getPackage().addRule(context.getRule());
        }
        return map;
    }

    private RuleBuildContext buildRuleBuilderContext(PackageRegistry pkgRegistry, RuleDescr ruleDescr) {
        if (ruleDescr.getResource() == null) {
            ruleDescr.setResource(this.resource);
        }
        DialectCompiletimeRegistry ctr = pkgRegistry.getDialectCompiletimeRegistry();
        RuleBuildContext context = new RuleBuildContext(this, ruleDescr, ctr, pkgRegistry.getPackage(), ctr.getDialect(pkgRegistry.getDialect()));
        RuleBuilder.preProcess(context);
        return context;
    }

    /*
     * WARNING - void declaration
     */
    private SortedRules sortRulesByDependency(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        void var10_13;
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        LinkedList<RuleDescr> roots = new LinkedList<RuleDescr>();
        HashMap<String, List<RuleDescr>> children = new HashMap<String, List<RuleDescr>>();
        LinkedHashMap<String, RuleDescr> sorted = new LinkedHashMap<String, RuleDescr>();
        ArrayList<RuleDescr> queries = new ArrayList<RuleDescr>();
        HashSet<String> compiledRules = new HashSet<String>();
        for (RuleDescr ruleDescr : packageDescr.getRules()) {
            if (ruleDescr.isQuery()) {
                queries.add(ruleDescr);
                continue;
            }
            if (!ruleDescr.hasParent()) {
                roots.add(ruleDescr);
                continue;
            }
            if (pkg.getRule(ruleDescr.getParentName()) != null) {
                compiledRules.add(ruleDescr.getParentName());
            }
            children.computeIfAbsent(ruleDescr.getParentName(), k -> new ArrayList()).add(ruleDescr);
        }
        SortedRules sortedRules = new SortedRules();
        sortedRules.queries = queries;
        if (children.isEmpty()) {
            if (!queries.isEmpty()) {
                packageDescr.getRules().removeAll(queries);
                packageDescr.getRules().addAll(0, queries);
                sortedRules.rules.add(packageDescr.getRules().subList(queries.size(), packageDescr.getRules().size()));
            } else {
                sortedRules.rules.add(packageDescr.getRules());
            }
            return sortedRules;
        }
        for (String compiledRule : compiledRules) {
            List childz = (List)children.remove(compiledRule);
            roots.addAll(childz);
        }
        LinkedList<RuleDescr> linkedList = roots;
        while (!var10_13.isEmpty()) {
            List<RuleDescr> list = this.sortRulesLevel((List<RuleDescr>)var10_13, sorted, sortedRules, children);
            sortedRules.newLevel();
        }
        this.reportHierarchyErrors(children, sorted);
        packageDescr.getRules().clear();
        packageDescr.getRules().addAll(queries);
        for (RuleDescr descr : sorted.values()) {
            packageDescr.getRules().add(descr);
        }
        return sortedRules;
    }

    private List<RuleDescr> sortRulesLevel(List<RuleDescr> rulesLevel, LinkedHashMap<String, RuleDescr> sorted, SortedRules sortedRules, Map<String, List<RuleDescr>> children) {
        ArrayList<RuleDescr> nextLevel = new ArrayList<RuleDescr>();
        rulesLevel.forEach(ruleDescr -> {
            sortedRules.addRule((RuleDescr)ruleDescr);
            sorted.put(ruleDescr.getName(), (RuleDescr)ruleDescr);
            List childz = (List)children.remove(ruleDescr.getName());
            if (childz != null) {
                nextLevel.addAll(childz);
            }
        });
        return nextLevel;
    }

    private void reportHierarchyErrors(Map<String, List<RuleDescr>> parents, Map<String, RuleDescr> sorted) {
        boolean circularDep = false;
        for (List<RuleDescr> rds : parents.values()) {
            for (RuleDescr ruleDescr : rds) {
                if (parents.get(ruleDescr.getParentName()) != null && (sorted.containsKey(ruleDescr.getName()) || parents.containsKey(ruleDescr.getName()))) {
                    circularDep = true;
                    this.results.add(new RuleBuildError(ruleDescr.toRule(), (BaseDescr)ruleDescr, null, "Circular dependency in rules hierarchy"));
                    break;
                }
                this.manageUnresolvedExtension(ruleDescr, sorted.values());
            }
            if (!circularDep) continue;
            break;
        }
    }

    private void manageUnresolvedExtension(RuleDescr ruleDescr, Collection<RuleDescr> candidates) {
        LinkedList<String> candidateRules = new LinkedList<String>();
        for (RuleDescr r : candidates) {
            if (!(StringUtils.stringSimilarity((String)ruleDescr.getParentName(), (String)r.getName(), (StringUtils.SIMILARITY_STRATS)StringUtils.SIMILARITY_STRATS.DICE) >= 0.75)) continue;
            candidateRules.add(r.getName());
        }
        String msg = "Unresolved parent name " + ruleDescr.getParentName();
        if (candidateRules.size() > 0) {
            msg = msg + " >> did you mean any of :" + candidateRules;
        }
        this.results.add(new RuleBuildError(ruleDescr.toRule(), (BaseDescr)ruleDescr, (Object)msg, "Unable to resolve parent rule, please check that both rules are in the same package"));
    }

    private String getPackageDialect(PackageDescr packageDescr) {
        String dialectName = this.defaultDialect;
        for (AttributeDescr value : packageDescr.getAttributes()) {
            if (!"dialect".equals(value.getName())) continue;
            dialectName = value.getValue();
            break;
        }
        return dialectName;
    }

    public void updateResults() {
        this.updateResults(this.results);
    }

    public void updateResults(List<KnowledgeBuilderResult> results) {
        this.results = this.getResults(results);
    }

    public void compileAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.compileAll();
        }
    }

    public void reloadAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
        }
    }

    private List<KnowledgeBuilderResult> getResults(List<KnowledgeBuilderResult> results) {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            results = pkgRegistry.getDialectCompiletimeRegistry().addResults(results);
        }
        return results;
    }

    public synchronized void addPackage(InternalKnowledgePackage newPkg) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(newPkg.getName());
        InternalKnowledgePackage pkg = null;
        if (pkgRegistry != null) {
            pkg = pkgRegistry.getPackage();
        }
        if (pkg == null) {
            PackageDescr packageDescr = new PackageDescr(newPkg.getName());
            pkgRegistry = this.getOrCreatePackageRegistry(packageDescr);
            this.mergePackage(this.pkgRegistryMap.get(packageDescr.getNamespace()), packageDescr);
            pkg = pkgRegistry.getPackage();
        }
        pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader);
        if (newPkg.getFunctions() != null) {
            for (Map.Entry entry : newPkg.getFunctions().entrySet()) {
                if (pkg.getFunctions().containsKey(entry.getKey())) {
                    this.addBuilderResult(new DuplicateFunction((Function)entry.getValue(), (KnowledgeBuilderConfiguration)this.configuration));
                }
                pkg.addFunction((Function)entry.getValue());
            }
        }
        pkg.getClassFieldAccessorStore().merge(newPkg.getClassFieldAccessorStore());
        pkg.getDialectRuntimeRegistry().onBeforeExecute();
        TypeDeclaration lastType = null;
        try {
            if (newPkg.getTypeDeclarations() != null) {
                Iterator iterator = newPkg.getTypeDeclarations().values().iterator();
                while (iterator.hasNext()) {
                    TypeDeclaration type;
                    lastType = type = (TypeDeclaration)iterator.next();
                    type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("unable to resolve Type Declaration class '" + lastType.getTypeName() + "'");
        }
        this.mergePackage(pkg, newPkg);
    }

    private void mergePackage(InternalKnowledgePackage pkg, InternalKnowledgePackage newPkg) {
        Map imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        String lastType = null;
        try {
            if (newPkg.getGlobals() != null && newPkg.getGlobals() != Collections.EMPTY_MAP) {
                Map globals = pkg.getGlobals();
                for (Map.Entry entry : newPkg.getGlobals().entrySet()) {
                    String type;
                    String identifier = (String)entry.getKey();
                    lastType = type = (String)entry.getValue();
                    if (globals.containsKey(identifier) && !((String)globals.get(identifier)).equals(type)) {
                        throw new RuntimeException(pkg.getName() + " cannot be integrated");
                    }
                    pkg.addGlobal(identifier, this.rootClassLoader.loadClass(type));
                    this.globals.put(identifier, this.rootClassLoader.loadClass(type));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to resolve class '" + lastType + "'");
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration type : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(type.getTypeName())) continue;
                pkg.addTypeDeclaration(type);
            }
        }
        for (Rule newRule : newPkg.getRules()) {
            pkg.addRule((RuleImpl)newRule);
        }
        if (newPkg.getRuleFlows() != null) {
            Map flows = newPkg.getRuleFlows();
            for (Map.Entry o : flows.values()) {
                Process flow = (Process)o;
                pkg.addProcess(flow);
            }
        }
    }

    protected void validateUniqueRuleNames(PackageDescr packageDescr) {
        HashSet<String> names = new HashSet<String>();
        PackageRegistry packageRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        InternalKnowledgePackage pkg = null;
        if (packageRegistry != null) {
            pkg = packageRegistry.getPackage();
        }
        for (RuleDescr rule : packageDescr.getRules()) {
            RuleImpl duplicatedRule;
            this.validateRule(packageDescr, rule);
            String name = rule.getName();
            if (names.contains(name)) {
                this.addBuilderResult(new ParserError(rule.getResource(), "Duplicate rule name: " + name, rule.getLine(), rule.getColumn(), packageDescr.getNamespace()));
            }
            if (pkg != null && (duplicatedRule = pkg.getRule(name)) != null) {
                Resource resource = rule.getResource();
                Resource duplicatedResource = duplicatedRule.getResource();
                if (resource == null || duplicatedResource == null || duplicatedResource.getSourcePath() == null || duplicatedResource.getSourcePath().equals(resource.getSourcePath())) {
                    this.addBuilderResult(new DuplicateRule(rule, packageDescr, this.configuration));
                } else {
                    this.addBuilderResult(new ParserError(rule.getResource(), "Duplicate rule name: " + name, rule.getLine(), rule.getColumn(), packageDescr.getNamespace()));
                }
            }
            names.add(name);
        }
    }

    private void validateRule(PackageDescr packageDescr, RuleDescr rule) {
        if (rule.hasErrors()) {
            for (String error : rule.getErrors()) {
                this.addBuilderResult(new ParserError(rule.getResource(), error + " in rule " + rule.getName(), rule.getLine(), rule.getColumn(), packageDescr.getNamespace()));
            }
        }
    }

    void mergePackage(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (ImportDescr importDescr : packageDescr.getImports()) {
            pkgRegistry.addImport(importDescr);
        }
        this.normalizeTypeDeclarationAnnotations(packageDescr, pkgRegistry.getTypeResolver());
        this.processAccumulateFunctions(pkgRegistry, packageDescr);
        this.processEntryPointDeclarations(pkgRegistry, packageDescr);
        HashMap<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs = new HashMap<String, AbstractClassTypeDeclarationDescr>();
        ArrayList<TypeDefinition> unresolvedTypes = new ArrayList<TypeDefinition>();
        ArrayList<AbstractClassTypeDeclarationDescr> unsortedDescrs = new ArrayList<AbstractClassTypeDeclarationDescr>();
        unsortedDescrs.addAll(packageDescr.getTypeDeclarations());
        unsortedDescrs.addAll(packageDescr.getEnumDeclarations());
        this.typeBuilder.processTypeDeclarations(packageDescr, pkgRegistry, unsortedDescrs, unresolvedTypes, unprocesseableDescrs);
        for (AbstractClassTypeDeclarationDescr descr : unprocesseableDescrs.values()) {
            this.addBuilderResult(new TypeDeclarationError(descr, "Unable to process type " + descr.getTypeName()));
        }
        this.processOtherDeclarations(pkgRegistry, packageDescr);
        this.normalizeRuleAnnotations(packageDescr, pkgRegistry.getTypeResolver());
    }

    void processOtherDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        this.processAccumulateFunctions(pkgRegistry, packageDescr);
        this.processWindowDeclarations(pkgRegistry, packageDescr);
        this.processFunctions(pkgRegistry, packageDescr);
        this.processGlobals(pkgRegistry, packageDescr);
    }

    private void processGlobals(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        HashSet existingGlobals = new HashSet(pkg.getGlobals().keySet());
        for (GlobalDescr global : packageDescr.getGlobals()) {
            String identifier = global.getIdentifier();
            existingGlobals.remove(identifier);
            String className = global.getType();
            while (className.indexOf(60) >= 0) {
                className = className.replaceAll("<[^<>]+?>", "");
            }
            try {
                Class clazz = pkgRegistry.getTypeResolver().resolveType(className);
                if (clazz.isPrimitive()) {
                    this.addBuilderResult(new GlobalError(global, " Primitive types are not allowed in globals : " + className));
                    return;
                }
                pkg.addGlobal(identifier, clazz);
                this.addGlobal(identifier, clazz);
                if (this.kBase == null) continue;
                this.kBase.addGlobal(identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                this.addBuilderResult(new GlobalError(global, e.getMessage()));
                e.printStackTrace();
            }
        }
        for (String toBeRemoved : existingGlobals) {
            if (!this.filterAcceptsRemoval(ResourceChange.Type.GLOBAL, pkg.getName(), toBeRemoved)) continue;
            pkg.removeGlobal(toBeRemoved);
            if (this.kBase == null) continue;
            this.kBase.removeGlobal(toBeRemoved);
        }
    }

    private void processAccumulateFunctions(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (AccumulateImportDescr aid : packageDescr.getAccumulateImports()) {
            AccumulateFunction af = this.loadAccumulateFunction(pkgRegistry, aid.getFunctionName(), aid.getTarget());
            pkgRegistry.getPackage().addAccumulateFunction(aid.getFunctionName(), af);
        }
    }

    private AccumulateFunction loadAccumulateFunction(PackageRegistry pkgRegistry, String identifier, String className) {
        try {
            Class clazz = pkgRegistry.getTypeResolver().resolveType(className);
            return (AccumulateFunction)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Class " + className + " not found", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + className, e);
        }
    }

    private void processFunctions(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (FunctionDescr function : packageDescr.getFunctions()) {
            Function existingFunc = (Function)pkgRegistry.getPackage().getFunctions().get(function.getName());
            if (existingFunc == null || !function.getNamespace().equals(existingFunc.getNamespace())) continue;
            this.addBuilderResult(new DuplicateFunction(function, (KnowledgeBuilderConfiguration)this.configuration));
        }
        for (FunctionImportDescr functionImport : packageDescr.getFunctionImports()) {
            String importEntry = functionImport.getTarget();
            pkgRegistry.addStaticImport(functionImport);
            pkgRegistry.getPackage().addStaticImport(importEntry);
        }
    }

    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        TypeDeclaration typeDeclaration;
        InternalKnowledgePackage pkg;
        if (this.kBase != null && (pkg = this.kBase.getPackage(packageName)) != null && (typeDeclaration = pkg.getTypeDeclaration(cls)) != null) {
            return typeDeclaration;
        }
        return this.typeBuilder.getAndRegisterTypeDeclaration(cls, packageName);
    }

    void processEntryPointDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (EntryPointDeclarationDescr epDescr : packageDescr.getEntryPointDeclarations()) {
            pkgRegistry.getPackage().addEntryPointId(epDescr.getEntryPointId());
        }
    }

    private void processWindowDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (WindowDeclarationDescr wd : packageDescr.getWindowDeclarations()) {
            Pattern pattern;
            WindowDeclaration window = new WindowDeclaration(wd.getName(), packageDescr.getName());
            InternalKnowledgePackage pkg = pkgRegistry.getPackage();
            DialectCompiletimeRegistry ctr = pkgRegistry.getDialectCompiletimeRegistry();
            RuleDescr dummy = new RuleDescr(wd.getName() + " Window Declaration");
            dummy.setResource(packageDescr.getResource());
            dummy.addAttribute(new AttributeDescr("dialect", "java"));
            RuleBuildContext context = new RuleBuildContext(this, dummy, ctr, pkg, ctr.getDialect(pkgRegistry.getDialect()));
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(wd.getPattern().getClass());
            if (builder != null) {
                pattern = (Pattern)builder.build(context, wd.getPattern(), null);
                if (pattern.getXpathConstraint() != null) {
                    context.addError(new DescrBuildError(wd, context.getParentDescr(), null, "OOpath expression " + pattern.getXpathConstraint() + " not allowed in window declaration\n"));
                }
            } else {
                throw new RuntimeException("BUG: assembler not found for descriptor class " + wd.getPattern().getClass());
            }
            window.setPattern(pattern);
            if (!context.getErrors().isEmpty()) {
                for (DroolsError error : context.getErrors()) {
                    this.addBuilderResult(error);
                }
                continue;
            }
            pkgRegistry.getPackage().addWindowDeclaration(window);
        }
    }

    private void addFunction(FunctionDescr functionDescr, PackageRegistry pkgRegistry) {
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.addFunction(functionDescr, pkgRegistry.getTypeResolver(), this.resource);
    }

    private void preCompileAddFunction(FunctionDescr functionDescr, PackageRegistry pkgRegistry) {
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.preCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    private void postCompileAddFunction(FunctionDescr functionDescr, PackageRegistry pkgRegistry) {
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.postCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
        if (this.rootClassLoader instanceof ProjectClassLoader) {
            String functionClassName = functionDescr.getClassName();
            JavaDialectRuntimeData runtime = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
            try {
                KnowledgeBaseImpl.registerFunctionClassAndInnerClasses((String)functionClassName, (JavaDialectRuntimeData)runtime, (name, bytes) -> ((ProjectClassLoader)this.rootClassLoader).storeClass(name, bytes));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public InternalKnowledgePackage[] getPackages() {
        InternalKnowledgePackage[] pkgs = new InternalKnowledgePackage[this.pkgRegistryMap.size()];
        String errors = null;
        if (!this.getErrors().isEmpty()) {
            errors = this.getErrors().toString();
        }
        int i = 0;
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            InternalKnowledgePackage pkg = pkgRegistry.getPackage();
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            if (errors != null) {
                pkg.setError(errors);
            }
            pkgs[i++] = pkg;
        }
        return pkgs;
    }

    public KnowledgeBuilderConfigurationImpl getBuilderConfiguration() {
        return this.configuration;
    }

    public PackageRegistry getPackageRegistry(String name) {
        return this.pkgRegistryMap.get(name);
    }

    public InternalKnowledgePackage getPackage(String name) {
        return this.pkgRegistryMap.get(name).getPackage();
    }

    public Map<String, PackageRegistry> getPackageRegistry() {
        return this.pkgRegistryMap;
    }

    public Collection<String> getPackageNames() {
        return this.pkgRegistryMap.keySet();
    }

    public List<PackageDescr> getPackageDescrs(String packageName) {
        return this.packages.get(packageName);
    }

    public DefaultExpander getDslExpander() {
        DefaultExpander expander = new DefaultExpander();
        if (this.dslFiles == null || this.dslFiles.isEmpty()) {
            return null;
        }
        for (DSLMappingFile dSLMappingFile : this.dslFiles) {
            expander.addDSLMapping(dSLMappingFile.getMapping());
        }
        return expander;
    }

    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    public void addGlobal(String name, Class<?> type) {
        this.globals.put(name, type);
    }

    public boolean hasErrors() {
        return !this.getErrorList().isEmpty();
    }

    public KnowledgeBuilderResults getResults(ResultSeverity ... problemTypes) {
        List<KnowledgeBuilderResult> problems = this.getResultList(problemTypes);
        return new PackageBuilderResults(problems.toArray(new BaseKnowledgeBuilderResultImpl[problems.size()]));
    }

    private List<KnowledgeBuilderResult> getResultList(ResultSeverity ... severities) {
        List<ResultSeverity> typesToFetch = Arrays.asList(severities);
        ArrayList<KnowledgeBuilderResult> problems = new ArrayList<KnowledgeBuilderResult>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (!typesToFetch.contains(problem.getSeverity())) continue;
            problems.add(problem);
        }
        return problems;
    }

    public boolean hasResults(ResultSeverity ... problemTypes) {
        return !this.getResultList(problemTypes).isEmpty();
    }

    private List<DroolsError> getErrorList() {
        ArrayList<DroolsError> errors = new ArrayList<DroolsError>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problem.getSeverity() != ResultSeverity.ERROR) continue;
            if (problem instanceof ConfigurableSeverityResult) {
                errors.add(new DroolsErrorWrapper(problem));
                continue;
            }
            errors.add((DroolsError)problem);
        }
        return errors;
    }

    public boolean hasWarnings() {
        return !this.getWarnings().isEmpty();
    }

    public boolean hasInfo() {
        return !this.getInfoList().isEmpty();
    }

    public List<DroolsWarning> getWarnings() {
        ArrayList<DroolsWarning> warnings = new ArrayList<DroolsWarning>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problem.getSeverity() != ResultSeverity.WARNING) continue;
            if (problem instanceof ConfigurableSeverityResult) {
                warnings.add(new DroolsWarningWrapper(problem));
                continue;
            }
            warnings.add((DroolsWarning)problem);
        }
        return warnings;
    }

    private List<KnowledgeBuilderResult> getInfoList() {
        return this.getResultList(ResultSeverity.INFO);
    }

    public PackageBuilderErrors getErrors() {
        List<DroolsError> errors = this.getErrorList();
        return new PackageBuilderErrors(errors.toArray(new DroolsError[errors.size()]));
    }

    protected void resetErrors() {
        this.resetProblemType(ResultSeverity.ERROR);
    }

    protected void resetWarnings() {
        this.resetProblemType(ResultSeverity.WARNING);
    }

    private void resetProblemType(ResultSeverity problemType) {
        ArrayList<KnowledgeBuilderResult> toBeDeleted = new ArrayList<KnowledgeBuilderResult>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problemType == null || !problemType.equals((Object)problem.getSeverity())) continue;
            toBeDeleted.add(problem);
        }
        this.results.removeAll(toBeDeleted);
    }

    protected void resetProblems() {
        this.results.clear();
        if (this.processBuilder != null) {
            this.processBuilder.getErrors().clear();
        }
    }

    public String getDefaultDialect() {
        return this.defaultDialect;
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    private void inheritPackageAttributes(Map<String, AttributeDescr> pkgAttributes, RuleDescr ruleDescr) {
        if (pkgAttributes == null) {
            return;
        }
        for (AttributeDescr attrDescr : pkgAttributes.values()) {
            ruleDescr.getAttributes().putIfAbsent(attrDescr.getName(), attrDescr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeSet parseChangeSet(Resource resource) throws IOException, SAXException {
        XmlChangeSetReader reader = new XmlChangeSetReader(this.configuration.getSemanticModules());
        if (resource instanceof ClassPathResource) {
            reader.setClassLoader(((ClassPathResource)resource).getClassLoader(), ((ClassPathResource)resource).getClazz());
        } else {
            reader.setClassLoader(this.configuration.getClassLoader(), null);
        }
        try (Reader resourceReader = null;){
            resourceReader = resource.getReader();
            ChangeSet changeSet = reader.read(resourceReader);
            return changeSet;
        }
    }

    public void registerBuildResource(final Resource resource, ResourceType type) {
        InternalResource ires = (InternalResource)resource;
        if (ires.getResourceType() == null) {
            ires.setResourceType(type);
        } else if (ires.getResourceType() != type) {
            this.addBuilderResult(new ResourceTypeDeclarationWarning(resource, ires.getResourceType(), type));
        }
        if (ResourceType.CHANGE_SET == type) {
            try {
                ChangeSet changeSet = this.parseChangeSet(resource);
                ArrayList<Resource> resources = new ArrayList<Resource>();
                resources.add(resource);
                for (Resource addedRes : changeSet.getResourcesAdded()) {
                    resources.add(addedRes);
                }
                for (Resource modifiedRes : changeSet.getResourcesModified()) {
                    resources.add(modifiedRes);
                }
                for (Resource removedRes : changeSet.getResourcesRemoved()) {
                    resources.add(removedRes);
                }
                this.buildResources.push(resources);
            }
            catch (Exception e) {
                this.results.add(new DroolsError(){

                    @Override
                    public String getMessage() {
                        return "Unable to register changeset resource " + resource;
                    }

                    @Override
                    public int[] getLines() {
                        return new int[0];
                    }
                });
            }
        } else {
            this.buildResources.push(Collections.singletonList(resource));
        }
    }

    public void registerBuildResources(List<Resource> resources) {
        this.buildResources.push(resources);
    }

    public void undo() {
        if (this.buildResources.isEmpty()) {
            return;
        }
        for (Resource resource : this.buildResources.pop()) {
            this.removeObjectsGeneratedFromResource(resource);
        }
    }

    public ResourceRemovalResult removeObjectsGeneratedFromResource(Resource resource) {
        Iterator<Object> i;
        boolean modified = false;
        if (this.pkgRegistryMap != null) {
            for (PackageRegistry packageRegistry : this.pkgRegistryMap.values()) {
                modified = packageRegistry.removeObjectsGeneratedFromResource(resource) || modified;
            }
        }
        if (this.results != null) {
            i = this.results.iterator();
            while (i.hasNext()) {
                if (!resource.equals(i.next().getResource())) continue;
                i.remove();
            }
        }
        if (this.processBuilder != null && this.processBuilder.getErrors() != null) {
            i = this.processBuilder.getErrors().iterator();
            while (i.hasNext()) {
                if (!resource.equals(((KnowledgeBuilderResult)i.next()).getResource())) continue;
                i.remove();
            }
        }
        if (this.results.size() == 0) {
            for (PackageRegistry packageRegistry : this.pkgRegistryMap.values()) {
                packageRegistry.getPackage().resetErrors();
            }
        }
        Collection<String> removedTypes = this.typeBuilder.removeTypesGeneratedFromResource(resource);
        for (List<PackageDescr> pkgDescrs : this.packages.values()) {
            for (PackageDescr pkgDescr : pkgDescrs) {
                pkgDescr.removeObjectsGeneratedFromResource(resource);
            }
        }
        if (this.kBase != null) {
            modified = this.kBase.removeObjectsGeneratedFromResource(resource) || modified;
        }
        return new ResourceRemovalResult(modified, removedTypes);
    }

    public void rewireAllClassObjectTypes() {
        if (this.kBase != null) {
            for (InternalKnowledgePackage pkg : this.kBase.getPackagesMap().values()) {
                pkg.getDialectRuntimeRegistry().getDialectData("java").setDirty(true);
                pkg.getClassFieldAccessorStore().wire();
            }
        }
    }

    AssetFilter getAssetFilter() {
        return this.assetFilter;
    }

    public void setAssetFilter(AssetFilter assetFilter) {
        this.assetFilter = assetFilter;
    }

    public void add(Resource resource, ResourceType type) {
        ResourceConfiguration resourceConfiguration = resource instanceof BaseResource ? resource.getConfiguration() : null;
        this.add(resource, type, resourceConfiguration);
    }

    public CompositeKnowledgeBuilder batch() {
        return new CompositeKnowledgeBuilderImpl(this);
    }

    public void add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        this.registerBuildResource(resource, type);
        this.addKnowledgeResource(resource, type, configuration);
    }

    public Collection<KiePackage> getKnowledgePackages() {
        if (this.hasErrors()) {
            return new ArrayList<KiePackage>(0);
        }
        InternalKnowledgePackage[] pkgs = this.getPackages();
        ArrayList<KiePackage> list = new ArrayList<KiePackage>(pkgs.length);
        Collections.addAll(list, pkgs);
        return list;
    }

    public KieBase newKieBase() {
        return this.newKnowledgeBase(null);
    }

    public KieBase newKnowledgeBase(KieBaseConfiguration conf) {
        PackageBuilderErrors errors = this.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.error(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge. See the logs for details.");
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)conf);
        kbase.addPackages(Arrays.asList(this.getPackages()));
        return kbase;
    }

    public TypeDeclaration getTypeDeclaration(Class<?> cls) {
        return cls != null ? this.typeBuilder.getTypeDeclaration(cls) : null;
    }

    public void normalizeTypeDeclarationAnnotations(PackageDescr packageDescr, TypeResolver typeResolver) {
        boolean isStrict = this.configuration.getLanguageLevel().useJavaAnnotations();
        for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
            this.normalizeAnnotations(typeDeclarationDescr, typeResolver, isStrict);
            for (TypeFieldDescr typeFieldDescr : typeDeclarationDescr.getFields().values()) {
                this.normalizeAnnotations(typeFieldDescr, typeResolver, isStrict);
            }
        }
        for (EnumDeclarationDescr enumDeclarationDescr : packageDescr.getEnumDeclarations()) {
            this.normalizeAnnotations(enumDeclarationDescr, typeResolver, isStrict);
            for (TypeFieldDescr typeFieldDescr : enumDeclarationDescr.getFields().values()) {
                this.normalizeAnnotations(typeFieldDescr, typeResolver, isStrict);
            }
        }
    }

    public void normalizeRuleAnnotations(PackageDescr packageDescr, TypeResolver typeResolver) {
        boolean isStrict = this.configuration.getLanguageLevel().useJavaAnnotations();
        for (RuleDescr ruleDescr : packageDescr.getRules()) {
            this.normalizeAnnotations(ruleDescr, typeResolver, isStrict);
            this.traverseAnnotations(ruleDescr.getLhs(), typeResolver, isStrict);
        }
    }

    private void traverseAnnotations(BaseDescr descr, TypeResolver typeResolver, boolean isStrict) {
        if (descr instanceof AnnotatedBaseDescr) {
            this.normalizeAnnotations((AnnotatedBaseDescr)descr, typeResolver, isStrict);
        }
        if (descr instanceof ConditionalElementDescr) {
            for (BaseDescr baseDescr : ((ConditionalElementDescr)((Object)descr)).getDescrs()) {
                this.traverseAnnotations(baseDescr, typeResolver, isStrict);
            }
        }
        if (descr instanceof PatternDescr && ((PatternDescr)descr).getSource() != null) {
            this.traverseAnnotations(((PatternDescr)descr).getSource(), typeResolver, isStrict);
        }
        if (descr instanceof PatternDestinationDescr) {
            this.traverseAnnotations(((PatternDestinationDescr)((Object)descr)).getInputPattern(), typeResolver, isStrict);
        }
    }

    protected void normalizeAnnotations(AnnotatedBaseDescr annotationsContainer, TypeResolver typeResolver, boolean isStrict) {
        for (AnnotationDescr annotationDescr : annotationsContainer.getAnnotations()) {
            annotationDescr.setResource(annotationsContainer.getResource());
            annotationDescr.setStrict(isStrict);
            if (annotationDescr.isDuplicated()) {
                this.addBuilderResult(new AnnotationDeclarationError(annotationDescr, "Duplicated annotation: " + annotationDescr.getName()));
            }
            if (isStrict) {
                this.normalizeStrictAnnotation(typeResolver, annotationDescr);
                continue;
            }
            this.normalizeAnnotation(typeResolver, annotationDescr);
        }
        annotationsContainer.indexByFQN(isStrict);
    }

    private AnnotationDescr normalizeAnnotation(TypeResolver typeResolver, AnnotationDescr annotationDescr) {
        Class annotationClass = null;
        try {
            annotationClass = typeResolver.resolveType(annotationDescr.getName(), (TypeResolver.ClassFilter)TypeResolver.ONLY_ANNOTATION_CLASS_FILTER);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            String className = this.normalizeAnnotationNonStrictName(annotationDescr.getName());
            try {
                annotationClass = typeResolver.resolveType(className, (TypeResolver.ClassFilter)TypeResolver.ONLY_ANNOTATION_CLASS_FILTER);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        if (annotationClass != null) {
            annotationDescr.setFullyQualifiedName(annotationClass.getCanonicalName());
            for (String key : annotationDescr.getValueMap().keySet()) {
                try {
                    Method m = annotationClass.getMethod(key, new Class[0]);
                    Object[] val = annotationDescr.getValue(key);
                    if (val instanceof Object[] && !m.getReturnType().isArray()) {
                        this.addBuilderResult(new AnnotationDeclarationError(annotationDescr, "Wrong cardinality on property " + key));
                        return annotationDescr;
                    }
                    if (m.getReturnType().isArray() && !(val instanceof Object[])) {
                        val = new Object[]{val};
                        annotationDescr.setKeyValue(key, val);
                    }
                    if (m.getReturnType().isArray()) {
                        int n = Array.getLength(val);
                        for (int j = 0; j < n; ++j) {
                            if (Class.class.equals(m.getReturnType().getComponentType())) {
                                String className = Array.get(val, j).toString().replace(".class", "");
                                Array.set(val, j, typeResolver.resolveType(className).getName() + ".class");
                                continue;
                            }
                            if (!m.getReturnType().getComponentType().isAnnotation()) continue;
                            Array.set(val, j, this.normalizeAnnotation(typeResolver, (AnnotationDescr)Array.get(val, j)));
                        }
                        continue;
                    }
                    if (Class.class.equals(m.getReturnType())) {
                        String className = annotationDescr.getValueAsString(key).replace(".class", "");
                        annotationDescr.setKeyValue(key, typeResolver.resolveType(className));
                        continue;
                    }
                    if (!m.getReturnType().isAnnotation()) continue;
                    annotationDescr.setKeyValue(key, this.normalizeAnnotation(typeResolver, (AnnotationDescr)annotationDescr.getValue(key)));
                }
                catch (NoSuchMethodException e) {
                    this.addBuilderResult(new AnnotationDeclarationError(annotationDescr, "Unknown annotation property " + key));
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    this.addBuilderResult(new AnnotationDeclarationError(annotationDescr, "Unknown class " + annotationDescr.getValue(key) + " used in property " + key + " of annotation " + annotationDescr.getName()));
                }
            }
        }
        return annotationDescr;
    }

    private String normalizeAnnotationNonStrictName(String name) {
        if ("typesafe".equalsIgnoreCase(name)) {
            return "TypeSafe";
        }
        return StringUtils.ucFirst((String)name);
    }

    private void normalizeStrictAnnotation(TypeResolver typeResolver, AnnotationDescr annotationDescr) {
        try {
            Class annotationClass = typeResolver.resolveType(annotationDescr.getName(), (TypeResolver.ClassFilter)TypeResolver.ONLY_ANNOTATION_CLASS_FILTER);
            annotationDescr.setFullyQualifiedName(annotationClass.getCanonicalName());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.addBuilderResult(new AnnotationDeclarationError(annotationDescr, "Unknown annotation: " + annotationDescr.getName()));
        }
    }

    private Map<String, Object> getBuilderCache() {
        if (this.builderCache == null) {
            this.builderCache = new HashMap<String, Object>();
        }
        return this.builderCache;
    }

    public <T> T getCachedOrCreate(String key, Supplier<T> creator) {
        Map<String, Object> builderCache = this.getBuilderCache();
        Object cachedValue = builderCache.get(key);
        if (cachedValue == null) {
            T newValue = creator.get();
            builderCache.put(key, newValue);
            return newValue;
        }
        return (T)cachedValue;
    }

    public void buildPackages(Collection<CompositePackageDescr> packages) {
        this.initPackageRegistries(packages);
        this.normalizeTypeAnnotations(packages);
        this.buildTypeDeclarations(packages);
        this.buildEntryPoints(packages);
        this.buildOtherDeclarations(packages);
        this.normalizeRuleAnnotations(packages);
        this.buildRules(packages);
    }

    protected void initPackageRegistries(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            if (StringUtils.isEmpty((CharSequence)packageDescr.getName())) {
                packageDescr.setName(this.getBuilderConfiguration().getDefaultPackageName());
            }
            this.getOrCreatePackageRegistry(packageDescr);
        }
    }

    protected void normalizeTypeAnnotations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.normalizeTypeDeclarationAnnotations(packageDescr, this.getOrCreatePackageRegistry(packageDescr).getTypeResolver());
        }
    }

    protected void normalizeRuleAnnotations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.normalizeRuleAnnotations(packageDescr, this.getOrCreatePackageRegistry(packageDescr).getTypeResolver());
        }
    }

    protected void buildEntryPoints(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.processEntryPointDeclarations(this.getPackageRegistry(packageDescr.getNamespace()), packageDescr);
        }
    }

    protected void buildTypeDeclarations(Collection<CompositePackageDescr> packages) {
        HashMap<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs = new HashMap<String, AbstractClassTypeDeclarationDescr>();
        ArrayList<TypeDefinition> unresolvedTypes = new ArrayList<TypeDefinition>();
        ArrayList<AbstractClassTypeDeclarationDescr> unsortedDescrs = new ArrayList<AbstractClassTypeDeclarationDescr>();
        for (CompositePackageDescr packageDescr : packages) {
            for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
                unsortedDescrs.add(typeDeclarationDescr);
            }
            for (EnumDeclarationDescr enumDeclarationDescr : packageDescr.getEnumDeclarations()) {
                unsortedDescrs.add(enumDeclarationDescr);
            }
        }
        this.getTypeBuilder().processTypeDeclarations(packages, unsortedDescrs, unresolvedTypes, unprocesseableDescrs);
        for (CompositePackageDescr packageDescr : packages) {
            for (ImportDescr importDescr : packageDescr.getImports()) {
                this.getPackageRegistry(packageDescr.getNamespace()).addImport(importDescr);
            }
        }
    }

    protected void buildOtherDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter(packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.processOtherDeclarations(pkgRegistry, packageDescr);
            this.setAssetFilter(null);
        }
    }

    protected void buildRules(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter(packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.compileKnowledgePackages(packageDescr, pkgRegistry);
            this.setAssetFilter(null);
        }
        this.wireAllRules();
        this.processKieBaseTypes();
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter(packageDescr.getFilter());
            this.compileRete(packageDescr);
            this.setAssetFilter(null);
        }
    }

    public static interface AssetFilter {
        public Action accept(ResourceChange.Type var1, String var2, String var3);

        public static enum Action {
            DO_NOTHING,
            ADD,
            REMOVE,
            UPDATE;

        }
    }

    public static class ResourceRemovalResult {
        private boolean modified;
        private Collection<String> removedTypes;

        public ResourceRemovalResult() {
            this(false, Collections.emptyList());
        }

        public ResourceRemovalResult(boolean modified, Collection<String> removedTypes) {
            this.modified = modified;
            this.removedTypes = removedTypes;
        }

        public void add(ResourceRemovalResult other) {
            this.mergeModified(other.modified);
            if (this.removedTypes.isEmpty()) {
                this.removedTypes = other.removedTypes;
            } else {
                this.removedTypes.addAll(other.removedTypes);
            }
        }

        public void mergeModified(boolean otherModified) {
            this.modified = this.modified || otherModified;
        }

        public boolean isModified() {
            return this.modified;
        }

        public Collection<String> getRemovedTypes() {
            return this.removedTypes;
        }
    }

    public static class PackageMergeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 400L;

        public PackageMergeException(String message) {
            super(message);
        }
    }

    public static class MissingPackageNameException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 510L;

        public MissingPackageNameException(String message) {
            super(message);
        }
    }

    private static class SortedRules {
        List<RuleDescr> queries;
        final List<List<RuleDescr>> rules = new ArrayList<List<RuleDescr>>();
        List<RuleDescr> current = new ArrayList<RuleDescr>();

        SortedRules() {
            this.newLevel();
        }

        void addRule(RuleDescr rule) {
            this.current.add(rule);
        }

        void newLevel() {
            this.current = new ArrayList<RuleDescr>();
            this.rules.add(this.current);
        }
    }
}

