/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.MessageType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

public class VerifierMessage
extends VerifierMessageBase {
    private static final long serialVersionUID = 510L;
    protected final Collection<Cause> causes;

    public VerifierMessage(Map<String, String> impactedRules, Severity severity, MessageType messageType, Cause faulty, String message, Collection<Cause> causes) {
        super(impactedRules, severity, messageType, faulty, message);
        this.causes = causes;
    }

    public VerifierMessage(Map<String, String> impactedRules, Severity severity, MessageType messageType, Cause faulty, String message, Cause cause) {
        super(impactedRules, severity, messageType, faulty, message);
        ArrayList<Cause> causes = new ArrayList<Cause>();
        causes.add(cause);
        this.causes = causes;
    }

    public VerifierMessage(Map<String, String> impactedRules, Severity severity, MessageType messageType, Cause faulty, String message) {
        super(impactedRules, severity, messageType, faulty, message);
        this.causes = Collections.emptyList();
    }

    @Override
    public Collection<Cause> getCauses() {
        return this.causes;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer(this.severity.getSingular());
        str.append(" id = ");
        str.append(this.id);
        str.append(":\n");
        if (!this.getImpactedRules().isEmpty()) {
            str.append("Impacted rules:\n");
            for (String ruleName : this.getImpactedRules().values()) {
                str.append("    -" + ruleName + "\n");
            }
        }
        if (this.faulty != null) {
            str.append("faulty : ");
            str.append(this.faulty);
            str.append("\n");
        }
        str.append(this.message);
        str.append(" \n\tCause trace: \n");
        str.append(this.printCauses(8, this.causes));
        return str.toString();
    }

    private StringBuffer printCauses(int spaces, Collection<Cause> causes) {
        StringBuffer buffer = new StringBuffer();
        for (Cause cause : causes) {
            for (int i = 0; i < spaces; ++i) {
                buffer.append(" ");
            }
            buffer.append(cause.toString());
            buffer.append("\n");
            Collection<Cause> childCauses = cause.getCauses();
            if (childCauses == null) {
                System.out.println(cause);
            }
            if (childCauses.isEmpty()) continue;
            buffer.append(this.printCauses(spaces * 2, childCauses));
        }
        return buffer;
    }
}

