/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.support;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.appformer.maven.support.AFReleaseId;

public class AFReleaseIdImpl
implements AFReleaseId,
Externalizable {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String snapshotVersion;

    public AFReleaseIdImpl() {
    }

    public AFReleaseIdImpl(String releaseId) {
        String[] split = releaseId.split(":");
        this.groupId = split[0];
        this.artifactId = split[1];
        this.version = split[2];
    }

    public AFReleaseIdImpl(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, "jar");
    }

    public AFReleaseIdImpl(String groupId, String artifactId, String version, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.type == null || this.type.equals("jar") ? this.groupId + ":" + this.artifactId + ":" + this.version : this.groupId + ":" + this.artifactId + ":" + this.type + ":" + this.version;
    }

    @Override
    public String toExternalForm() {
        return this.toString();
    }

    public String getPomXmlPath() {
        return AFReleaseIdImpl.getPomXmlPath(this);
    }

    public String getPomPropertiesPath() {
        return AFReleaseIdImpl.getPomPropertiesPath(this);
    }

    public static String getPomXmlPath(AFReleaseId releaseId) {
        return "META-INF/maven/" + releaseId.getGroupId() + "/" + releaseId.getArtifactId() + "/pom.xml";
    }

    public static String getPomPropertiesPath(AFReleaseId releaseId) {
        return "META-INF/maven/" + releaseId.getGroupId() + "/" + releaseId.getArtifactId() + "/pom.properties";
    }

    public String getCompilationCachePathPrefix() {
        return "META-INF/";
    }

    @Override
    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AFReleaseIdImpl that = (AFReleaseIdImpl)o;
        return this.equalsIgnoreNull(this.artifactId, that.artifactId) && this.equalsIgnoreNull(this.groupId, that.groupId) && this.equalsIgnoreNull(this.version, that.version) && this.equalsIgnoreNull(this.type, that.type);
    }

    private boolean equalsIgnoreNull(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 29 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 37 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(String snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.groupId);
        out.writeObject(this.artifactId);
        out.writeObject(this.version);
        out.writeObject(this.type);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.groupId = (String)in.readObject();
        this.artifactId = (String)in.readObject();
        this.version = (String)in.readObject();
        this.type = (String)in.readObject();
    }

    protected static boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

