/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.TupleSets;
import org.drools.core.common.UpdateContext;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Activation;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeftInputAdapterNode
extends LeftTupleSource
implements ObjectSinkNode,
MemoryFactory<LiaNodeMemory> {
    protected static final transient Logger log = LoggerFactory.getLogger(LeftInputAdapterNode.class);
    private static final long serialVersionUID = 510L;
    private ObjectSource objectSource;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private boolean leftTupleMemoryEnabled;
    private BitMask sinkMask;

    public LeftInputAdapterNode() {
    }

    public LeftInputAdapterNode(int id, ObjectSource source, BuildContext context) {
        super(id, context);
        this.objectSource = source;
        this.leftTupleMemoryEnabled = context.isTupleMemoryEnabled();
        ObjectSource current = source;
        while (current.getType() != 30) {
            current = current.getParentObjectSource();
        }
        this.setStreamMode(context.isStreamMode() && context.getRootObjectTypeNode().getObjectType().isEvent());
        this.sinkMask = this.calculateSinkMask(context);
        this.hashcode = this.calculateHashCode();
    }

    private BitMask calculateSinkMask(BuildContext context) {
        Pattern pattern;
        Pattern pattern2 = pattern = context.getLastBuiltPatterns() != null ? context.getLastBuiltPatterns()[0] : null;
        if (pattern == null) {
            return AllSetBitMask.get();
        }
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            return AllSetBitMask.get();
        }
        Class<?> objectClass = ((ClassWireable)((Object)objectType)).getClassType();
        return PropertySpecificUtil.isPropertyReactive(context, objectClass) ? PropertySpecificUtil.calculatePositiveMask(objectClass, pattern.getListenedProperties(), PropertySpecificUtil.getAccessibleProperties(context.getKnowledgeBase(), objectClass)) : AllSetBitMask.get();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.objectSource = (ObjectSource)in.readObject();
        this.leftTupleMemoryEnabled = in.readBoolean();
        this.sinkMask = (BitMask)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.objectSource);
        out.writeBoolean(this.leftTupleMemoryEnabled);
        out.writeObject(this.sinkMask);
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    @Override
    public short getType() {
        return 120;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.leftTupleMemoryEnabled;
    }

    public ObjectSource getParentObjectSource() {
        return this.objectSource;
    }

    @Override
    public void attach(BuildContext context) {
        this.objectSource.addObjectSink(this);
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.objectSource.networkUpdated(updateContext);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        LiaNodeMemory lm = workingMemory.getNodeMemory(this);
        LeftInputAdapterNode.doInsertObject(factHandle, context, this, workingMemory, lm, true, true);
    }

    public static void doInsertObject(InternalFactHandle factHandle, PropagationContext context, LeftInputAdapterNode liaNode, InternalWorkingMemory wm, LiaNodeMemory lm, boolean linkOrNotify, boolean useLeftMemory) {
        boolean notifySegment;
        SegmentMemory sm = lm.getOrCreateSegmentMemory(liaNode, wm);
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                SegmentUtilities.createChildSegments(wm, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        int counter = lm.getAndIncreaseCounter();
        boolean bl = notifySegment = linkOrNotify && counter != 0;
        if (counter == 0) {
            if (linkOrNotify) {
                lm.linkNode(wm);
            } else {
                lm.linkNodeWithoutRuleNotify();
            }
        }
        LeftTupleSink sink = liaNode.getSinkPropagator().getFirstLeftTupleSink();
        LeftTuple leftTuple = sink.createLeftTuple(factHandle, sink, useLeftMemory);
        leftTuple.setPropagationContext(context);
        LeftInputAdapterNode.doInsertSegmentMemory(wm, notifySegment, lm, sm, leftTuple, liaNode.isStreamMode());
        if (sm.getRootNode() != liaNode) {
            for (sm = sm.getNext(); sm != null; sm = sm.getNext()) {
                sink = sm.getSinkFactory();
                leftTuple = sink.createPeer(leftTuple);
                LeftInputAdapterNode.doInsertSegmentMemory(wm, notifySegment, lm, sm, leftTuple, liaNode.isStreamMode());
            }
        }
    }

    public static void doInsertSegmentMemory(InternalWorkingMemory wm, boolean linkOrNotify, LiaNodeMemory lm, SegmentMemory sm, LeftTuple leftTuple, boolean streamMode) {
        if (AddRemoveRule.flushLeftTupleIfNecessary(wm, sm, leftTuple, streamMode, (short)1)) {
            if (linkOrNotify) {
                lm.setNodeDirty(wm);
            }
            return;
        }
        boolean stagedInsertWasEmpty = sm.getStagedLeftTuples().addInsert(leftTuple);
        if (stagedInsertWasEmpty && linkOrNotify) {
            lm.setNodeDirty(wm);
        }
    }

    public static void doDeleteObject(LeftTuple leftTuple, PropagationContext context, SegmentMemory sm, InternalWorkingMemory wm, LeftInputAdapterNode liaNode, boolean linkOrNotify, LiaNodeMemory lm) {
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                SegmentUtilities.createChildSegments(wm, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        LeftInputAdapterNode.doDeleteSegmentMemory(leftTuple, context, lm, sm, wm, linkOrNotify, liaNode.isStreamMode());
        if (sm.getNext() != null) {
            for (sm = sm.getNext(); sm != null && (leftTuple = leftTuple.getPeer()) != null; sm = sm.getNext()) {
                LeftInputAdapterNode.doDeleteSegmentMemory(leftTuple, context, lm, sm, wm, linkOrNotify, liaNode.isStreamMode());
            }
        }
        if (lm.getAndDecreaseCounter() == 1) {
            if (linkOrNotify) {
                lm.unlinkNode(wm);
            } else {
                lm.unlinkNodeWithoutRuleNotify();
            }
        }
    }

    private static void doDeleteSegmentMemory(LeftTuple leftTuple, PropagationContext pctx, LiaNodeMemory lm, SegmentMemory sm, InternalWorkingMemory wm, boolean linkOrNotify, boolean streamMode) {
        leftTuple.setPropagationContext(pctx);
        if (AddRemoveRule.flushLeftTupleIfNecessary(wm, sm, leftTuple, streamMode, (short)3)) {
            if (linkOrNotify) {
                lm.setNodeDirty(wm);
            }
            return;
        }
        TupleSets<LeftTuple> leftTuples = sm.getStagedLeftTuples();
        boolean stagedDeleteWasEmpty = leftTuples.addDelete(leftTuple);
        if (stagedDeleteWasEmpty && linkOrNotify) {
            lm.setNodeDirty(wm);
        }
    }

    public static void doUpdateObject(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory wm, LeftInputAdapterNode liaNode, boolean linkOrNotify, LiaNodeMemory lm, SegmentMemory sm) {
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                SegmentUtilities.createChildSegments(wm, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        TupleSets<LeftTuple> leftTuples = sm.getStagedLeftTuples();
        LeftInputAdapterNode.doUpdateSegmentMemory(leftTuple, context, wm, linkOrNotify, lm, leftTuples, sm, liaNode.isStreamMode());
        if (sm.getNext() != null) {
            for (sm = sm.getNext(); sm != null; sm = sm.getNext()) {
                leftTuple = leftTuple.getPeer();
                leftTuples = sm.getStagedLeftTuples();
                LeftInputAdapterNode.doUpdateSegmentMemory(leftTuple, context, wm, linkOrNotify, lm, leftTuples, sm, liaNode.isStreamMode());
            }
        }
    }

    private static void doUpdateSegmentMemory(LeftTuple leftTuple, PropagationContext pctx, InternalWorkingMemory wm, boolean linkOrNotify, LiaNodeMemory lm, TupleSets<LeftTuple> leftTuples, SegmentMemory sm, boolean streamMode) {
        leftTuple.setPropagationContext(pctx);
        if (leftTuple.getStagedType() == 0) {
            if (AddRemoveRule.flushLeftTupleIfNecessary(wm, sm, leftTuple, streamMode, (short)2)) {
                if (linkOrNotify) {
                    lm.setNodeDirty(wm);
                }
                return;
            }
            boolean stagedUpdateWasEmpty = leftTuples.addUpdate(leftTuple);
            if (stagedUpdateWasEmpty && linkOrNotify) {
                lm.setNodeDirty(wm);
            }
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LiaNodeMemory lm = workingMemory.getNodeMemory(this);
        SegmentMemory smem = lm.getSegmentMemory();
        if (smem.getTipNode() == this) {
            smem = (SegmentMemory)smem.getFirst();
        }
        LeftInputAdapterNode.doDeleteObject(leftTuple, context, smem, workingMemory, this, true, lm);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNode.Id otnId = this.sink.getFirstLeftTupleSink().getLeftInputOtnId();
        LeftTuple leftTuple = this.processDeletesFromModify(modifyPreviousTuples, context, workingMemory, otnId);
        LiaNodeMemory lm = workingMemory.getNodeMemory(this);
        if (leftTuple != null && leftTuple.getInputOtnId().equals(otnId)) {
            modifyPreviousTuples.removeLeftTuple(this.partitionId);
            leftTuple.reAdd();
            LeftTupleSinkNode sink = this.getSinkPropagator().getFirstLeftTupleSink();
            BitMask mask = sink.getLeftInferredMask();
            if (context.getModificationMask().intersects(mask)) {
                LeftInputAdapterNode.doUpdateObject(leftTuple, context, workingMemory, (LeftInputAdapterNode)leftTuple.getTupleSource(), true, lm, lm.getOrCreateSegmentMemory(this, workingMemory));
                if (leftTuple instanceof Activation) {
                    ((Activation)((Object)leftTuple)).setActive(true);
                }
            }
        } else {
            LeftTupleSinkNode sink = this.getSinkPropagator().getFirstLeftTupleSink();
            BitMask mask = sink.getLeftInferredMask();
            if (context.getModificationMask().intersects(mask)) {
                LeftInputAdapterNode.doInsertObject(factHandle, context, this, workingMemory, lm, true, true);
            }
        }
    }

    private LeftTuple processDeletesFromModify(ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, ObjectTypeNode.Id otnId) {
        LeftTuple leftTuple = modifyPreviousTuples.peekLeftTuple(this.partitionId);
        while (leftTuple != null && leftTuple.getInputOtnId().before(otnId)) {
            modifyPreviousTuples.removeLeftTuple(this.partitionId);
            LeftInputAdapterNode prevLiaNode = (LeftInputAdapterNode)leftTuple.getTupleSource();
            LiaNodeMemory prevLm = workingMemory.getNodeMemory(prevLiaNode);
            SegmentMemory prevSm = prevLm.getSegmentMemory();
            LeftInputAdapterNode.doDeleteObject(leftTuple, context, prevSm, workingMemory, prevLiaNode, true, prevLm);
            leftTuple = modifyPreviousTuples.peekLeftTuple(this.partitionId);
        }
        return leftTuple;
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.objectSource.removeObjectSink(this);
            return true;
        }
        return false;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    private int calculateHashCode() {
        return 31 * this.objectSource.hashCode() + 37 * this.sinkMask.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof LeftInputAdapterNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        return this.objectSource.getId() == ((LeftInputAdapterNode)object).objectSource.getId() && this.sinkMask.equals(((LeftInputAdapterNode)object).sinkMask);
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this.objectSource;
        while (source != null) {
            if (source instanceof ObjectTypeNode) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    @Override
    public LiaNodeMemory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new LiaNodeMemory();
    }

    @Override
    public void setSourcePartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        this.setSourcePartitionId(this.objectSource, context, partitionId);
    }

    @Override
    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        if (this.partitionId != null && this.partitionId != partitionId) {
            this.objectSource.sink.changeSinkPartition(this, this.partitionId, partitionId, this.objectSource.alphaNodeHashingThreshold);
        }
        this.partitionId = partitionId;
    }

    public static class RightTupleSinkAdapter
    implements ObjectSink {
        private LeftTupleSink sink;
        private boolean leftTupleMemoryEnabled;
        private LeftInputAdapterNode liaNode;

        public RightTupleSinkAdapter(LeftInputAdapterNode liaNode) {
            this.liaNode = liaNode;
        }

        public RightTupleSinkAdapter(LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            this.sink = sink;
            this.leftTupleMemoryEnabled = leftTupleMemoryEnabled;
        }

        public RightTupleSinkAdapter() {
        }

        @Override
        public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
            this.liaNode.assertObject(factHandle, context, workingMemory);
        }

        @Override
        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getType() {
            return 120;
        }

        @Override
        public int getAssociationsSize() {
            return this.sink.getAssociationsSize();
        }

        @Override
        public int getAssociatedRuleSize() {
            return this.sink.getAssociatedRuleSize();
        }

        @Override
        public int getAssociationsSize(Rule rule) {
            return this.sink.getAssociationsSize(rule);
        }

        @Override
        public boolean isAssociatedWith(Rule rule) {
            return this.sink.isAssociatedWith(rule);
        }

        public boolean thisNodeEquals(Object object) {
            return false;
        }

        public int nodeHashCode() {
            return this.hashCode();
        }
    }

    public static class LiaNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements SegmentNodeMemory {
        private int counter;
        private SegmentMemory segmentMemory;
        private long nodePosMaskBit;

        public int getCounter() {
            return this.counter;
        }

        public int getAndIncreaseCounter() {
            return this.counter++;
        }

        public int getAndDecreaseCounter() {
            return this.counter--;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.segmentMemory;
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentNodes) {
            this.segmentMemory = segmentNodes;
        }

        @Override
        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        @Override
        public void setNodePosMaskBit(long nodePosMask) {
            this.nodePosMaskBit = nodePosMask;
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
        }

        @Override
        public void setNodeCleanWithoutNotify() {
        }

        public void linkNodeWithoutRuleNotify() {
            this.segmentMemory.linkNodeWithoutRuleNotify(this.nodePosMaskBit);
        }

        public void linkNode(InternalWorkingMemory wm) {
            this.segmentMemory.linkNode(this.nodePosMaskBit, wm);
        }

        public boolean unlinkNode(InternalWorkingMemory wm) {
            return this.segmentMemory.unlinkNode(this.nodePosMaskBit, wm);
        }

        public void unlinkNodeWithoutRuleNotify() {
            this.segmentMemory.unlinkNodeWithoutRuleNotify(this.nodePosMaskBit);
        }

        @Override
        public short getNodeType() {
            return 120;
        }

        public void setNodeDirty(InternalWorkingMemory wm) {
            this.segmentMemory.notifyRuleLinkSegment(wm, this.nodePosMaskBit);
        }

        @Override
        public void reset() {
            this.counter = 0;
        }
    }
}

