/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime;

import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.KieBase;
import org.kie.api.internal.runtime.KieRuntimeService;
import org.kie.api.internal.runtime.KieRuntimes;
import org.kie.api.internal.utils.ServiceRegistry;

public class KieRuntimeFactory {
    private final KieBase kieBase;
    private final ConcurrentHashMap<Class<?>, Object> runtimeServices = new ConcurrentHashMap();

    public static KieRuntimeFactory of(KieBase kieBase) {
        return new KieRuntimeFactory(kieBase);
    }

    private KieRuntimeFactory(KieBase kieBase) {
        this.kieBase = kieBase;
    }

    public <T> T get(Class<T> cls) {
        Object runtimeInstance = this.runtimeServices.computeIfAbsent(cls, this::createRuntimeInstance);
        if (runtimeInstance == null) {
            throw new NoSuchElementException(cls.getName());
        }
        return (T)runtimeInstance;
    }

    private Object createRuntimeInstance(Class<?> c) {
        KieRuntimeService kieRuntimeService = ServiceRegistry.getInstance().get(KieRuntimes.class).getRuntimes().get(c.getName());
        if (kieRuntimeService == null) {
            return null;
        }
        return kieRuntimeService.newKieRuntime(this.kieBase);
    }
}

