/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.Optional;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.RuleBuildError;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.DroolsCompilerComponentFactory;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.beliefsystem.abductive.Abductive;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.AbductiveQuery;
import org.drools.core.rule.Dialectable;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryImpl;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.util.ClassUtils;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class RuleBuildContext
extends PackageBuildContext {
    private final RuleImpl rule;
    private final RuleDescr ruleDescr;
    private DeclarationScopeResolver declarationResolver;
    private int patternId = -1;
    private final DroolsCompilerComponentFactory compilerFactory;
    private boolean needStreamMode = false;
    private Pattern prefixPattern;
    private boolean inXpath;

    public RuleBuildContext(DroolsAssemblerContext kBuilder, RuleDescr ruleDescr, DialectCompiletimeRegistry dialectCompiletimeRegistry, InternalKnowledgePackage pkg, Dialect defaultDialect) {
        Dialect dialect;
        Abductive abductive;
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? ((abductive = ruleDescr.getTypedAnnotation(Abductive.class)) == null ? new QueryImpl(ruleDescr.getName()) : new AbductiveQuery(ruleDescr.getName())) : ruleDescr.toRule();
        this.rule.setPackage(pkg.getName());
        this.rule.setDialect(ruleDescr.getDialect());
        this.rule.setLoadOrder(ruleDescr.getLoadOrder());
        this.init(kBuilder, pkg, ruleDescr, dialectCompiletimeRegistry, defaultDialect, (Dialectable)this.rule);
        if (this.rule.getDialect() == null) {
            this.rule.setDialect(this.getDialect().getId());
        }
        if (ruleDescr.getUnit() != null) {
            this.rule.setRuleUnitClassName(pkg.getName() + "." + ruleDescr.getUnit().getTarget().replace('.', '$'));
        }
        if ((dialect = this.getDialect()) != null) {
            dialect.init(ruleDescr);
        }
        this.compilerFactory = kBuilder.getBuilderConfiguration().getComponentFactory();
        this.declarationResolver = new DeclarationScopeResolver(kBuilder.getGlobals(), this.getPkg());
    }

    public RuleImpl getRule() {
        return this.rule;
    }

    public RuleDescr getRuleDescr() {
        return this.ruleDescr;
    }

    public DeclarationScopeResolver getDeclarationResolver() {
        return this.declarationResolver;
    }

    public void setDeclarationResolver(DeclarationScopeResolver declarationResolver) {
        this.declarationResolver = declarationResolver;
    }

    public int getNextPatternId() {
        return ++this.patternId;
    }

    public DroolsCompilerComponentFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public boolean needsStreamMode() {
        return this.needStreamMode;
    }

    public void setNeedStreamMode() {
        this.needStreamMode = true;
    }

    public void setPrefixPattern(Pattern prefixPattern) {
        this.prefixPattern = prefixPattern;
    }

    public Pattern getPrefixPattern() {
        return this.prefixPattern;
    }

    public boolean isInXpath() {
        return this.inXpath;
    }

    public void setInXpath(boolean inXpath) {
        this.inXpath = inXpath;
    }

    public void initRule() {
        this.initRuleUnitClassName();
        this.declarationResolver.setRule(this.rule);
    }

    @Override
    public Class<?> resolveVarType(String identifier) {
        return this.getDeclarationResolver().resolveVarType(identifier);
    }

    private void initRuleUnitClassName() {
        String ruleUnitClassName = this.rule.getRuleUnitClassName();
        boolean nameInferredFromResource = false;
        if (ruleUnitClassName == null && this.rule.getResource() != null && this.rule.getResource().getSourcePath() != null) {
            ruleUnitClassName = this.extractClassNameFromSourcePath();
            nameInferredFromResource = true;
        }
        if (ruleUnitClassName != null) {
            TypeResolver typeResolver = this.getPkg().getTypeResolver();
            boolean unitFound = false;
            Class ruleUnitClass = ClassUtils.safeLoadClass((ClassLoader)typeResolver.getClassLoader(), (String)ruleUnitClassName);
            if (ruleUnitClass != null && (unitFound = RuleUnit.class.isAssignableFrom(ruleUnitClass)) && nameInferredFromResource) {
                this.rule.setRuleUnitClassName(ruleUnitClassName);
            }
            if (!unitFound && !nameInferredFromResource) {
                this.addError(new RuleBuildError(this.rule, this.getParentDescr(), null, ruleUnitClassName + " is not a valid RuleUnit class name"));
            }
        }
    }

    public Optional<EntryPointId> getEntryPointId(String name) {
        return this.getPkg().getRuleUnitDescriptionLoader().getDescription(this.getRule()).flatMap(ruDescr -> ruDescr.getEntryPointId(name));
    }

    private String extractClassNameFromSourcePath() {
        String drlPath = this.rule.getResource().getSourcePath();
        int fileTypeDotIndex = drlPath.lastIndexOf(46);
        if (fileTypeDotIndex > 0) {
            drlPath = drlPath.substring(0, fileTypeDotIndex);
        }
        StringBuilder classNameBuilder = new StringBuilder();
        int actualIndex = drlPath.length() - 1;
        char actualChar = drlPath.charAt(actualIndex);
        while (Character.isJavaIdentifierPart(actualChar) || Character.isJavaIdentifierStart(actualChar)) {
            classNameBuilder.append(actualChar);
            if (--actualIndex < 0) break;
            actualChar = drlPath.charAt(actualIndex);
        }
        return this.rule.getPackage() + "." + classNameBuilder.reverse().toString();
    }
}

