/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationUtils;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.EnumLiteralDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QualifiedName;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.compiler.rule.builder.util.AnnotationFactory;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.EnumClassDefinition;
import org.drools.core.factmodel.EnumLiteralDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.asm.ClassFieldInspector;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Position;
import org.kie.api.io.Resource;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class ClassDefinitionFactory {
    protected KnowledgeBuilderImpl kbuilder;

    public ClassDefinitionFactory(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
    }

    public ClassDefinition generateDeclaredBean(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, List<TypeDefinition> unresolvedTypeDefinitions, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        ClassDefinition def = this.createClassDefinition(typeDescr, type);
        boolean success = true;
        success &= this.wireAnnotationDefs(typeDescr, type, def, pkgRegistry.getTypeResolver());
        success &= this.wireEnumLiteralDefs(typeDescr, type, def);
        if (!(success &= this.wireFields(typeDescr, type, def, pkgRegistry, unresolvedTypeDefinitions))) {
            unprocesseableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
        }
        type.setTypeClassDef(def);
        return def;
    }

    protected ClassDefinition createClassDefinition(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type) {
        ClassDefinition def;
        Traitable traitableAnn;
        String fullName = typeDescr.getType().getFullName();
        if (type.getKind().equals((Object)TypeDeclaration.Kind.CLASS)) {
            TypeDeclarationDescr tdescr = (TypeDeclarationDescr)typeDescr;
            if (tdescr.getSuperTypes().size() > 1) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Declared class " + fullName + "  - has more than one supertype;"));
                return null;
            }
            if (tdescr.getSuperTypes().isEmpty()) {
                tdescr.addSuperType("java.lang.Object");
            }
        }
        boolean traitable = (traitableAnn = typeDescr.getTypedAnnotation(Traitable.class)) != null;
        String[] fullSuperTypes = new String[typeDescr.getSuperTypes().size() + 1];
        int j = 0;
        for (QualifiedName qname : typeDescr.getSuperTypes()) {
            fullSuperTypes[j++] = qname.getFullName();
        }
        fullSuperTypes[j] = Thing.class.getName();
        ArrayList<String> interfaceList = new ArrayList<String>();
        interfaceList.add(traitable ? Externalizable.class.getName() : Serializable.class.getName());
        if (traitable) {
            interfaceList.add(TraitableBean.class.getName());
        }
        String[] interfaces = interfaceList.toArray(new String[interfaceList.size()]);
        switch (type.getKind()) {
            case TRAIT: {
                def = new ClassDefinition(fullName, Object.class.getName(), fullSuperTypes);
                break;
            }
            case ENUM: {
                def = new EnumClassDefinition(fullName, fullSuperTypes[0], null);
                break;
            }
            default: {
                def = new ClassDefinition(fullName, fullSuperTypes[0], interfaces);
                def.setTraitable(traitable, traitableAnn != null && traitableAnn.logical());
            }
        }
        return def;
    }

    protected boolean wireAnnotationDefs(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, ClassDefinition def, TypeResolver resolver) {
        for (AnnotationDescr annotationDescr : typeDescr.getAnnotations()) {
            Class annotation = null;
            try {
                annotation = annotationDescr.getFullyQualifiedName() != null ? resolver.resolveType(annotationDescr.getFullyQualifiedName()) : null;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (annotation != null && annotation.isAnnotation()) {
                try {
                    AnnotationDefinition annotationDefinition = AnnotationDefinition.build((Class)annotation, annotationDescr.getValueMap(), (TypeResolver)resolver);
                    def.addAnnotation(annotationDefinition);
                }
                catch (NoSuchMethodException nsme) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Annotated type " + typeDescr.getType().getFullName() + "  - undefined property in @annotation " + annotationDescr.getName() + ": " + nsme.getMessage() + ";"));
                }
            }
            if (annotation != null && !annotation.getCanonicalName().startsWith("org.kie.api.definition.type")) continue;
            def.addMetaData(annotationDescr.getName(), annotationDescr.getSingleValue());
        }
        return true;
    }

    protected boolean wireEnumLiteralDefs(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, ClassDefinition def) {
        if (type.getKind() == TypeDeclaration.Kind.ENUM) {
            for (EnumLiteralDescr lit : ((EnumDeclarationDescr)typeDescr).getLiterals()) {
                ((EnumClassDefinition)def).addLiteral(new EnumLiteralDefinition(lit.getName(), lit.getConstructorArgs()));
            }
        }
        return true;
    }

    protected boolean wireFields(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, ClassDefinition def, PackageRegistry pkgRegistry, List<TypeDefinition> unresolvedTypeDefinitions) {
        if (!typeDescr.getFields().isEmpty()) {
            if (unresolvedTypeDefinitions != null && !unresolvedTypeDefinitions.isEmpty()) {
                for (TypeFieldDescr fld : typeDescr.getFields().values()) {
                    if (unresolvedTypeDefinitions == null) continue;
                    for (TypeDefinition typeDef : unresolvedTypeDefinitions) {
                        if (!fld.getPattern().getObjectType().equals(typeDef.getTypeClassName())) continue;
                        return false;
                    }
                }
            }
            List<FieldDefinition> fieldDefs = ClassDefinitionFactory.sortFields(typeDescr.getFields(), pkgRegistry.getTypeResolver(), this.kbuilder);
            int i = 0;
            for (FieldDefinition fieldDef : fieldDefs) {
                fieldDef.setIndex(i++);
                def.addField(fieldDef);
            }
        }
        return true;
    }

    private static List<FieldDefinition> sortFields(Map<String, TypeFieldDescr> fields, TypeResolver typeResolver, KnowledgeBuilderImpl kbuilder) {
        ArrayList<FieldDefinition> fieldDefs = new ArrayList<FieldDefinition>(fields.size());
        int maxDeclaredPos = 0;
        BitSet occupiedPositions = new BitSet(fields.size());
        for (TypeFieldDescr field : fields.values()) {
            String typeName;
            String typeNameKey = typeName = field.getPattern().getObjectType();
            String fullFieldType = kbuilder != null ? TypeDeclarationUtils.toBuildableType(typeNameKey, kbuilder.getRootClassLoader()) : typeNameKey;
            FieldDefinition fieldDef = new FieldDefinition(field.getFieldName(), fullFieldType);
            fieldDefs.add(fieldDef);
            if (field.hasOverride()) {
                fieldDef.setOverriding(field.getOverriding().getPattern().getObjectType());
            }
            fieldDef.setInherited(field.isInherited());
            fieldDef.setRecursive(field.isRecursive());
            fieldDef.setInitExpr(TypeDeclarationUtils.rewriteInitExprWithImports(field.getInitExpr(), typeResolver));
            if (field.getIndex() >= 0) {
                int pos = field.getIndex();
                occupiedPositions.set(pos);
                maxDeclaredPos = Math.max(maxDeclaredPos, pos);
                fieldDef.addMetaData("position", (Object)pos);
            } else {
                Position position = field.getTypedAnnotation(Position.class);
                if (position != null) {
                    int pos = position.value();
                    field.setIndex(pos);
                    occupiedPositions.set(pos);
                    maxDeclaredPos = Math.max(maxDeclaredPos, pos);
                    fieldDef.addMetaData("position", (Object)pos);
                }
            }
            if (field.hasAnnotation(Key.class)) {
                fieldDef.setKey(true);
                fieldDef.addMetaData("key", null);
            }
            for (AnnotationDescr annotationDescr : field.getAnnotations()) {
                Annotation annotation;
                if (annotationDescr.getFullyQualifiedName() == null) {
                    if (annotationDescr.isStrict()) {
                        kbuilder.addBuilderResult(new TypeDeclarationError(field, "Unknown annotation @" + annotationDescr.getName() + " on field " + field.getFieldName()));
                    } else {
                        fieldDef.addMetaData(annotationDescr.getName(), annotationDescr.getSingleValue());
                        continue;
                    }
                }
                if ((annotation = AnnotationFactory.buildAnnotation(typeResolver, annotationDescr)) != null) {
                    try {
                        AnnotationDefinition annotationDefinition = AnnotationDefinition.build(annotation.annotationType(), field.getAnnotation(annotationDescr.getFullyQualifiedName()).getValueMap(), (TypeResolver)typeResolver);
                        fieldDef.addAnnotation(annotationDefinition);
                    }
                    catch (Exception e) {
                        kbuilder.addBuilderResult(new TypeDeclarationError(field, "Annotated field " + field.getFieldName() + "  - undefined property in @annotation " + annotationDescr.getName() + ": " + e.getMessage() + ";"));
                    }
                    continue;
                }
                if (!annotationDescr.isStrict()) continue;
                kbuilder.addBuilderResult(new TypeDeclarationError(field, "Unknown annotation @" + annotationDescr.getName() + " on field " + field.getFieldName()));
            }
            fieldDef.setDeclIndex(field.getIndex());
        }
        int curr = 0;
        for (FieldDefinition fieldDef : fieldDefs) {
            if (fieldDef.getDeclIndex() < 0) {
                int freePos = occupiedPositions.nextClearBit(0);
                if (freePos < maxDeclaredPos) {
                    occupiedPositions.set(freePos);
                } else {
                    freePos = maxDeclaredPos + 1;
                }
                fieldDef.setPriority(freePos * 256 + curr++);
                continue;
            }
            fieldDef.setPriority(fieldDef.getDeclIndex() * 256 + curr++);
        }
        Collections.sort(fieldDefs);
        return fieldDefs;
    }

    public static ClassDefinition createClassDefinition(Class<?> typeClass, Resource resource) {
        ClassDefinition clsDef = new ClassDefinition();
        ClassDefinitionFactory.populateDefinitionFromClass(clsDef, resource, typeClass, typeClass.getAnnotation(Trait.class) != null);
        return clsDef;
    }

    public static void populateDefinitionFromClass(ClassDefinition def, Resource resource, Class<?> concrete, boolean asTrait) {
        try {
            def.setClassName(concrete.getName());
            if (concrete.getSuperclass() != null) {
                def.setSuperClass(concrete.getSuperclass().getName());
            }
            ClassFieldInspector inspector = new ClassFieldInspector(concrete);
            Map methods = inspector.getGetterMethods();
            Map setters = inspector.getSetterMethods();
            boolean j = false;
            HashMap<String, TypeFieldDescr> fields = new HashMap<String, TypeFieldDescr>();
            for (String fieldName : methods.keySet()) {
                if (asTrait && ("core".equals(fieldName) || "fields".equals(fieldName)) || inspector.isNonGetter(fieldName) || !setters.keySet().contains(fieldName)) continue;
                Position position = null;
                if (!concrete.isInterface()) {
                    try {
                        Field fld = concrete.getDeclaredField(fieldName);
                        position = fld.getAnnotation(Position.class);
                    }
                    catch (NoSuchFieldException fld) {
                        // empty catch block
                    }
                }
                Class<?> ret = ((Method)methods.get(fieldName)).getReturnType();
                TypeFieldDescr field = new TypeFieldDescr();
                field.setResource(resource);
                field.setFieldName(fieldName);
                field.setPattern(new PatternDescr(ret.getName()));
                field.setIndex(position != null ? position.value() : -1);
                fields.put(fieldName, field);
            }
            if (!fields.isEmpty()) {
                List<FieldDefinition> fieldDefs = ClassDefinitionFactory.sortFields(fields, null, null);
                int i = 0;
                for (FieldDefinition fieldDef : fieldDefs) {
                    fieldDef.setIndex(i++);
                    def.addField(fieldDef);
                }
            }
            HashSet<String> interfaces = new HashSet<String>();
            Collections.addAll(interfaces, def.getInterfaces());
            for (Class iKlass : ClassUtils.getAllImplementedInterfaceNames(concrete)) {
                interfaces.add(iKlass.getName());
            }
            def.setInterfaces(interfaces.toArray(new String[interfaces.size()]));
            def.setDefinedClass(concrete);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

