/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;

public class CompositeKnowledgeBuilderImpl
implements CompositeKnowledgeBuilder {
    private final KnowledgeBuilderImpl kBuilder;
    private final Map<ResourceType, List<ResourceDescr>> resourcesByType = new HashMap<ResourceType, List<ResourceDescr>>();
    private RuntimeException buildException = null;
    public ResourceType currentType = null;
    private static final ResourceBuilder DSL_RESOURCE_BUILDER = new ResourceBuilder(){

        @Override
        public void build(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            kBuilder.addDsl(resourceDescr.resource);
        }
    };
    private static final ResourceBuilder PMML_RESOURCE_BUILDER = new ResourceBuilder(){

        @Override
        public void build(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            kBuilder.addPackageFromPMML(resourceDescr.resource, ResourceType.PMML, resourceDescr.configuration);
        }
    };
    private static final ResourceBuilder XSD_RESOURCE_BUILDER = new ResourceBuilder(){

        @Override
        public void build(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            if (resourceDescr.configuration instanceof JaxbConfigurationImpl) {
                kBuilder.addPackageFromXSD(resourceDescr.resource, (JaxbConfigurationImpl)resourceDescr.configuration);
            }
        }
    };
    private static final ResourceBuilder CHANGE_SET_RESOURCE_BUILDER = new ResourceBuilder(){

        @Override
        public void build(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            kBuilder.addPackageFromChangeSet(resourceDescr.resource);
        }
    };
    private static final ResourceBuilder PKG_RESOURCE_BUILDER = new ResourceBuilder(){

        @Override
        public void build(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            kBuilder.addPackageFromInputStream(resourceDescr.resource);
        }
    };
    private static final ResourceBuilder BPMN2_RESOURCE_BUILDER = new ResourceBuilder(){

        @Override
        public void build(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            BPMN2ProcessFactory.configurePackageBuilder(kBuilder);
            kBuilder.addProcessFromXml(resourceDescr.resource);
        }
    };
    private static final ResourceBuilder DRF_RESOURCE_BUILDER = new ResourceBuilder(){

        @Override
        public void build(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            kBuilder.addProcessFromXml(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper DRL_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.drlToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper TEMPLATE_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.templateToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper DSLR_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.dslrToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper XML_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.xmlToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper DTABLE_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.decisionTableToPackageDescr(resourceDescr.resource, resourceDescr.configuration);
        }
    };
    private static final ResourceToPkgDescrMapper SCARD_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.scoreCardToPackageDescr(resourceDescr.resource, resourceDescr.configuration);
        }
    };
    private static final ResourceToPkgDescrMapper GUIDED_DTABLE_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.guidedDecisionTableToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper GUIDED_SCARD_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.guidedScoreCardToPackageDescr(resourceDescr.resource);
        }
    };

    public CompositeKnowledgeBuilderImpl(KnowledgeBuilderImpl kBuilder) {
        this.kBuilder = kBuilder;
    }

    public CompositeKnowledgeBuilder type(ResourceType type) {
        this.currentType = type;
        return this;
    }

    public CompositeKnowledgeBuilder add(Resource resource) {
        if (this.currentType == null) {
            throw new RuntimeException("You must declare the type of the resource");
        }
        return this.add(resource, this.currentType);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type) {
        return this.add(resource, type, resource.getConfiguration());
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceChangeSet changes) {
        return this.add(resource, type, resource.getConfiguration(), changes);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        return this.add(resource, type, configuration, null);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration, ResourceChangeSet changes) {
        ResourceDescr resourceDescr = new ResourceDescr(configuration, resource, changes);
        List<ResourceDescr> resourceDescrs = this.resourcesByType.get(type);
        if (resourceDescrs == null) {
            resourceDescrs = new ArrayList<ResourceDescr>();
            this.resourcesByType.put(type, resourceDescrs);
        }
        resourceDescrs.add(resourceDescr);
        return this;
    }

    private List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (List<ResourceDescr> resourceDescrs : this.resourcesByType.values()) {
            for (ResourceDescr resourceDescr : resourceDescrs) {
                resources.add(resourceDescr.resource);
            }
        }
        return resources;
    }

    public void build() {
        this.buildException = null;
        this.kBuilder.registerBuildResources(this.getResources());
        this.buildResources();
        this.buildPackages();
        this.buildProcesses();
        this.buildOthers();
        this.resourcesByType.clear();
        if (this.buildException != null) {
            throw this.buildException;
        }
    }

    private void buildPackages() {
        Collection<CompositePackageDescr> packages = this.buildPackageDescr();
        this.initPackageRegistries(packages);
        this.normalizeTypeAnnotations(packages);
        this.buildTypeDeclarations(packages);
        this.buildEntryPoints(packages);
        this.buildOtherDeclarations(packages);
        this.normalizeRuleAnnotations(packages);
        this.buildRules(packages);
    }

    private void buildProcesses() {
        this.buildResourceType(BPMN2_RESOURCE_BUILDER, ResourceType.BPMN2);
    }

    private void normalizeTypeAnnotations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.kBuilder.normalizeTypeDeclarationAnnotations(packageDescr, this.kBuilder.getOrCreatePackageRegistry(packageDescr).getTypeResolver());
        }
    }

    private void normalizeRuleAnnotations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.kBuilder.normalizeRuleAnnotations(packageDescr, this.kBuilder.getOrCreatePackageRegistry(packageDescr).getTypeResolver());
        }
    }

    private void buildEntryPoints(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.kBuilder.processEntryPointDeclarations(this.kBuilder.getPackageRegistry(packageDescr.getNamespace()), packageDescr);
        }
    }

    private void buildResources() {
        this.buildResourceType(DSL_RESOURCE_BUILDER, ResourceType.DSL);
        this.buildResourceType(DRF_RESOURCE_BUILDER, ResourceType.DRF);
        this.buildResourceType(PKG_RESOURCE_BUILDER, ResourceType.PKG);
        this.buildResourceType(CHANGE_SET_RESOURCE_BUILDER, ResourceType.CHANGE_SET);
        this.buildResourceType(XSD_RESOURCE_BUILDER, ResourceType.XSD);
        this.buildResourceType(PMML_RESOURCE_BUILDER, ResourceType.PMML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResourceType(ResourceBuilder resourceBuilder, ResourceType resourceType) {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(resourceType);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    resourceBuilder.build(this.kBuilder, resourceDescr);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
    }

    private void buildOthers() {
        try {
            for (Map.Entry<ResourceType, List<ResourceDescr>> entry : this.resourcesByType.entrySet()) {
                for (ResourceDescr resourceDescr : entry.getValue()) {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addPackageForExternalType(resourceDescr.resource, entry.getKey(), resourceDescr.configuration);
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildOtherDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.kBuilder.setAssetFilter(packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.kBuilder.getPackageRegistry(packageDescr.getNamespace());
            this.kBuilder.processOtherDeclarations(pkgRegistry, packageDescr);
            this.kBuilder.setAssetFilter(null);
        }
    }

    private void buildRules(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.kBuilder.setAssetFilter(packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.kBuilder.getPackageRegistry(packageDescr.getNamespace());
            this.kBuilder.compileKnowledgePackages(packageDescr, pkgRegistry);
            this.kBuilder.setAssetFilter(null);
        }
        this.kBuilder.wireAllRules();
        this.kBuilder.processKieBaseTypes();
        for (CompositePackageDescr packageDescr : packages) {
            this.kBuilder.setAssetFilter(packageDescr.getFilter());
            this.kBuilder.compileRete(packageDescr);
            this.kBuilder.setAssetFilter(null);
        }
    }

    private void buildTypeDeclarations(Collection<CompositePackageDescr> packages) {
        HashMap<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs = new HashMap<String, AbstractClassTypeDeclarationDescr>();
        ArrayList<TypeDefinition> unresolvedTypes = new ArrayList<TypeDefinition>();
        ArrayList<AbstractClassTypeDeclarationDescr> unsortedDescrs = new ArrayList<AbstractClassTypeDeclarationDescr>();
        for (CompositePackageDescr packageDescr : packages) {
            for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
                unsortedDescrs.add(typeDeclarationDescr);
            }
            for (EnumDeclarationDescr enumDeclarationDescr : packageDescr.getEnumDeclarations()) {
                unsortedDescrs.add(enumDeclarationDescr);
            }
        }
        this.kBuilder.getTypeBuilder().processTypeDeclarations(packages, unsortedDescrs, unresolvedTypes, unprocesseableDescrs);
        for (CompositePackageDescr packageDescr : packages) {
            for (ImportDescr importDescr : packageDescr.getImports()) {
                this.kBuilder.getPackageRegistry(packageDescr.getNamespace()).addImport(importDescr);
            }
        }
    }

    private void initPackageRegistries(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            if (StringUtils.isEmpty((CharSequence)packageDescr.getName())) {
                packageDescr.setName(this.kBuilder.getBuilderConfiguration().getDefaultPackageName());
            }
            this.kBuilder.getOrCreatePackageRegistry(packageDescr);
        }
    }

    private Collection<CompositePackageDescr> buildPackageDescr() {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        this.buildResource(packages, ResourceType.DRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.GDRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.RDRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DESCR, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DSLR, DSLR_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.RDSLR, DSLR_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.XDRL, XML_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DTABLE, DTABLE_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.SCARD, SCARD_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.TDRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.TEMPLATE, TEMPLATE_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.GDST, GUIDED_DTABLE_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.SCGD, GUIDED_SCARD_TO_PKG_DESCR);
        this.resourcesByType.remove(ResourceType.DRT);
        return packages.values();
    }

    private void buildResource(Map<String, CompositePackageDescr> packages, ResourceType resourceType, ResourceToPkgDescrMapper mapper) {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(resourceType);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(resourceDescr, packages, resourceDescr.resource, mapper.map(this.kBuilder, resourceDescr));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    private void registerPackageDescr(ResourceDescr resourceDescr, Map<String, CompositePackageDescr> packages, Resource resource, PackageDescr packageDescr) {
        if (packageDescr != null) {
            CompositePackageDescr compositePackageDescr = packages.get(packageDescr.getNamespace());
            if (compositePackageDescr == null) {
                compositePackageDescr = packageDescr instanceof CompositePackageDescr ? (CompositePackageDescr)packageDescr : new CompositePackageDescr(resource, packageDescr);
                packages.put(packageDescr.getNamespace(), compositePackageDescr);
            } else {
                compositePackageDescr.addPackageDescr(resource, packageDescr);
            }
            compositePackageDescr.addFilter(resourceDescr.getFilter());
        }
    }

    private static interface ResourceToPkgDescrMapper {
        public PackageDescr map(KnowledgeBuilderImpl var1, ResourceDescr var2) throws Exception;
    }

    private static class ResourceDescr {
        final Resource resource;
        final ResourceConfiguration configuration;
        final ResourceChangeSet changes;
        final Map<String, ResourceChange> changeMap;
        final ChangeType globalChangeType;

        private ResourceDescr(ResourceConfiguration configuration, Resource resource, ResourceChangeSet changes) {
            this.configuration = configuration;
            this.resource = resource;
            this.changes = changes;
            if (changes != null) {
                this.changeMap = new HashMap<String, ResourceChange>();
                if (!changes.getChanges().isEmpty()) {
                    for (ResourceChange c : changes.getChanges()) {
                        this.changeMap.put(this.assetId(c.getType(), c.getName()), c);
                    }
                    this.globalChangeType = null;
                } else {
                    this.globalChangeType = changes.getChangeType();
                }
            } else {
                this.changeMap = null;
                this.globalChangeType = null;
            }
        }

        public KnowledgeBuilderImpl.AssetFilter getFilter() {
            return this.changeMap == null ? null : new ChangeSetAssetFilter();
        }

        private String assetId(ResourceChange.Type type, String assetName) {
            return type + "_" + assetName;
        }

        private class ChangeSetAssetFilter
        implements KnowledgeBuilderImpl.AssetFilter {
            private ChangeSetAssetFilter() {
            }

            @Override
            public KnowledgeBuilderImpl.AssetFilter.Action accept(ResourceChange.Type type, String pkgName, String assetName) {
                if (ResourceDescr.this.globalChangeType != null) {
                    return this.toFilterAction(ResourceDescr.this.globalChangeType);
                }
                ResourceChange change = ResourceDescr.this.changeMap.get(ResourceDescr.this.assetId(type, assetName));
                return change != null ? this.toFilterAction(change.getChangeType()) : KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
            }

            private KnowledgeBuilderImpl.AssetFilter.Action toFilterAction(ChangeType changeType) {
                switch (changeType) {
                    case ADDED: {
                        return KnowledgeBuilderImpl.AssetFilter.Action.ADD;
                    }
                    case REMOVED: {
                        return KnowledgeBuilderImpl.AssetFilter.Action.REMOVE;
                    }
                    case UPDATED: {
                        return KnowledgeBuilderImpl.AssetFilter.Action.UPDATE;
                    }
                }
                return KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
            }
        }
    }

    private static interface ResourceBuilder {
        public void build(KnowledgeBuilderImpl var1, ResourceDescr var2) throws Exception;
    }
}

