/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentOutputStream;
import org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.TempFile;

@Internal
public abstract class ChunkedCipherOutputStream
extends FilterOutputStream {
    private static final POILogger logger = POILogFactory.getLogger(ChunkedCipherOutputStream.class);
    protected final int chunkSize;
    protected final int chunkMask;
    protected final int chunkBits;
    private final byte[] _chunk;
    private final File fileOut;
    private final DirectoryNode dir;
    private long _pos = 0L;
    private Cipher _cipher;

    public ChunkedCipherOutputStream(DirectoryNode dir, int chunkSize) throws IOException, GeneralSecurityException {
        super(null);
        this.chunkSize = chunkSize;
        this.chunkMask = chunkSize - 1;
        this.chunkBits = Integer.bitCount(this.chunkMask);
        this._chunk = new byte[chunkSize];
        this.fileOut = TempFile.createTempFile("encrypted_package", "crypt");
        this.fileOut.deleteOnExit();
        this.out = new FileOutputStream(this.fileOut);
        this.dir = dir;
        this._cipher = this.initCipherForBlock(null, 0, false);
    }

    protected abstract Cipher initCipherForBlock(Cipher var1, int var2, boolean var3) throws GeneralSecurityException;

    protected abstract void calculateChecksum(File var1, int var2) throws GeneralSecurityException, IOException;

    protected abstract void createEncryptionInfoEntry(DirectoryNode var1, File var2) throws IOException, GeneralSecurityException;

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (len < 0 || b.length < off + len) {
            throw new IOException("not enough bytes in your input buffer");
        }
        while (len > 0) {
            int posInChunk = (int)(this._pos & (long)this.chunkMask);
            int nextLen = Math.min(this.chunkSize - posInChunk, len);
            System.arraycopy(b, off, this._chunk, posInChunk, nextLen);
            this._pos += (long)nextLen;
            off += nextLen;
            len -= nextLen;
            if ((this._pos & (long)this.chunkMask) != 0L) continue;
            try {
                this.writeChunk();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
    }

    protected void writeChunk() throws IOException, GeneralSecurityException {
        boolean lastChunk;
        int posInChunk = (int)(this._pos & (long)this.chunkMask);
        int index = (int)(this._pos >> this.chunkBits);
        if (posInChunk == 0) {
            --index;
            posInChunk = this.chunkSize;
            lastChunk = false;
        } else {
            lastChunk = true;
        }
        this._cipher = this.initCipherForBlock(this._cipher, index, lastChunk);
        int ciLen = this._cipher.doFinal(this._chunk, 0, posInChunk, this._chunk);
        this.out.write(this._chunk, 0, ciLen);
    }

    @Override
    public void close() throws IOException {
        try {
            this.writeChunk();
            super.close();
            int oleStreamSize = (int)(this.fileOut.length() + 8L);
            this.calculateChecksum(this.fileOut, (int)this._pos);
            this.dir.createDocument("EncryptedPackage", oleStreamSize, new EncryptedPackageWriter());
            this.createEncryptionInfoEntry(this.dir, this.fileOut);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    private class EncryptedPackageWriter
    implements POIFSWriterListener {
        private EncryptedPackageWriter() {
        }

        @Override
        public void processPOIFSWriterEvent(POIFSWriterEvent event) {
            try {
                int readBytes;
                DocumentOutputStream os = event.getStream();
                byte[] buf = new byte[ChunkedCipherOutputStream.this.chunkSize];
                LittleEndian.putLong(buf, 0, ChunkedCipherOutputStream.this._pos);
                ((OutputStream)os).write(buf, 0, 8);
                FileInputStream fis = new FileInputStream(ChunkedCipherOutputStream.this.fileOut);
                while ((readBytes = fis.read(buf)) != -1) {
                    ((OutputStream)os).write(buf, 0, readBytes);
                }
                fis.close();
                ((OutputStream)os).close();
                if (!ChunkedCipherOutputStream.this.fileOut.delete()) {
                    logger.log(7, new Object[]{"Can't delete temporary encryption file: " + ChunkedCipherOutputStream.this.fileOut});
                }
            }
            catch (IOException e) {
                throw new EncryptedDocumentException(e);
            }
        }
    }
}

