/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder;

import java.util.Collection;
import org.drools.compiler.builder.ResourceProcessor;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.assembler.ProcessedResource;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.AssemblerContext;
import org.kie.internal.builder.KnowledgeBuilderError;

public abstract class AbstractAssemblerService<T extends ResourceTypePackage<U>, U extends ProcessedResource>
implements KieAssemblerService {
    protected abstract T createPackage(String var1);

    protected abstract ResourceProcessor<U> createResourceProcessor(Resource var1);

    public final void addResource(Object kbuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        AssemblerContext kb = (AssemblerContext)kbuilder;
        ResourceProcessor<U> processor = this.createResourceProcessor(resource);
        processor.process();
        Collection<KnowledgeBuilderError> errors = processor.getErrors();
        if (errors.isEmpty()) {
            U compiledResource = processor.getProcessedResource();
            kb.computeIfAbsent(this.getResourceType(), compiledResource.getNamespace(), resourceType -> this.createPackage(compiledResource.getNamespace())).add(compiledResource);
        } else {
            errors.forEach(arg_0 -> ((AssemblerContext)kb).reportError(arg_0));
        }
    }
}

