/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.MvelAccumulator;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.kie.internal.security.KiePolicyHelper;

public class MultiAccumulate
extends Accumulate {
    private Accumulator[] accumulators;

    public MultiAccumulate() {
    }

    public MultiAccumulate(RuleConditionElement source, Declaration[] requiredDeclarations, Accumulator[] accumulators) {
        super(source, requiredDeclarations);
        this.accumulators = accumulators;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.accumulators = new Accumulator[in.readInt()];
        for (int i = 0; i < this.accumulators.length; ++i) {
            this.accumulators[i] = (Accumulator)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.accumulators.length);
        for (Accumulator acc : this.accumulators) {
            if (Accumulator.isCompiledInvoker(acc)) {
                out.writeObject(null);
                continue;
            }
            out.writeObject(acc);
        }
    }

    @Override
    public boolean isMultiFunction() {
        return true;
    }

    @Override
    public Accumulator[] getAccumulators() {
        return this.accumulators;
    }

    public Serializable[] createContext() {
        Serializable[] ctxs = new Serializable[this.accumulators.length];
        for (int i = 0; i < ctxs.length; ++i) {
            ctxs[i] = this.accumulators[i].createContext();
        }
        return ctxs;
    }

    @Override
    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, WorkingMemory workingMemory) {
        try {
            for (int i = 0; i < this.accumulators.length; ++i) {
                this.accumulators[i].init(((Object[])workingMemoryContext)[i], ((Object[])context)[i], leftTuple, this.requiredDeclarations, workingMemory);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, WorkingMemory workingMemory) {
        try {
            for (int i = 0; i < this.accumulators.length; ++i) {
                this.accumulators[i].accumulate(((Object[])workingMemoryContext)[i], ((Object[])context)[i], leftTuple, handle, this.requiredDeclarations, this.getInnerDeclarationCache(), workingMemory);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, WorkingMemory workingMemory) {
        try {
            for (int i = 0; i < this.accumulators.length; ++i) {
                this.accumulators[i].reverse(((Object[])workingMemoryContext)[i], ((Object[])context)[i], leftTuple, handle, this.requiredDeclarations, this.getInnerDeclarationCache(), workingMemory);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean supportsReverse() {
        boolean supports = true;
        for (Accumulator acc : this.accumulators) {
            if (acc.supportsReverse()) continue;
            supports = false;
            break;
        }
        return supports;
    }

    public Object[] getResult(Object workingMemoryContext, Object context, Tuple leftTuple, WorkingMemory workingMemory) {
        try {
            Object[] results = new Object[this.accumulators.length];
            for (int i = 0; i < this.accumulators.length; ++i) {
                results[i] = this.accumulators[i].getResult(((Object[])workingMemoryContext)[i], ((Object[])context)[i], leftTuple, this.requiredDeclarations, workingMemory);
            }
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void replaceAccumulatorDeclaration(Declaration declaration, Declaration resolved) {
        for (Accumulator accumulator : this.accumulators) {
            if (!(accumulator instanceof MvelAccumulator)) continue;
            ((MvelAccumulator)accumulator).replaceDeclaration(declaration, resolved);
        }
    }

    @Override
    public MultiAccumulate clone() {
        RuleConditionElement clonedSource = this.source instanceof GroupElement ? ((GroupElement)this.source).cloneOnlyGroup() : this.source.clone();
        MultiAccumulate clone = new MultiAccumulate(clonedSource, this.requiredDeclarations, this.accumulators);
        this.registerClone(clone);
        return clone;
    }

    public Object[] createWorkingMemoryContext() {
        Object[] ctx = new Object[this.accumulators.length];
        for (int i = 0; i < this.accumulators.length; ++i) {
            ctx[i] = this.accumulators[i].createWorkingMemoryContext();
        }
        return ctx;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.accumulators);
        result = 31 * result + Arrays.hashCode(this.requiredDeclarations);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiAccumulate other = (MultiAccumulate)obj;
        if (!Arrays.equals(this.accumulators, other.accumulators)) {
            return false;
        }
        if (!Arrays.equals(this.requiredDeclarations, other.requiredDeclarations)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public final class Wirer
    implements Wireable.Immutable,
    Serializable {
        private static final long serialVersionUID = -9072646735174734614L;
        private transient boolean initialized;
        private final int index;

        public Wirer(int index) {
            this.index = index;
        }

        @Override
        public void wire(Object object) {
            Accumulator accumulator = KiePolicyHelper.isPolicyEnabled() ? new Accumulator.SafeAccumulator((Accumulator)object) : (Accumulator)object;
            ((MultiAccumulate)MultiAccumulate.this).accumulators[this.index] = accumulator;
            for (Accumulate clone : MultiAccumulate.this.cloned) {
                ((MultiAccumulate)((MultiAccumulate)clone)).accumulators[this.index] = accumulator;
            }
            this.initialized = true;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }
    }
}

