/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.Arrays;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.PotentialMultiplier;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;

public class BayesLikelyhood {
    private BayesVariable variable;
    private double[] distribution;
    private double[][] varPotential;
    private BayesVariable[] vars;
    private int[] multipliers;
    private int[] parentVarPos;
    private int[] parentIndexMultipliers;
    private int varPos;

    public BayesLikelyhood(Graph graph, JunctionTreeClique jtNode, GraphNode<BayesVariable> varNode, double[] distribution) {
        int i;
        this.vars = jtNode.getValues().toArray(new BayesVariable[jtNode.getValues().size()]);
        this.variable = varNode.getContent();
        this.distribution = distribution;
        BayesVariable[] parents = new BayesVariable[varNode.getInEdges().size()];
        for (i = 0; i < parents.length; ++i) {
            parents[i] = (BayesVariable)varNode.getInEdges().get(i).getOutGraphNode().getContent();
        }
        this.varPotential = new double[this.variable.getProbabilityTable().length][];
        for (i = 0; i < this.varPotential.length; ++i) {
            this.varPotential[i] = distribution;
        }
        BayesVariable[] vars = jtNode.getValues().toArray(new BayesVariable[jtNode.getValues().size()]);
        int numberOfStates = PotentialMultiplier.createNumberOfStates(vars);
        this.multipliers = PotentialMultiplier.createIndexMultipliers(vars, numberOfStates);
        this.parentVarPos = PotentialMultiplier.createSubsetVarPos(vars, parents);
        int parentsNumberOfStates = PotentialMultiplier.createNumberOfStates(parents);
        this.parentIndexMultipliers = PotentialMultiplier.createIndexMultipliers(parents, parentsNumberOfStates);
        this.varPos = -1;
        for (int i2 = 0; i2 < vars.length; ++i2) {
            if (vars[i2] != this.variable) continue;
            this.varPos = i2;
            break;
        }
        if (this.varPos == -1 || this.varPos == vars.length) {
            throw new IllegalStateException("Unable to find Variable in set");
        }
    }

    public BayesVariable getVariable() {
        return this.variable;
    }

    public double[] getDistribution() {
        return this.distribution;
    }

    public void multiplyInto(double[] trgPotential) {
        PotentialMultiplier m = new PotentialMultiplier(this.varPotential, this.varPos, this.parentVarPos, this.parentIndexMultipliers, this.vars, this.multipliers, trgPotential);
        m.multiple();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BayesLikelyhood that = (BayesLikelyhood)o;
        if (!Arrays.equals(this.distribution, that.distribution)) {
            return false;
        }
        return this.variable.equals(that.variable);
    }

    public int hashCode() {
        int result = this.variable.hashCode();
        result = 31 * result + Arrays.hashCode(this.distribution);
        return result;
    }
}

