/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Tuple;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.kie.api.runtime.rule.FactHandle;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.WithNode;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.CompiledAccExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.integration.Interceptor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessor;
import org.mvel2.optimizers.impl.refl.nodes.MethodAccessor;
import org.mvel2.optimizers.impl.refl.nodes.SetterAccessor;

public class ModifyInterceptor
implements Interceptor,
Externalizable {
    private static final long serialVersionUID = 510L;
    private BitMask modificationMask = AllSetBitMask.get();
    private Boolean isEqualityMode;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.modificationMask = (BitMask)in.readObject();
        this.isEqualityMode = (Boolean)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.modificationMask);
        out.writeObject(this.isEqualityMode);
    }

    public int doBefore(ASTNode node, VariableResolverFactory factory) {
        return 0;
    }

    public int doAfter(Object value, ASTNode node, VariableResolverFactory factory) {
        while (factory != null && !(factory instanceof MVELCompilationUnit.DroolsVarFactory)) {
            factory = factory.getNextFactory();
        }
        if (factory == null) {
            throw new RuntimeException("Unable to find DroolsMVELIndexedFactory");
        }
        KnowledgeHelper knowledgeHelper = ((MVELCompilationUnit.DroolsVarFactory)factory).getKnowledgeHelper();
        if (this.isEqualityMode == null) {
            this.isEqualityMode = knowledgeHelper.getWorkingMemory().getKnowledgeBase().getConfiguration().getAssertBehaviour() == RuleBaseConfiguration.AssertBehaviour.EQUALITY;
        }
        if (this.modificationMask.isSet(0)) {
            this.calculateModificationMask(knowledgeHelper, (WithNode)node);
        }
        if (this.isEqualityMode.booleanValue()) {
            Tuple tuple = knowledgeHelper.getTuple();
            InternalFactHandle modifiedFh = tuple.getFactHandle();
            while (modifiedFh == null || modifiedFh.getObject() != value) {
                tuple = tuple.getParent();
                modifiedFh = tuple.getFactHandle();
            }
            knowledgeHelper.update((FactHandle)modifiedFh, this.modificationMask, value.getClass());
        } else {
            knowledgeHelper.update(value, this.modificationMask, value.getClass());
        }
        return 0;
    }

    private void calculateModificationMask(KnowledgeHelper knowledgeHelper, WithNode node) {
        WithNode.ParmValuePair[] parmValuePairs;
        Class nodeClass = node.getEgressType();
        TypeDeclaration typeDeclaration = knowledgeHelper.getWorkingMemory().getKnowledgeBase().getTypeDeclaration(nodeClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertyReactive()) {
            this.modificationMask = PropertySpecificUtil.allSetButTraitBitMask();
            return;
        }
        List settableProperties = typeDeclaration.getAccessibleProperties();
        this.modificationMask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
        for (WithNode.ParmValuePair parmValuePair : parmValuePairs = (WithNode.ParmValuePair[])this.getFieldValue(WithNode.class, "withExpressions", node)) {
            List modifiedProps;
            int index;
            Method method = this.extractMethod(parmValuePair);
            if (method == null) {
                this.modificationMask = PropertySpecificUtil.allSetButTraitBitMask();
                return;
            }
            String propertyName = ClassUtils.setter2property((String)method.getName());
            if (propertyName == null) {
                propertyName = ClassUtils.getter2property((String)method.getName());
            }
            if (propertyName != null && (index = settableProperties.indexOf(propertyName)) >= 0) {
                this.modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)this.modificationMask, (int)index);
            }
            if ((modifiedProps = typeDeclaration.getTypeClassDef().getModifiedPropsByMethod(method)) == null) continue;
            for (String modifiedProp : modifiedProps) {
                int index2 = settableProperties.indexOf(modifiedProp);
                if (index2 < 0) continue;
                this.modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)this.modificationMask, (int)index2);
            }
        }
    }

    private Method extractMethod(WithNode.ParmValuePair parmValuePair) {
        Serializable setExpression = parmValuePair.getSetExpression();
        if (setExpression != null) {
            SetterAccessor setterAccessor = (SetterAccessor)((CompiledAccExpression)setExpression).getAccessor();
            return setterAccessor.getMethod();
        }
        ExecutableAccessor accessor = (ExecutableAccessor)parmValuePair.getStatement();
        AccessorNode accessorNode = ((AccessorNode)accessor.getNode().getAccessor()).getNextNode();
        if (accessorNode instanceof MethodAccessor) {
            return ((MethodAccessor)accessorNode).getMethod();
        }
        if (accessorNode instanceof GetterAccessor) {
            return ((GetterAccessor)accessorNode).getMethod();
        }
        return null;
    }

    private <T, V> V getFieldValue(Class<T> clazz, String fieldName, T object) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return (V)f.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

