/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class NumericMinAccumulateFunction
extends AbstractAccumulateFunction<MinData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public MinData createContext() {
        return new MinData();
    }

    public void init(MinData data) {
        data.min = null;
    }

    public void accumulate(MinData data, Object value) {
        if (value != null) {
            Number number = (Number)value;
            data.min = data.min == null || data.min.doubleValue() > number.doubleValue() ? (Number)number : (Number)data.min;
        }
    }

    public boolean tryReverse(MinData data, Object value) throws Exception {
        if (value != null) {
            Number number = (Number)value;
            return data.min.doubleValue() < number.doubleValue();
        }
        return true;
    }

    public void reverse(MinData data, Object value) {
    }

    public Object getResult(MinData data) {
        return data.min;
    }

    public boolean supportsReverse() {
        return false;
    }

    public Class<?> getResultType() {
        return Number.class;
    }

    protected static class MinData
    implements Externalizable {
        public Number min = null;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.min = (Double)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.min);
        }

        public String toString() {
            return "min";
        }
    }
}

