/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class GamePanel
extends JPanel {
    private BufferedImage backbuffer;
    private Graphics2D g2d;
    private String name;
    private Color color;
    private long time;
    private int frameCount;

    public GamePanel(String name, Color color) {
        this.name = name;
        this.color = color;
    }

    public BufferedImage getBufferedImage() {
        if (this.backbuffer == null) {
            this.backbuffer = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics2D g = this.getGraphics2D();
            g.setColor(this.color);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.disposeGraphics2D();
        }
        return this.backbuffer;
    }

    public Graphics2D getGraphics2D() {
        if (this.g2d == null) {
            this.g2d = (Graphics2D)this.backbuffer.getGraphics();
        }
        return this.g2d;
    }

    public void disposeGraphics2D() {
        if (this.g2d != null) {
            this.g2d.dispose();
            this.g2d = null;
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.time >= 10000L || this.time == 0L) {
            System.out.println("fps(" + this.name + ") :" + this.frameCount / 10);
            this.frameCount = 0;
            this.time = currentTime;
        }
        ++this.frameCount;
        g.drawImage(this.backbuffer, 0, 0, this);
        Toolkit.getDefaultToolkit().sync();
    }
}

