/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.drools.reflective.util.ClassUtils;
import org.drools.ruleunit.RuleUnit;
import org.kie.internal.ruleunit.RuleUnitVariable;

public final class ReflectiveRuleUnitVariable
implements RuleUnitVariable {
    private final String name;
    private final Class<?> type;
    private final Class<?> dataSourceParameterType;
    private final Class<?> boxedVarType;
    private final String getter;
    private final String setter;
    private final Method getterMethod;

    public ReflectiveRuleUnitVariable(String name, Method getterMethod) {
        Objects.requireNonNull(name, "Invalid name was given: null");
        if (!RuleUnit.class.isAssignableFrom(getterMethod.getDeclaringClass())) {
            throw new IllegalArgumentException(String.format("The given method '%s' is not from a RuleUnit instance", getterMethod));
        }
        if (getterMethod.getParameterCount() != 0) {
            throw new IllegalArgumentException(String.format("The given method '%s' is not from a RuleUnit instance", getterMethod));
        }
        if (getterMethod.getName().equals("getClass")) {
            throw new IllegalArgumentException("'getClass' is not a valid method for a rule unit variable");
        }
        String id = ClassUtils.getter2property((String)getterMethod.getName());
        if (id == null) {
            throw new IllegalArgumentException(String.format("Could not parse getter name for method '%s'", getterMethod));
        }
        this.name = name;
        this.getter = getterMethod.getName();
        this.getterMethod = getterMethod;
        this.setter = "set" + ClassUtils.ucFirst((String)name);
        this.type = getterMethod.getReturnType();
        this.dataSourceParameterType = this.getUnitVarType(getterMethod);
        this.boxedVarType = ClassUtils.convertFromPrimitiveType(this.type);
    }

    private Class<?> getUnitVarType(Method m) {
        Class<?> returnClass = m.getReturnType();
        if (returnClass.isArray()) {
            return returnClass.getComponentType();
        }
        if (Iterable.class.isAssignableFrom(returnClass)) {
            Type returnType = m.getGenericReturnType();
            Class sourceType = returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getActualTypeArguments()[0] : Object.class;
            return sourceType;
        }
        return returnClass;
    }

    public boolean isDataSource() {
        return this.dataSourceParameterType != null;
    }

    public String getName() {
        return this.name;
    }

    public String getter() {
        return this.getter;
    }

    public String setter() {
        return this.setter;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getDataSourceParameterType() {
        return this.dataSourceParameterType;
    }

    public Class<?> getBoxedVarType() {
        return this.boxedVarType;
    }

    public Object getValue(RuleUnit ruleUnit) {
        try {
            return this.getterMethod.invoke((Object)ruleUnit, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "ReflectiveRuleUnitVariable{name='" + this.name + '\'' + ", type=" + this.type + ", dataSourceParameterType=" + this.dataSourceParameterType + '}';
    }
}

