/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.EvalExpression;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.kie.internal.security.KiePolicyHelper;

public class EvalCondition
extends ConditionalElement
implements Externalizable,
Wireable {
    private static final long serialVersionUID = 510L;
    protected EvalExpression expression;
    protected Declaration[] requiredDeclarations;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];
    private List<EvalCondition> cloned = Collections.emptyList();
    private Map<String, Declaration> outerDeclarations = Collections.EMPTY_MAP;

    public EvalCondition() {
        this(null);
    }

    public EvalCondition(Declaration[] requiredDeclarations) {
        this(null, requiredDeclarations);
    }

    public EvalCondition(EvalExpression eval, Declaration[] requiredDeclarations) {
        this.expression = eval;
        this.requiredDeclarations = requiredDeclarations == null ? EMPTY_DECLARATIONS : requiredDeclarations;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = (EvalExpression)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.cloned = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (EvalExpression.isCompiledInvoker(this.expression)) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.cloned);
    }

    public EvalExpression getEvalExpression() {
        return this.expression;
    }

    @Override
    public void wire(Object object) {
        EvalExpression expression = KiePolicyHelper.isPolicyEnabled() ? new EvalExpression.SafeEvalExpression((EvalExpression)object) : (EvalExpression)object;
        this.setEvalExpression(expression);
        for (EvalCondition clone : this.cloned) {
            clone.wireClone(expression);
        }
    }

    private void wireClone(EvalExpression expression) {
        this.setEvalExpression(expression.clonePreservingDeclarations(this.expression));
        for (EvalCondition clone : this.cloned) {
            clone.wireClone(expression);
        }
    }

    public void setEvalExpression(EvalExpression expression) {
        this.expression = expression;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Object createContext() {
        return this.expression.createContext();
    }

    public boolean isAllowed(Tuple tuple, WorkingMemory workingMemory, Object context) {
        try {
            return this.expression.evaluate(tuple, this.requiredDeclarations, workingMemory, context);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getEvalExpression() + " : " + e, e);
        }
    }

    @Override
    public EvalCondition clone() {
        EvalCondition clone = new EvalCondition(this.expression.clone(), (Declaration[])this.requiredDeclarations.clone());
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<EvalCondition>(1);
        }
        this.cloned.add(clone);
        return clone;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        EvalCondition other = (EvalCondition)object;
        if (this.requiredDeclarations.length != other.requiredDeclarations.length) {
            return false;
        }
        int length = this.requiredDeclarations.length;
        for (int i = 0; i < length; ++i) {
            if (this.requiredDeclarations[i].getOffset() != other.requiredDeclarations[i].getOffset()) {
                return false;
            }
            if (this.requiredDeclarations[i].getExtractor().equals(other.requiredDeclarations[i].getExtractor())) continue;
            return false;
        }
        return this.expression.equals(other.expression);
    }

    @Override
    public Map<String, Declaration> getInnerDeclarations() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Map<String, Declaration> getOuterDeclarations() {
        return this.outerDeclarations;
    }

    public void setOuterDeclarations(Map<String, Declaration> outerDeclarations) {
        this.outerDeclarations = outerDeclarations;
    }

    @Override
    public List<? extends RuleConditionElement> getNestedElements() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return null;
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        this.expression.replaceDeclaration(declaration, resolved);
        for (int i = 0; i < this.requiredDeclarations.length; ++i) {
            if (!this.requiredDeclarations[i].equals(declaration)) continue;
            this.requiredDeclarations[i] = resolved;
        }
    }

    public List<EvalCondition> getCloned() {
        return this.cloned;
    }

    public void setCloned(List<EvalCondition> cloned) {
        this.cloned = cloned;
    }

    public String toString() {
        return this.expression.toString();
    }
}

