/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.expr;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.mvel.MVELSafeHelper;
import org.drools.mvel.expr.MVELDebugHandler;
import org.mvel2.MVEL;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvelEvaluator<T> {
    private static final boolean THREAD_SAFE = true;
    private static final Logger logger = LoggerFactory.getLogger(MvelEvaluator.class);
    private final Serializable expr;

    private MvelEvaluator(Serializable expr) {
        this.expr = expr;
    }

    public static <T> MvelEvaluator<T> createMvelEvaluator(Serializable expr) {
        return new ThreadSafe(expr);
    }

    public T evaluate(Object ctx) {
        return this.evaluate(ctx, null);
    }

    public T evaluate(VariableResolverFactory factory) {
        return this.evaluate(null, factory);
    }

    public T evaluate(Object ctx, VariableResolverFactory factory) {
        return this.internalEvaluate(ctx, factory);
    }

    private <T> T internalEvaluate(Object ctx, VariableResolverFactory factory) {
        if (MVELDebugHandler.isDebugMode() && this.expr instanceof CompiledExpression) {
            CompiledExpression compexpr = (CompiledExpression)this.expr;
            return (T)MVEL.executeDebugger((CompiledExpression)compexpr, (Object)ctx, (VariableResolverFactory)factory);
        }
        return (T)MVELSafeHelper.getEvaluator().executeExpression((Object)this.expr, ctx, factory);
    }

    public Serializable getExpr() {
        return this.expr;
    }

    private static class ThreadSafe<T>
    extends MvelEvaluator<T> {
        private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

        public ThreadSafe(Serializable expr) {
            super(expr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T evaluate(Object ctx, VariableResolverFactory factory) {
            if (this.state.get() != State.INITIALIZED) {
                if (this.state.compareAndSet(State.NEW, State.INITIALIZING)) {
                    Object result = super.evaluate(ctx, factory);
                    AtomicReference<State> atomicReference = this.state;
                    synchronized (atomicReference) {
                        boolean shouldNotify = this.state.get() == State.CONTENTED;
                        this.state.set(State.INITIALIZED);
                        if (shouldNotify) {
                            this.state.notifyAll();
                        }
                    }
                    return result;
                }
                AtomicReference<State> atomicReference = this.state;
                synchronized (atomicReference) {
                    if (this.state.get() != State.INITIALIZED) {
                        try {
                            this.state.set(State.CONTENTED);
                            this.state.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return super.evaluate(ctx, factory);
        }

        private static enum State {
            NEW,
            INITIALIZING,
            CONTENTED,
            INITIALIZED;

        }
    }
}

