/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelReader;
import org.appformer.maven.integration.ArtifactResolver;
import org.appformer.maven.integration.DependencyDescriptor;
import org.appformer.maven.integration.PomParser;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.appformer.maven.support.DependencyFilter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InJarArtifactResolver
extends ArtifactResolver {
    private static final Logger log = LoggerFactory.getLogger(InJarArtifactResolver.class);
    private ClassLoader classLoader;
    private List<URL> jarRepository;
    private List<URL> effectivePoms;
    private PomParser pomParser;

    InJarArtifactResolver(ClassLoader classLoader, AFReleaseId releaseId) {
        this.classLoader = classLoader;
        this.jarRepository = new ArrayList<URL>();
        this.effectivePoms = new ArrayList<URL>();
        this.init(releaseId);
    }

    public boolean isLoaded() {
        return this.pomParser != null;
    }

    private void init(AFReleaseId releaseId) {
        this.jarRepository = this.buildResources(name -> this.isInJarFolder((String)name, "jar"));
        this.effectivePoms = this.buildResources(name -> this.isInJarFolder((String)name, "pom"));
        this.pomParser = this.buildPomParser(releaseId);
    }

    private List<URL> buildResources(Predicate<String> predicate) {
        URL resourceURL = this.classLoader.getResource("");
        if (resourceURL == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> resources = new ArrayList<URL>();
        try (InputStream is = resourceURL.openStream();
             ZipInputStream stream = new ZipInputStream(is);){
            ZipEntry entry = null;
            while ((entry = stream.getNextEntry()) != null) {
                if (!predicate.test(entry.getName())) continue;
                resources.add(this.classLoader.getResource(entry.getName()));
            }
            log.debug("Found in jar repository {}", resources);
        }
        catch (IOException e) {
            log.error("Error trying to open URL: {}", (Object)resourceURL);
        }
        return resources;
    }

    private boolean isInJarFolder(String name, String type) {
        String[] paths;
        for (String path : paths = new String[]{"BOOT-INF/classes/KIE-INF/", "KIE-INF/lib/"}) {
            if (!name.startsWith(path) || !name.endsWith("." + type)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PomParser buildPomParser(AFReleaseId releaseId) {
        List url = this.effectivePoms.stream().filter(e -> e.getFile().endsWith(this.toFile(releaseId, "pom"))).collect(Collectors.toList());
        if (url.isEmpty()) {
            return null;
        }
        String path = ((URL)url.get(0)).toExternalForm();
        URL pomFile = this.classLoader.getResource(path);
        if (pomFile == null) {
            log.warn("Maven pom not found in path {}", (Object)path);
            return null;
        }
        try (InputStream pomStream = pomFile.openStream();){
            DefaultModelReader reader = new DefaultModelReader();
            final Model model = reader.read(pomStream, Collections.emptyMap());
            PomParser pomParser = new PomParser(){

                @Override
                public List<DependencyDescriptor> getPomDirectDependencies(DependencyFilter filter) {
                    ArrayList<DependencyDescriptor> deps = new ArrayList<DependencyDescriptor>();
                    for (Dependency dep : model.getDependencies()) {
                        DependencyDescriptor depDescr = new DependencyDescriptor(dep);
                        if (!depDescr.isValid() || !filter.accept(depDescr.getReleaseId(), depDescr.getScope())) continue;
                        deps.add(depDescr);
                    }
                    return deps;
                }
            };
            return pomParser;
        }
        catch (Exception e2) {
            log.error("Could not read pom in jar {}", (Object)pomFile);
            return null;
        }
    }

    @Override
    public ArtifactResolver.ArtifactLocation resolveArtifactLocation(AFReleaseId releaseId) {
        log.debug("resolve location {}", (Object)releaseId);
        Optional<URL> url = this.tryInJar(releaseId);
        if (url.isPresent()) {
            DefaultArtifact artifact = new DefaultArtifact(releaseId.toExternalForm());
            return new ArtifactResolver.ArtifactLocation(artifact.setFile(new File(url.get().toString())), url.get(), true);
        }
        return null;
    }

    @Override
    public Artifact resolveArtifact(AFReleaseId releaseId) {
        Optional<URL> url = this.tryInJar(releaseId);
        if (url.isPresent()) {
            log.info("Resolved in jar repository {}", url);
            DefaultArtifact artifact = new DefaultArtifact(releaseId.toExternalForm());
            return artifact.setFile(new File(url.get().toString()));
        }
        return null;
    }

    private Optional<URL> tryInJar(String artifactName) {
        for (URL inJarURL : this.jarRepository) {
            if (!inJarURL.getFile().endsWith(artifactName)) continue;
            return Optional.of(inJarURL);
        }
        return Optional.empty();
    }

    private Optional<URL> tryInJar(AFReleaseId releaseId) {
        return this.tryInJar(this.toFile(releaseId, "jar"));
    }

    private String toFile(AFReleaseId releaseId, String type) {
        return releaseId.getArtifactId() + "-" + releaseId.getVersion() + "." + type;
    }

    @Override
    public List<DependencyDescriptor> getArtifactDependecies(String artifactName) {
        AFReleaseIdImpl releaseId = new AFReleaseIdImpl(artifactName);
        PomParser pomParser = this.buildPomParser((AFReleaseId)releaseId);
        return pomParser != null ? pomParser.getPomDirectDependencies(DependencyFilter.COMPILE_FILTER) : Collections.emptyList();
    }

    @Override
    public List<DependencyDescriptor> getPomDirectDependencies(DependencyFilter dependencyFilter) {
        return this.pomParser != null ? this.pomParser.getPomDirectDependencies(dependencyFilter) : Collections.emptyList();
    }
}

