/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.expr;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.mvel.MVELConditionEvaluator;
import org.drools.mvel.MVELSafeHelper;
import org.drools.mvel.expr.MVELDebugHandler;
import org.mvel2.MVEL;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvelEvaluator<T> {
    public static final String THREAD_SAFETY_PROPERTY = "drools.mvel.thread.safety";
    private static final EvaluatorType DEFAULT_EVALUATOR_TYPE = EvaluatorType.THREAD_UNSAFE;
    private static final EvaluatorType EVALUATOR_TYPE = EvaluatorType.decode(System.getProperty("drools.mvel.thread.safety", EvaluatorType.access$000(DEFAULT_EVALUATOR_TYPE)));
    private static final Logger logger = LoggerFactory.getLogger(MvelEvaluator.class);
    protected final Serializable expr;

    private MvelEvaluator(Serializable expr) {
        this.expr = expr;
    }

    public static <T> MvelEvaluator<T> createMvelEvaluator(Serializable expr) {
        return EVALUATOR_TYPE.createMvelEvaluator(expr);
    }

    public static <T> MvelEvaluator<T> createMvelEvaluator(MvelEvaluator<T> syncedWith, Serializable expr) {
        return EVALUATOR_TYPE.createMvelEvaluator(syncedWith, expr);
    }

    public T evaluate(Object ctx) {
        return this.evaluate(ctx, (VariableResolverFactory)null);
    }

    public T evaluate(VariableResolverFactory factory) {
        return this.evaluate(null, factory);
    }

    public T evaluate(Object ctx, VariableResolverFactory factory) {
        return this.internalEvaluate(ctx, factory);
    }

    public T evaluate(Object ctx, Map<String, Object> vars) {
        return (T)MVELSafeHelper.getEvaluator().executeExpression((Object)this.expr, ctx, vars);
    }

    protected <T> T internalEvaluate(Object ctx, VariableResolverFactory factory) {
        if (MVELDebugHandler.isDebugMode() && this.expr instanceof CompiledExpression) {
            CompiledExpression compexpr = (CompiledExpression)this.expr;
            return (T)MVEL.executeDebugger((CompiledExpression)compexpr, (Object)ctx, (VariableResolverFactory)factory);
        }
        return (T)MVELSafeHelper.getEvaluator().executeExpression((Object)this.expr, ctx, factory);
    }

    public Serializable getExpr() {
        return this.expr;
    }

    private static class FullySynchronized<T>
    extends MvelEvaluator<T> {
        private final MvelEvaluator<T> monitor;

        public FullySynchronized(Serializable expr) {
            super(expr);
            this.monitor = this;
        }

        public FullySynchronized(MvelEvaluator<T> monitor, Serializable expr) {
            super(expr);
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T evaluate(Object ctx, VariableResolverFactory factory) {
            MvelEvaluator<T> mvelEvaluator = this.monitor;
            synchronized (mvelEvaluator) {
                return this.internalEvaluate(ctx, factory);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T evaluate(Object ctx, Map<String, Object> vars) {
            MvelEvaluator<T> mvelEvaluator = this.monitor;
            synchronized (mvelEvaluator) {
                return super.evaluate(ctx, vars);
            }
        }
    }

    private static class SynchronizedTillEvaluated<T>
    extends MvelEvaluator<T> {
        private final MvelEvaluator<T> monitor;
        private volatile boolean fullyEvaluated;

        public SynchronizedTillEvaluated(Serializable expr) {
            super(expr);
            this.monitor = this;
        }

        public SynchronizedTillEvaluated(MvelEvaluator<T> monitor, Serializable expr) {
            super(expr);
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T evaluate(Object ctx, VariableResolverFactory factory) {
            if (this.fullyEvaluated) {
                return this.internalEvaluate(ctx, factory);
            }
            MvelEvaluator<T> mvelEvaluator = this.monitor;
            synchronized (mvelEvaluator) {
                Object result = this.internalEvaluate(ctx, factory);
                this.fullyEvaluated = MVELConditionEvaluator.isFullyEvaluated(this.expr);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T evaluate(Object ctx, Map<String, Object> vars) {
            if (this.fullyEvaluated) {
                return super.evaluate(ctx, vars);
            }
            MvelEvaluator<T> mvelEvaluator = this.monitor;
            synchronized (mvelEvaluator) {
                Object result = super.evaluate(ctx, vars);
                this.fullyEvaluated = MVELConditionEvaluator.isFullyEvaluated(this.expr);
                return result;
            }
        }
    }

    private static class ThreadSafe<T>
    extends MvelEvaluator<T> {
        private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

        public ThreadSafe(Serializable expr) {
            super(expr);
        }

        @Override
        public synchronized T evaluate(Object ctx, Map<String, Object> vars) {
            if (this.state.get() != State.INITIALIZED && this.isFirstEvaluation()) {
                Object result = super.evaluate(ctx, vars);
                this.notifyFirstEvaluationDone();
                return result;
            }
            return super.evaluate(ctx, vars);
        }

        @Override
        public T evaluate(Object ctx, VariableResolverFactory factory) {
            if (this.state.get() != State.INITIALIZED && this.isFirstEvaluation()) {
                Object result = this.internalEvaluate(ctx, factory);
                this.notifyFirstEvaluationDone();
                return result;
            }
            return this.internalEvaluate(ctx, factory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyFirstEvaluationDone() {
            AtomicReference<State> atomicReference = this.state;
            synchronized (atomicReference) {
                boolean shouldNotify = this.state.get() == State.CONTENTED;
                this.state.set(State.INITIALIZED);
                if (shouldNotify) {
                    this.state.notifyAll();
                }
            }
        }

        private boolean isFirstEvaluation() {
            if (this.state.compareAndSet(State.NEW, State.INITIALIZING)) {
                return true;
            }
            this.waitForFirstEvaluation();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForFirstEvaluation() {
            AtomicReference<State> atomicReference = this.state;
            synchronized (atomicReference) {
                if (this.state.get() != State.INITIALIZED) {
                    try {
                        this.state.set(State.CONTENTED);
                        this.state.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        private static enum State {
            NEW,
            INITIALIZING,
            CONTENTED,
            INITIALIZED;

        }
    }

    public static enum EvaluatorType {
        THREAD_UNSAFE("unsafe"),
        THREAD_SAFE_ON_FIRST_EVAL("safe_on_first"),
        SYNCHRONIZED_TILL_EVALUATED("synced_till_eval"),
        FULLY_SYNCHRONIZED("fully_synced");

        private final String id;

        private EvaluatorType(String id) {
            this.id = id;
        }

        public <T> MvelEvaluator<T> createMvelEvaluator(Serializable expr) {
            switch (this) {
                case THREAD_UNSAFE: {
                    return new MvelEvaluator(expr);
                }
                case THREAD_SAFE_ON_FIRST_EVAL: {
                    return new ThreadSafe(expr);
                }
                case SYNCHRONIZED_TILL_EVALUATED: {
                    return new SynchronizedTillEvaluated(expr);
                }
                case FULLY_SYNCHRONIZED: {
                    return new FullySynchronized(expr);
                }
            }
            throw new UnsupportedOperationException();
        }

        public <T> MvelEvaluator<T> createMvelEvaluator(MvelEvaluator<T> syncedWith, Serializable expr) {
            switch (this) {
                case THREAD_UNSAFE: {
                    return new MvelEvaluator(expr);
                }
                case THREAD_SAFE_ON_FIRST_EVAL: {
                    return new ThreadSafe(expr);
                }
                case SYNCHRONIZED_TILL_EVALUATED: {
                    return new SynchronizedTillEvaluated<T>(syncedWith, expr);
                }
                case FULLY_SYNCHRONIZED: {
                    return new FullySynchronized<T>(syncedWith, expr);
                }
            }
            throw new UnsupportedOperationException();
        }

        static EvaluatorType decode(String id) {
            for (EvaluatorType evaluatorType : (EvaluatorType[])EvaluatorType.class.getEnumConstants()) {
                if (!evaluatorType.id.equalsIgnoreCase(id)) continue;
                return evaluatorType;
            }
            throw new UnsupportedOperationException("Unknown evaluator type: " + id);
        }

        static /* synthetic */ String access$000(EvaluatorType x0) {
            return x0.id;
        }
    }
}

