/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.shopping;

import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class ShoppingExample {
    public static final void main(String[] args) {
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        System.out.println(kc.verify().getMessages().toString());
        ShoppingExample.execute(kc);
    }

    public static void execute(KieContainer kc) {
        KieSession ksession = kc.newKieSession("ShoppingKS");
        Customer mark = new Customer("mark", 0);
        ksession.insert((Object)mark);
        Product shoes = new Product("shoes", 60.0f);
        ksession.insert((Object)shoes);
        Product hat = new Product("hat", 60.0f);
        ksession.insert((Object)hat);
        ksession.insert((Object)new Purchase(mark, shoes));
        FactHandle hatPurchaseHandle = ksession.insert((Object)new Purchase(mark, hat));
        ksession.fireAllRules();
        ksession.delete(hatPurchaseHandle);
        System.out.println("Customer mark has returned the hat");
        ksession.fireAllRules();
    }

    public static class Purchase {
        private Customer customer;
        private Product product;

        public Purchase(Customer customer, Product product) {
            this.customer = customer;
            this.product = product;
        }

        public Customer getCustomer() {
            return this.customer;
        }

        public Product getProduct() {
            return this.product;
        }
    }

    public static class Product {
        private String name;
        private float price;

        public Product(String name, float price) {
            this.name = name;
            this.price = price;
        }

        public String getName() {
            return this.name;
        }

        public float getPrice() {
            return this.price;
        }
    }

    public static class Discount {
        private Customer customer;
        private int amount;

        public Discount(Customer customer, int amount) {
            this.customer = customer;
            this.amount = amount;
        }

        public Customer getCustomer() {
            return this.customer;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static class Customer {
        private String name;
        private int discount;

        public Customer(String name, int discount) {
            this.name = name;
            this.discount = discount;
        }

        public String getName() {
            return this.name;
        }

        public int getDiscount() {
            return this.discount;
        }

        public void setDiscount(int discount) {
            this.discount = discount;
        }
    }
}

