/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa.marshaller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.persistence.api.TransactionAware;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.jpa.marshaller.EntityPersister;
import org.drools.persistence.jpa.marshaller.MappedVariable;
import org.drools.persistence.jpa.marshaller.VariableEntity;
import org.drools.serialization.protobuf.ProtobufProcessMarshallerWriteContext;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAPlaceholderResolverStrategy
implements ObjectMarshallingStrategy,
TransactionAware,
Cacheable {
    private static Logger log = LoggerFactory.getLogger(JPAPlaceholderResolverStrategy.class);
    private EntityManagerFactory emf;
    private Set<String> managedClasses;
    private ClassLoader classLoader;
    private boolean closeEmf = false;
    private String name = JPAPlaceholderResolverStrategy.class.getName();
    private static final ThreadLocal<EntityPersister> persister = new ThreadLocal();

    public JPAPlaceholderResolverStrategy(Environment env) {
        this((EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
    }

    public JPAPlaceholderResolverStrategy(EntityManagerFactory emf) {
        this.emf = emf;
        this.initializeManagedClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPAPlaceholderResolverStrategy(String persistenceUnit, ClassLoader cl) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            this.emf = Persistence.createEntityManagerFactory((String)persistenceUnit);
            this.initializeManagedClasses();
            this.closeEmf = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        this.classLoader = cl;
    }

    public JPAPlaceholderResolverStrategy(String name, String persistenceUnit, ClassLoader cl) {
        this(persistenceUnit, cl);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void initializeManagedClasses() {
        Metamodel metamodel;
        this.managedClasses = new HashSet<String>();
        if (this.emf != null && (metamodel = this.emf.getMetamodel()) != null) {
            Set entities = metamodel.getEntities();
            for (EntityType entity : entities) {
                this.managedClasses.add(entity.getJavaType().getCanonicalName());
            }
        }
    }

    public boolean accept(Object object) {
        return this.isEntity(object);
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        Serializable id = this.getClassIdValue(object);
        EntityManager em = this.getEntityManager();
        if (id == null) {
            em.persist(object);
            id = this.getClassIdValue(object);
        } else {
            em.merge(object);
        }
        em.flush();
        os.writeUTF(object.getClass().getCanonicalName());
        os.writeObject(id);
    }

    public Object read(ObjectInputStream is) throws IOException, ClassNotFoundException {
        String canonicalName = is.readUTF();
        Object id = is.readObject();
        EntityManager em = this.getEntityManager();
        return em.find(Class.forName(canonicalName), id);
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        Serializable id = this.getClassIdValue(object);
        String entityType = object.getClass().getCanonicalName();
        EntityPersister entityPersister = persister.get();
        if (!entityPersister.isPersited(object)) {
            EntityManager em = this.getEntityManager();
            if (id == null) {
                em.persist(object);
                id = this.getClassIdValue(object);
            }
            this.addMapping(id, entityType, object, os, em);
            em.merge(object);
            entityPersister.processed(object);
            em.flush();
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buff);
        oos.writeUTF(entityType);
        oos.writeObject(id);
        oos.close();
        return buff.toByteArray();
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream ois, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        ClassLoader clToUse = classloader;
        if (this.classLoader != null) {
            clToUse = this.classLoader;
        }
        DroolsObjectInputStream is = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(object), clToUse);
        String canonicalName = is.readUTF();
        Object id = is.readObject();
        EntityManager em = this.getEntityManager();
        return em.find(Class.forName(canonicalName, true, clToUse == null ? this.getClass().getClassLoader() : clToUse), id);
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }

    public Serializable getClassIdValue(Object o) {
        return (Serializable)this.emf.getPersistenceUnitUtil().getIdentifier(o);
    }

    private boolean isEntity(Object o) {
        Class<?> varClass = o.getClass();
        return this.managedClasses.contains(varClass.getCanonicalName());
    }

    public void onStart(TransactionManager txm) {
        if (persister.get() == null) {
            EntityManager em = this.emf.createEntityManager();
            persister.set(new EntityPersister(em));
        }
    }

    public void onEnd(TransactionManager txm) {
        EntityPersister em = persister.get();
        if (txm.getStatus() == 1) {
            List<Object> entities = em.getEntities();
            entities.stream().forEach(entity -> {
                try {
                    Metamodel metamodel = this.emf.getMetamodel();
                    EntityType jpaEntity = metamodel.entity(entity.getClass());
                    String idFieldName = jpaEntity.getId(jpaEntity.getIdType().getJavaType()).getName();
                    Field field = null;
                    for (Class<?> clazz = entity.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                        try {
                            field = clazz.getDeclaredField(idFieldName);
                            break;
                        }
                        catch (Throwable th) {
                            continue;
                        }
                    }
                    if (field != null) {
                        field.setAccessible(true);
                        field.set(entity, null);
                    }
                }
                catch (Exception e) {
                    log.debug("There is a problem trying to rollback id object {}", entity, (Object)e);
                }
            });
        }
        if (em != null) {
            em.close();
            persister.set(null);
        }
    }

    protected EntityManager getEntityManager() {
        EntityPersister em = persister.get();
        if (em != null && em.getEntityManager() != null) {
            return em.getEntityManager();
        }
        return this.emf.createEntityManager();
    }

    public void close() {
        if (this.closeEmf && this.emf != null) {
            this.emf.close();
            this.emf = null;
        }
    }

    protected void addMapping(Object entityId, String entityType, Object entity, ObjectOutputStream context, EntityManager em) {
        if (entityId instanceof Number && entity instanceof VariableEntity && context instanceof ProtobufProcessMarshallerWriteContext) {
            ProtobufProcessMarshallerWriteContext processContext = (ProtobufProcessMarshallerWriteContext)context;
            VariableEntity variableEntity = (VariableEntity)entity;
            MappedVariable mappedVariable = new MappedVariable(((Number)entityId).longValue(), entityType, processContext.getProcessInstanceId(), processContext.getTaskId(), processContext.getWorkItemId());
            if (processContext.getState() == 1) {
                variableEntity.addMappedVariables(mappedVariable);
            } else {
                MappedVariable toBeRemoved = variableEntity.findMappedVariables(mappedVariable);
                if (toBeRemoved != null) {
                    toBeRemoved = (MappedVariable)em.find(MappedVariable.class, (Object)toBeRemoved.getMappedVarId());
                    em.remove((Object)toBeRemoved);
                    variableEntity.removeMappedVariables(toBeRemoved);
                }
            }
        }
    }
}

