/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleIterator;
import org.drools.core.common.PhreakActivationIterator;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TerminalNodeIterator;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Activation;
import org.drools.core.spi.Tuple;
import org.drools.core.util.Iterator;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class ActivationIterator
implements Iterator {
    private InternalWorkingMemory wm;
    private Iterator nodeIter;
    private TerminalNode node;
    private Iterator<LeftTuple> leftTupleIter;
    private Tuple currentTuple;

    ActivationIterator() {
    }

    private ActivationIterator(InternalWorkingMemory wm, KieBase kbase) {
        this.wm = wm;
        this.nodeIter = TerminalNodeIterator.iterator(kbase);
        while (this.currentTuple == null && (this.node = (TerminalNode)this.nodeIter.next()) != null) {
            if (!(this.node instanceof RuleTerminalNode)) continue;
            this.leftTupleIter = LeftTupleIterator.iterator(wm, this.node);
            this.currentTuple = this.leftTupleIter.next();
        }
    }

    public static Iterator iterator(InternalWorkingMemory wm) {
        return PhreakActivationIterator.iterator(wm);
    }

    public static Iterator iterator(KieSession ksession) {
        return ActivationIterator.iterator((WorkingMemoryEntryPoint)ksession);
    }

    public static Iterator iterator(WorkingMemoryEntryPoint ksession) {
        ReteEvaluator reteEvaluator = ksession.getReteEvaluator();
        return PhreakActivationIterator.iterator(reteEvaluator);
    }

    public Object next() {
        Activation acc = null;
        if (this.currentTuple != null) {
            Object obj = this.currentTuple.getContextObject();
            acc = obj == Boolean.TRUE ? null : (Activation)obj;
            this.currentTuple = this.leftTupleIter.next();
            while (this.currentTuple == null && (this.node = (TerminalNode)this.nodeIter.next()) != null) {
                if (!(this.node instanceof RuleTerminalNode)) continue;
                this.leftTupleIter = LeftTupleIterator.iterator(this.wm, this.node);
                this.currentTuple = this.leftTupleIter.next();
            }
        }
        return acc;
    }
}

