/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import com.google.protobuf.ExtensionRegistry;
import java.io.ByteArrayInputStream;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.CompilationCacheProvider;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.util.Drools;
import org.drools.serialization.protobuf.kie.KieModuleCache;
import org.drools.serialization.protobuf.kie.KieModuleCacheHelper;
import org.drools.serialization.protobuf.kie.MarshallingKieMetaInfoBuilder;
import org.kie.api.builder.ReleaseId;
import org.kie.memorycompiler.resources.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilationCacheProviderImpl
implements CompilationCacheProvider {
    private static final Logger log = LoggerFactory.getLogger(CompilationCacheProviderImpl.class);

    public InternalKieModule.CompilationCache getCompilationCache(AbstractKieModule kieModule, Map<String, InternalKieModule.CompilationCache> compilationCache, String kbaseName) {
        byte[] fileContents;
        InternalKieModule.CompilationCache cache = compilationCache.get(kbaseName);
        if (cache == null && (fileContents = kieModule.getBytes(KieBuilderImpl.getCompilationCachePath((ReleaseId)kieModule.getReleaseId(), (String)kbaseName))) != null) {
            ExtensionRegistry registry = KieModuleCacheHelper.buildRegistry();
            try {
                KieModuleCache.Header header = KieModuleCacheHelper.readFromStreamWithHeaderPreloaded(new ByteArrayInputStream(fileContents), registry);
                if (!Drools.isCompatible((int)header.getVersion().getVersionMajor(), (int)header.getVersion().getVersionMinor(), (int)header.getVersion().getVersionRevision())) {
                    log.warn("The compilation cache has been built with an incompatible version. You should recompile your project in order to use it with current release.");
                    return null;
                }
                KieModuleCache.KModuleCache kModuleCache = KieModuleCache.KModuleCache.parseFrom(header.getPayload());
                cache = new InternalKieModule.CompilationCache();
                for (KieModuleCache.CompilationData _data : kModuleCache.getCompilationDataList()) {
                    for (KieModuleCache.CompDataEntry _entry : _data.getEntryList()) {
                        cache.addEntry(_data.getDialect(), _entry.getId(), _entry.getData().toByteArray());
                    }
                }
                compilationCache.put(kbaseName, cache);
            }
            catch (Exception e) {
                log.error("Unable to load compilation cache... ", (Throwable)e);
            }
        }
        return cache;
    }

    public void writeKieModuleMetaInfo(InternalKieModule kModule, ResourceStore trgMfs) {
        new MarshallingKieMetaInfoBuilder(kModule).writeKieModuleMetaInfo(trgMfs);
    }
}

