/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.BehaviorManager;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;

public class WindowNode
extends ObjectSource
implements ObjectSinkNode,
RightTupleSink,
MemoryFactory<WindowMemory> {
    private static final long serialVersionUID = 540L;
    private List<AlphaNodeFieldConstraint> constraints;
    protected BehaviorManager behavior;
    private EntryPointId entryPoint;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private transient ObjectTypeNode.Id rightInputOtnId = ObjectTypeNode.DEFAULT_ID;

    public WindowNode() {
    }

    public WindowNode(int id, List<AlphaNodeFieldConstraint> constraints, List<Behavior> behaviors, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold(), context.getRuleBase().getConfiguration().getAlphaNodeRangeIndexThreshold());
        this.constraints = new ArrayList<AlphaNodeFieldConstraint>(constraints);
        this.behavior = new BehaviorManager(behaviors);
        this.entryPoint = context.getCurrentEntryPoint();
        for (Behavior b : behaviors) {
            if (!(b instanceof SlidingTimeWindow)) continue;
            ((SlidingTimeWindow)b).setWindowNode(this);
        }
        this.hashcode = this.calculateHashCode();
        this.initMemoryId(context);
    }

    @Override
    public short getType() {
        return 60;
    }

    public List<AlphaNodeFieldConstraint> getConstraints() {
        return this.constraints;
    }

    public Behavior[] getBehaviors() {
        return this.behavior.getBehaviors();
    }

    @Override
    public void doAttach(BuildContext context) {
        this.source.addObjectSink(this);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        EventFactHandle evFh = (EventFactHandle)factHandle;
        for (AlphaNodeFieldConstraint constraint : this.constraints) {
            if (constraint.isAllowed(evFh, reteEvaluator)) continue;
            return;
        }
        RightTupleImpl rightTuple = new RightTupleImpl(evFh, this);
        rightTuple.setPropagationContext(pctx);
        EventFactHandle clonedFh = evFh.cloneAndLink();
        rightTuple.setContextObject(clonedFh);
        WindowMemory memory = reteEvaluator.getNodeMemory(this);
        if (!this.behavior.assertFact(memory.behaviorContext, clonedFh, pctx, reteEvaluator)) {
            return;
        }
        this.sink.propagateAssertObject(clonedFh, pctx, reteEvaluator);
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        if (this.isInUse()) {
            WindowMemory memory = reteEvaluator.getNodeMemory(this);
            this.behavior.retractFact(memory.behaviorContext, rightTuple.getFactHandle(), pctx, reteEvaluator);
        }
        InternalFactHandle clonedFh = (InternalFactHandle)rightTuple.getContextObject();
        ObjectTypeNode.doRetractObject(clonedFh, pctx, reteEvaluator);
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, ReteEvaluator reteEvaluator) {
        EventFactHandle originalFactHandle = (EventFactHandle)rightTuple.getFactHandle();
        EventFactHandle cloneFactHandle = (EventFactHandle)rightTuple.getContextObject();
        originalFactHandle.quickCloneUpdate(cloneFactHandle);
        boolean isAllowed = true;
        for (AlphaNodeFieldConstraint constraint : this.constraints) {
            if (constraint.isAllowed(cloneFactHandle, reteEvaluator)) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(cloneFactHandle.detachLinkedTuples());
            this.sink.propagateModifyObject(cloneFactHandle, modifyPreviousTuples, context, reteEvaluator);
            modifyPreviousTuples.retractTuples(context, reteEvaluator);
        } else {
            ObjectTypeNode.doRetractObject(cloneFactHandle, context, reteEvaluator);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple(this.partitionId);
        while (rightTuple != null && rightTuple.getInputOtnId().before(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple(this.partitionId);
            rightTuple.setPropagationContext(context);
            rightTuple.retractTuple(context, reteEvaluator);
            rightTuple = modifyPreviousTuples.peekRightTuple(this.partitionId);
        }
        if (rightTuple != null && rightTuple.getInputOtnId().equals(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple(this.partitionId);
            rightTuple.reAdd();
            this.modifyRightTuple(rightTuple, context, reteEvaluator);
        } else {
            this.assertObject(factHandle, context, reteEvaluator);
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNode.ObjectTypeNodeMemory omem = workingMemory.getNodeMemory(this.getObjectTypeNode());
        Iterator<InternalFactHandle> it = omem.iterator();
        while (it.hasNext()) {
            this.assertObject(it.next(), context, workingMemory);
        }
    }

    @Override
    public WindowMemory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        WindowMemory memory = new WindowMemory();
        memory.behaviorContext = this.behavior.createBehaviorContext();
        return memory;
    }

    @Override
    public String toString() {
        return "[WindowNode(" + this.id + ") constraints=" + this.constraints + "]";
    }

    private int calculateHashCode() {
        return this.source.hashCode() * 17 + (this.constraints != null ? this.constraints.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WindowNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        WindowNode other = (WindowNode)object;
        return this.source.getId() == other.source.getId() && this.constraints.equals(other.constraints) && this.behavior.equals(other.behavior);
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public BitMask calculateDeclaredMask(Class modifiedClass, List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectTypeNode.Id getRightInputOtnId() {
        return this.rightInputOtnId;
    }

    public void setRightInputOtnId(ObjectTypeNode.Id rightInputOtnId) {
        this.rightInputOtnId = rightInputOtnId;
    }

    public static class WindowMemory
    implements Memory {
        public Behavior.Context[] behaviorContext;

        @Override
        public short getNodeType() {
            return 60;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return null;
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void nullPrevNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }

        public Collection<EventFactHandle> getFactHandles() {
            ArrayList<EventFactHandle> eventFactHandles = new ArrayList<EventFactHandle>();
            for (Behavior.Context ctx : this.behaviorContext) {
                for (EventFactHandle efh : ctx.getFactHandles()) {
                    eventFactHandles.add(efh.getLinkedFactHandle());
                }
            }
            return eventFactHandles;
        }
    }
}

