/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;

public class StrEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String strOp = Operator.BuiltInOperator.STR.getSymbol();
    public static final Operator STR_COMPARE = Operator.determineOperator((String)strOp, (boolean)false);
    public static final Operator NOT_STR_COMPARE = Operator.determineOperator((String)strOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{strOp};
    private Evaluator[] evaluator;

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
        StrEvaluator evaluator = new StrEvaluator(type, isNegated);
        evaluator.setParameterText(parameterText);
        return evaluator;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluator = (Evaluator[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluator);
    }

    public static class StrEvaluator
    extends BaseEvaluator {
        private Operations parameter;

        public void setParameterText(String parameterText) {
            this.parameter = Operations.valueOf(parameterText);
        }

        public Operations getParameter() {
            return this.parameter;
        }

        public StrEvaluator() {
        }

        public StrEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? NOT_STR_COMPARE : STR_COMPARE);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle factHandle, FieldValue value) {
            Object objectValue = extractor.getValue(reteEvaluator, factHandle.getObject());
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)objectValue).startsWith((String)value.getValue());
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)objectValue).endsWith((String)value.getValue());
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)objectValue).length() == value.getLongValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor leftExtractor, InternalFactHandle left, InternalReadAccessor rightExtractor, InternalFactHandle right) {
            Object value1 = leftExtractor.getValue(reteEvaluator, left.getObject());
            Object value2 = rightExtractor.getValue(reteEvaluator, right.getObject());
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)value1).startsWith((String)value2);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)value1).endsWith((String)value2);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)value1).length() == ((Number)value2).longValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)right.getObject()).startsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)right.getObject()).endsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)right.getObject()).length() == ((Number)((VariableRestriction.ObjectVariableContextEntry)context).left).longValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)left.getObject()).startsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).right);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)left.getObject()).endsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).right);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)left.getObject()).length() == ((Number)((VariableRestriction.ObjectVariableContextEntry)context).right).longValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        @Override
        public String toString() {
            return "StrEvaluatorDefinition str";
        }
    }

    public static enum Operations {
        startsWith,
        endsWith,
        length;

    }
}

