/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.TraitHelper;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectStoreWrapper;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedEntryPoint
implements InternalWorkingMemoryEntryPoint,
WorkingMemoryEntryPoint,
PropertyChangeListener {
    protected static final transient Logger log = LoggerFactory.getLogger(NamedEntryPoint.class);
    protected static final Class<?>[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    protected final Object[] addRemovePropertyChangeListenerArgs = new Object[]{this};
    protected ObjectStore objectStore;
    protected transient RuleBase ruleBase;
    protected EntryPointId entryPoint;
    protected EntryPointNode entryPointNode;
    protected ReteEvaluator reteEvaluator;
    protected FactHandleFactory handleFactory;
    protected PropagationContextFactory pctxFactory;
    protected ReentrantLock lock;
    protected Set<InternalFactHandle> dynamicFacts = null;
    private boolean isEqualityBehaviour = false;
    private Object ruleUnit;

    protected NamedEntryPoint() {
        this.lock = null;
        this.reteEvaluator = null;
    }

    public NamedEntryPoint(EntryPointId entryPoint, EntryPointNode entryPointNode, ReteEvaluator reteEvaluator) {
        this.entryPoint = entryPoint;
        this.entryPointNode = entryPointNode;
        this.reteEvaluator = reteEvaluator;
        this.ruleBase = this.reteEvaluator.getKnowledgeBase();
        this.lock = reteEvaluator.getSessionConfiguration().isThreadSafe() ? new ReentrantLock() : null;
        this.handleFactory = this.reteEvaluator.getFactHandleFactory();
        RuleBaseConfiguration conf = this.ruleBase.getConfiguration();
        this.pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        this.isEqualityBehaviour = RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals(conf.getAssertBehaviour());
        this.objectStore = this.isEqualityBehaviour || conf.isMutabilityEnabled() ? new ClassAwareObjectStore(this.isEqualityBehaviour, this.lock) : new IdentityObjectStore();
    }

    public void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    public void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    @Override
    public void reset() {
        this.objectStore.clear();
        if (TruthMaintenanceSystemFactory.present()) {
            TruthMaintenanceSystemFactory.get().clearTruthMaintenanceSystem(this);
        }
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public EntryPointNode getEntryPointNode() {
        return this.entryPointNode;
    }

    @Override
    public FactHandleFactory getHandleFactory() {
        return this.handleFactory;
    }

    public FactHandle insert(Object object) {
        return this.insert(object, false, null, null);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) {
        return this.insert(object, dynamic, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactHandle insert(Object object, boolean dynamic, RuleImpl rule, TerminalNode terminalNode) {
        if (object == null) {
            return null;
        }
        try {
            InternalFactHandle handle;
            this.reteEvaluator.startOperation();
            ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint, object);
            PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, rule, terminalNode, null, this.entryPoint);
            if (this.reteEvaluator.isSequential()) {
                InternalFactHandle handle2 = this.createHandle(object, typeConf);
                propagationContext.setFactHandle(handle2);
                this.insert(handle2, object, rule, typeConf, propagationContext);
                InternalFactHandle internalFactHandle = handle2;
                return internalFactHandle;
            }
            try {
                this.lock();
                handle = this.objectStore.getHandleForObject(object);
                if (typeConf.isTMSEnabled()) {
                    if (handle != null && handle.getEqualityKey().getStatus() == 1) {
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    handle = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem(this).insertOnTms(object, typeConf, propagationContext, handle, this::createHandle);
                } else {
                    if (handle != null) {
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    handle = this.createHandle(object, typeConf);
                }
                propagationContext.setFactHandle(handle);
                if (dynamic || typeConf.isDynamic()) {
                    this.addPropertyChangeListener(handle, dynamic);
                }
                this.insert(handle, object, rule, typeConf, propagationContext);
            }
            finally {
                this.unlock();
            }
            InternalFactHandle internalFactHandle = handle;
            return internalFactHandle;
        }
        finally {
            this.reteEvaluator.endOperation();
        }
    }

    @Override
    public void insert(InternalFactHandle handle, Object object, RuleImpl rule, TerminalNode terminalNode, ObjectTypeConf typeConf) {
        PropagationContext pctx = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, rule, terminalNode, handle, this.entryPoint);
        this.insert(handle, object, rule, typeConf, pctx);
    }

    @Override
    public void insert(InternalFactHandle handle, Object object, RuleImpl rule, ObjectTypeConf typeConf, PropagationContext pctx) {
        this.ruleBase.executeQueuedActions();
        this.objectStore.addHandle(handle, object);
        this.entryPointNode.assertObject(handle, pctx, typeConf, this.reteEvaluator);
        this.reteEvaluator.getRuleRuntimeEventSupport().fireObjectInserted(pctx, handle, object, this.reteEvaluator);
    }

    @Override
    public FactHandle insertAsync(Object object) {
        ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint, object);
        PropagationContext pctx = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, null, this.entryPoint);
        InternalFactHandle handle = this.createHandle(object, typeConf);
        pctx.setFactHandle(handle);
        this.entryPointNode.assertObject(handle, pctx, typeConf, this.reteEvaluator);
        this.reteEvaluator.getRuleRuntimeEventSupport().fireObjectInserted(pctx, handle, object, this.reteEvaluator);
        return handle;
    }

    public void update(FactHandle factHandle, Object object) {
        this.update((InternalFactHandle)factHandle, object, PropertySpecificUtil.allSetBitMask(), (Class<?>)Object.class, (Activation)null);
    }

    public void update(FactHandle handle, Object object, String ... modifiedProperties) {
        Class<?> modifiedClass = object.getClass();
        TypeDeclaration typeDeclaration = this.ruleBase.getOrCreateExactTypeDeclaration(modifiedClass);
        AllSetBitMask mask = typeDeclaration.isPropertyReactive() ? PropertySpecificUtil.calculatePositiveMask(modifiedClass, Arrays.asList(modifiedProperties), typeDeclaration.getAccessibleProperties()) : AllSetBitMask.get();
        this.update((InternalFactHandle)handle, object, (BitMask)mask, modifiedClass, (Activation)null);
    }

    @Override
    public void update(FactHandle factHandle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.update((InternalFactHandle)factHandle, object, mask, modifiedClass, activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalFactHandle update(InternalFactHandle handle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.lock();
        try {
            this.reteEvaluator.startOperation();
            try {
                ObjectTypeConf typeConf;
                Object originalObject;
                boolean changedObject;
                this.ruleBase.executeQueuedActions();
                if (handle.isDisconnected()) {
                    handle = this.objectStore.reconnect(handle);
                }
                boolean bl = changedObject = (originalObject = handle.getObject()) != object;
                if (!handle.getEntryPointId().equals(this.entryPoint)) {
                    throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
                }
                if (handle.isExpired()) {
                    ((EventFactHandle)handle).setPendingRemoveFromStore(true);
                }
                ObjectTypeConf objectTypeConf = typeConf = changedObject ? this.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint, object) : this.getObjectTypeConfigurationRegistry().getObjectTypeConf(object);
                if (changedObject || this.isEqualityBehaviour) {
                    this.objectStore.updateHandle(handle, object);
                }
                this.handleFactory.increaseFactHandleRecency(handle);
                PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.MODIFICATION, activation == null ? null : activation.getRule(), activation == null ? null : (TerminalNode)activation.getTuple().getTupleSink(), handle, this.entryPoint, mask, modifiedClass, null);
                if (typeConf.isTMSEnabled()) {
                    TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem(this).updateOnTms(handle, object, activation);
                }
                this.beforeUpdate(handle, object, activation, originalObject, propagationContext);
                this.update(handle, object, originalObject, typeConf, propagationContext);
            }
            finally {
                this.reteEvaluator.endOperation();
            }
        }
        finally {
            this.unlock();
        }
        return handle;
    }

    protected void beforeUpdate(InternalFactHandle handle, Object object, Activation activation, Object originalObject, PropagationContext propagationContext) {
    }

    @Override
    public void update(InternalFactHandle handle, Object object, Object originalObject, ObjectTypeConf typeConf, PropagationContext propagationContext) {
        this.entryPointNode.modifyObject(handle, propagationContext, typeConf, this.reteEvaluator);
        this.reteEvaluator.getRuleRuntimeEventSupport().fireObjectUpdated(propagationContext, handle, originalObject, object, this.reteEvaluator);
    }

    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    public void delete(FactHandle handle) {
        this.delete(handle, null, null);
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.delete(handle, null, null, fhState);
    }

    @Override
    public void delete(FactHandle factHandle, RuleImpl rule, TerminalNode terminalNode) {
        this.delete(factHandle, rule, terminalNode, FactHandle.State.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(FactHandle factHandle, RuleImpl rule, TerminalNode terminalNode, FactHandle.State fhState) {
        if (factHandle == null) {
            throw new IllegalArgumentException("FactHandle cannot be null ");
        }
        this.lock();
        try {
            this.reteEvaluator.startOperation();
            try {
                this.ruleBase.executeQueuedActions();
                InternalFactHandle handle = (InternalFactHandle)factHandle;
                if (handle.getId() == -1L) {
                    return;
                }
                if (handle.isDisconnected()) {
                    handle = this.objectStore.reconnect(handle);
                }
                if (!handle.getEntryPointId().equals(this.entryPoint)) {
                    throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
                }
                EqualityKey key = handle.getEqualityKey();
                if (fhState.isStated()) {
                    this.deleteStated(rule, terminalNode, handle, key);
                }
                if (fhState.isLogical()) {
                    this.deleteLogical(key);
                }
            }
            finally {
                this.reteEvaluator.endOperation();
            }
        }
        finally {
            this.unlock();
        }
    }

    private void deleteStated(RuleImpl rule, TerminalNode terminalNode, InternalFactHandle handle, EqualityKey key) {
        if (key != null && key.getStatus() == 2) {
            return;
        }
        this.beforeDestroy(rule, terminalNode, handle);
        Object object = handle.getObject();
        ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getObjectTypeConf(object);
        if (typeConf.isDynamic()) {
            this.removePropertyChangeListener(handle, true);
        }
        PropagationContext propagationContext = this.delete(handle, object, typeConf, rule, null, terminalNode);
        this.deleteFromTMS(handle, key, typeConf, propagationContext);
        this.handleFactory.destroyFactHandle(handle);
    }

    protected void beforeDestroy(RuleImpl rule, TerminalNode terminalNode, InternalFactHandle handle) {
    }

    private void deleteFromTMS(InternalFactHandle handle, EqualityKey key, ObjectTypeConf typeConf, PropagationContext propagationContext) {
        if (typeConf.isTMSEnabled() && key != null) {
            TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem(this).deleteFromTms(handle, key, propagationContext);
        }
    }

    private void deleteLogical(EqualityKey key) {
        if (key != null && key.getStatus() == 2) {
            TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem(this).delete(key.getLogicalFactHandle());
        }
    }

    @Override
    public PropagationContext delete(InternalFactHandle handle, Object object, ObjectTypeConf typeConf, RuleImpl rule, Activation activation) {
        return this.delete(handle, object, typeConf, rule, activation, activation == null ? null : (TerminalNode)activation.getTuple().getTupleSink());
    }

    @Override
    public PropagationContext delete(InternalFactHandle handle, Object object, ObjectTypeConf typeConf, RuleImpl rule, Activation activation, TerminalNode terminalNode) {
        PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.reteEvaluator.getNextPropagationIdCounter(), PropagationContext.Type.DELETION, rule, terminalNode, handle, this.entryPoint);
        this.entryPointNode.retractObject(handle, propagationContext, typeConf, this.reteEvaluator);
        this.afterRetract(handle, rule, terminalNode);
        this.objectStore.removeHandle(handle);
        this.reteEvaluator.getRuleRuntimeEventSupport().fireObjectRetracted(propagationContext, handle, object, this.reteEvaluator);
        return propagationContext;
    }

    protected void afterRetract(InternalFactHandle handle, RuleImpl rule, TerminalNode terminalNode) {
    }

    @Override
    public void removeFromObjectStore(InternalFactHandle handle) {
        this.objectStore.removeHandle(handle);
        ObjectTypeConf typeConf = this.getObjectTypeConfigurationRegistry().getObjectTypeConf(handle.getObject());
        this.deleteFromTMS(handle, handle.getEqualityKey(), typeConf, null);
    }

    protected void addPropertyChangeListener(InternalFactHandle handle, boolean dynamicFlag) {
        Object object = handle.getObject();
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            method.invoke(object, this.addRemovePropertyChangeListenerArgs);
            if (dynamicFlag) {
                if (this.dynamicFacts == null) {
                    this.dynamicFacts = new HashSet<InternalFactHandle>();
                }
                this.dynamicFacts.add(handle);
            }
        }
        catch (NoSuchMethodException e) {
            log.error("Warning: Method addPropertyChangeListener not found on the class " + object.getClass() + " so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalArgumentException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " does not take a simple PropertyChangeListener argument so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalAccessException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " is not public so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object");
        }
        catch (InvocationTargetException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " threw an InvocationTargetException so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            log.error("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a addPropertyChangeListener method so Drools will be unable to process JavaBean PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
    }

    protected void removePropertyChangeListener(FactHandle handle, boolean removeFromSet) {
        Object object = ((InternalFactHandle)handle).getObject();
        try {
            if (this.dynamicFacts != null && removeFromSet) {
                this.dynamicFacts.remove(handle);
            }
            if (object != null) {
                Method mehod = object.getClass().getMethod("removePropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
                mehod.invoke(object, this.addRemovePropertyChangeListenerArgs);
            }
        }
        catch (NoSuchMethodException mehod) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " does not take a simple PropertyChangeListener argument so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " is not public so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Warning: The removePropertyChangeL istener method on the class " + object.getClass() + " threw an InvocationTargetException so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeException("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a removePropertyChangeListener method so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
    }

    @Override
    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.entryPointNode.getTypeConfReg();
    }

    @Override
    public RuleBase getKnowledgeBase() {
        return this.ruleBase;
    }

    public FactHandle getFactHandle(Object object) {
        return this.objectStore.getHandleForObject(object);
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public ReteEvaluator getReteEvaluator() {
        return this.reteEvaluator;
    }

    public Object getObject(FactHandle factHandle) {
        return this.objectStore.getObjectForHandle((InternalFactHandle)factHandle);
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return new ObjectStoreWrapper(this.objectStore, null, 1);
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return new ObjectStoreWrapper(this.objectStore, filter, 1);
    }

    public Collection<?> getObjects() {
        return new ObjectStoreWrapper(this.objectStore, null, 0);
    }

    public Collection<?> getObjects(ObjectFilter filter) {
        return new ObjectStoreWrapper(this.objectStore, filter, 0);
    }

    public String getEntryPointId() {
        return this.entryPoint.getEntryPointId();
    }

    public long getFactCount() {
        return this.objectStore.size();
    }

    private InternalFactHandle createHandle(Object object, ObjectTypeConf typeConf) {
        return this.handleFactory.newFactHandle(object, typeConf, this.reteEvaluator, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object object = event.getSource();
        FactHandle handle = this.getFactHandle(object);
        if (handle == null) {
            throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        this.update(handle, object, event.getPropertyName());
    }

    @Override
    public void dispose() {
        if (this.dynamicFacts != null) {
            for (InternalFactHandle handle : this.dynamicFacts) {
                this.removePropertyChangeListener(handle, false);
            }
            this.dynamicFacts = null;
        }
        for (ObjectTypeConf conf : this.getObjectTypeConfigurationRegistry().values()) {
            ObjectTypeNode otn;
            if (!conf.isDynamic() || (otn = conf.getConcreteObjectTypeNode()) == null) continue;
            Iterator<InternalFactHandle> it = this.reteEvaluator.getNodeMemory(otn).iterator();
            while (it.hasNext()) {
                this.removePropertyChangeListener(it.next(), false);
            }
        }
    }

    @Override
    public TraitHelper getTraitHelper() {
        throw new UnsupportedOperationException("In order to use traits you must add the drools-traits module to your classpath");
    }

    @Override
    public PropagationContextFactory getPctxFactory() {
        return this.pctxFactory;
    }

    public String toString() {
        return this.entryPoint.toString();
    }

    @Override
    public Object getRuleUnit() {
        return this.ruleUnit;
    }

    @Override
    public void setRuleUnit(Object ruleUnit) {
        this.ruleUnit = ruleUnit;
    }
}

