/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.core.base.ValueType;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.time.Interval;
import org.drools.core.util.TimeIntervalParser;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;

public class StartedByEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String startedByOp = Operator.BuiltInOperator.STARTED_BY.getSymbol();
    public static final Operator STARTED_BY = Operator.determineOperator((String)startedByOp, (boolean)false);
    public static final Operator NOT_STARTED_BY = Operator.determineOperator((String)startedByOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{startedByOp};
    private Map<String, StartedByEvaluator> cache = Collections.emptyMap();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        StartedByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, StartedByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse((String)parameterText);
            eval = new StartedByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class StartedByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long startDev;
        private String paramText;

        public StartedByEvaluator() {
        }

        public StartedByEvaluator(ValueType type, boolean isNegated, long[] params, String paramText) {
            super(type, isNegated ? NOT_STARTED_BY : STARTED_BY);
            this.paramText = paramText;
            this.setParameters(params);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startDev);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, 0L);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'startedby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(reteEvaluator, left.getObject())) {
                return false;
            }
            long distStart = Math.abs(((VariableRestriction.TemporalVariableContextEntry)context).startTS - ((EventFactHandle)left).getStartTimestamp());
            long distEnd = ((VariableRestriction.TemporalVariableContextEntry)context).endTS - ((EventFactHandle)left).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd > 0L);
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(reteEvaluator, right.getObject())) {
                return false;
            }
            long distStart = Math.abs(((EventFactHandle)right).getStartTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).startTS);
            long distEnd = ((EventFactHandle)right).getEndTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd > 0L);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(reteEvaluator, handle1.getObject()) || extractor2.isNullValue(reteEvaluator, handle2.getObject())) {
                return false;
            }
            long distStart = Math.abs(((EventFactHandle)handle1).getStartTimestamp() - ((EventFactHandle)handle2).getStartTimestamp());
            long distEnd = ((EventFactHandle)handle1).getEndTimestamp() - ((EventFactHandle)handle2).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd > 0L);
        }

        @Override
        public String toString() {
            return "startedby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.startDev ^ this.startDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StartedByEvaluator other = (StartedByEvaluator)obj;
            return this.startDev == other.startDev;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.startDev = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeException("[StartedBy Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeException("[StartedBy Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.startDev = parameters[0];
            }
        }
    }
}

