/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time;

import org.drools.core.SessionConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.time.TimerService;
import org.drools.wiring.api.ComponentsFactory;

public class TimerServiceFactory {
    public static TimerService getTimerService(SessionConfiguration config) {
        TimerService service;
        switch (config.getClockType()) {
            case REALTIME_CLOCK: {
                service = TimerServiceFactory.newTimerService((SessionConfigurationImpl)config);
                break;
            }
            case PSEUDO_CLOCK: {
                service = (TimerService)config.getClockType().createInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported clock type: " + (Object)((Object)config.getClockType()));
            }
        }
        service.setTimerJobFactoryManager(config.getTimerJobFactoryManager());
        return service;
    }

    private static TimerService newTimerService(SessionConfigurationImpl config) {
        String className = config.getPropertyValue("drools.timerService", "org.drools.core.time.impl.JDKTimerService");
        if (className == null) {
            return null;
        }
        return (TimerService)ComponentsFactory.createTimerService((String)className);
    }
}

