/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.traits.core.factmodel.AbstractTraitFactory;
import org.drools.traits.core.factmodel.HierarchyEncoder;
import org.drools.traits.core.factmodel.LogicalTypeInconsistencyException;
import org.drools.traits.core.factmodel.TraitClassBuilderImpl;
import org.drools.traits.core.factmodel.TraitRegistryImpl;
import org.drools.traits.core.factmodel.TripleFactory;
import org.drools.traits.core.factmodel.TripleFactoryImpl;
import org.drools.traits.core.factmodel.TripleStore;
import org.drools.traits.core.factmodel.VirtualPropertyMode;
import org.drools.traits.core.reteoo.TraitRuntimeComponentFactoryImpl;
import org.drools.traits.core.util.HierarchyEncoderImpl;
import org.drools.wiring.api.classloader.ProjectClassLoader;

public class StandaloneTraitFactory<T extends Thing<K>, K extends TraitableBean>
extends AbstractTraitFactory<T, K> {
    private ProjectClassLoader classLoader;
    private TraitRuntimeComponentFactoryImpl kieComponentFactory = new TraitRuntimeComponentFactoryImpl();
    private TraitRegistryImpl registry;
    private ClassFieldAccessorStore store;
    private HierarchyEncoder encoder;
    private TripleStore tripleStore;
    private TripleFactory tripleFactory;

    public StandaloneTraitFactory(ProjectClassLoader classLoader) {
        this(classLoader, VirtualPropertyMode.MAP);
    }

    public StandaloneTraitFactory(ProjectClassLoader classLoader, VirtualPropertyMode mode) {
        this.classLoader = classLoader;
        this.store = new ClassFieldAccessorStore();
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache((ClassLoader)this.classLoader));
        this.encoder = new HierarchyEncoderImpl();
        this.encoder.encode(Thing.class, Collections.emptyList());
        this.mode = mode;
        StandaloneTraitFactory.setMode(this.mode, null, this.kieComponentFactory);
    }

    public StandaloneTraitFactory() {
    }

    @Override
    protected Class<?> registerAndLoadTypeDefinition(String className, byte[] def) throws ClassNotFoundException {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (def != null) {
                return this.classLoader.defineClass(className, def);
            }
            throw e;
        }
    }

    @Override
    protected ClassLoader getRootClassLoader() {
        return this.classLoader;
    }

    @Override
    protected TraitRegistryImpl getTraitRegistry() {
        if (this.registry == null) {
            this.registry = new TraitRegistryImpl();
        }
        return this.registry;
    }

    @Override
    protected HierarchyEncoder getHierarchyEncoder() {
        return this.encoder;
    }

    @Override
    protected TripleStore getTripleStore() {
        if (this.tripleStore == null) {
            this.tripleStore = new TripleStore();
        }
        return this.tripleStore;
    }

    @Override
    protected TripleFactory getTripleFactory() {
        if (this.tripleFactory == null) {
            this.tripleFactory = new TripleFactoryImpl();
        }
        return this.tripleFactory;
    }

    @Override
    protected ClassFieldAccessorStore getClassFieldAccessorStore() {
        return this.store;
    }

    @Override
    public T getProxy(K core, Class<?> trait, boolean logical) throws LogicalTypeInconsistencyException {
        this.encode(trait);
        if (!this.getTraitRegistry().getTraits().containsKey(trait.getName())) {
            try {
                this.getTraitRegistry().addTrait(trait.getName(), this.buildClassDefinition(trait, trait));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.getProxy(core, trait, logical);
    }

    private void encode(Class<?> trait) {
        for (Class<?> sup : trait.getInterfaces()) {
            this.encode(sup);
        }
        ArrayList<String> supers = new ArrayList<String>(trait.getInterfaces().length);
        for (Class<?> k : trait.getInterfaces()) {
            supers.add(k.getName());
        }
        this.getHierarchyEncoder().encode(trait.getName(), supers);
    }

    public <X> CoreWrapper<X> makeTraitable(X o, Class<X> klass) {
        if (o instanceof TraitableBean) {
            throw new IllegalStateException("Method makeTraitable should be used on non-traitable objects");
        }
        try {
            Class<CoreWrapper<X>> wrapperClass = this.buildCoreWrapper(klass, this.buildClassDefinition(klass, klass));
            CoreWrapper<X> wrapper = this.getCoreWrapper(klass, this.buildClassDefinition(klass, wrapperClass));
            wrapper.init(o);
            return wrapper;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public T don(K core, Class<T> trait) throws LogicalTypeInconsistencyException {
        if (trait.getAnnotation(Trait.class) == null || !Thing.class.isAssignableFrom(trait)) {
            trait = this.extendAsProperTrait(trait);
        }
        return this.getProxy(core, trait, false);
    }

    private Class<T> extendAsProperTrait(Class<T> trait) {
        String extName = trait.getName() + "_Trait__Extension";
        if (!this.classLoader.isClassInUse(extName)) {
            try {
                ClassDefinition extDef = new ClassDefinition(extName);
                extDef.setSuperClass(Object.class.getName());
                AnnotationDefinition annot = new AnnotationDefinition(Trait.class.getName());
                extDef.addAnnotation(annot);
                String[] supers = new String[]{Thing.class.getName(), trait.getName()};
                extDef.setInterfaces(supers);
                byte[] ext = new TraitClassBuilderImpl().buildClass(extDef, (ClassLoader)this.classLoader);
                Class<?> klass = this.registerAndLoadTypeDefinition(extName, ext);
                ClassDefinition tDef = this.buildClassDefinition(trait, trait);
                tDef.setDefinedClass(klass);
                this.getTraitRegistry().addTrait(tDef);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return Class.forName(extName, false, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

