/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler.io.memory;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.FileSystemItem;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.kie.memorycompiler.resources.KiePath;

public class MemoryFolder
implements Folder,
Serializable {
    private final MemoryFileSystem mfs;
    private final KiePath path;
    private MemoryFolder pFolder;

    public MemoryFolder(MemoryFileSystem mfs, String path) {
        this(mfs, KiePath.of((String)path));
    }

    public MemoryFolder(MemoryFileSystem mfs, KiePath path) {
        this.mfs = mfs;
        this.path = path;
    }

    @Override
    public String getName() {
        return this.path.getFileName();
    }

    @Override
    public KiePath getPath() {
        return this.path;
    }

    @Override
    public File getFile(String name) {
        return this.mfs.getFile(this.path.resolve(name));
    }

    @Override
    public Folder getFolder(String name) {
        return this.mfs.getFolder(this.path.resolve(name));
    }

    @Override
    public Folder getParent() {
        if (this.pFolder == null) {
            this.pFolder = new MemoryFolder(this.mfs, this.path.getParent());
        }
        return this.pFolder;
    }

    @Override
    public Collection<? extends FileSystemItem> getMembers() {
        Set<? extends FileSystemItem> members = this.mfs.getMembers(this);
        return members != null ? members : Collections.emptyList();
    }

    @Override
    public boolean exists() {
        return this.mfs.existsFolder(this.path);
    }

    @Override
    public boolean create() {
        this.mfs.createFolder(this);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryFolder other = (MemoryFolder)obj;
        return Objects.equals(this.path, other.path);
    }

    public String toString() {
        return "MemoryFolder [path=" + this.path.asString() + "]";
    }
}

