/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.IoUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.eclipse.aether.artifact.Artifact;
import org.kie.api.builder.ReleaseId;
import org.kie.maven.integration.ArtifactResolver;
import org.kie.maven.integration.DependencyDescriptor;
import org.kie.scanner.KieModuleMetaData;
import org.kie.util.maven.support.DependencyFilter;
import org.kie.util.maven.support.PomModel;

public class KieModuleMetaDataImpl
implements KieModuleMetaData {
    private final Map<String, Collection<String>> classes = new HashMap<String, Collection<String>>();
    private final Map<String, String> processes = new HashMap<String, String>();
    private final Map<String, String> forms = new HashMap<String, String>();
    private final Map<URI, File> jars = new HashMap<URI, File>();
    private final Map<String, TypeMetaInfo> typeMetaInfos = new HashMap<String, TypeMetaInfo>();
    private final Map<String, Set<String>> rulesByPackage = new HashMap<String, Set<String>>();
    private final Set<String> packages = new HashSet<String>();
    private final DependencyFilter dependencyFilter;
    private ProjectClassLoader classLoader;
    private ReleaseId releaseId;
    private InternalKieModule kieModule;

    public KieModuleMetaDataImpl(ReleaseId releaseId, DependencyFilter dependencyFilter) {
        this.releaseId = releaseId;
        this.dependencyFilter = dependencyFilter;
        this.init(ArtifactResolver.getResolverFor((ReleaseId)releaseId, (boolean)false));
    }

    public KieModuleMetaDataImpl(File pomFile, DependencyFilter dependencyFilter) {
        this.dependencyFilter = dependencyFilter;
        this.init(ArtifactResolver.getResolverFor((File)pomFile));
    }

    public KieModuleMetaDataImpl(InternalKieModule kieModule, DependencyFilter dependencyFilter) {
        this.kieModule = kieModule;
        this.dependencyFilter = dependencyFilter;
        this.indexKieModule(kieModule);
        this.init(ArtifactResolver.getResolverFor((PomModel)kieModule.getPomModel()));
    }

    public KieModuleMetaDataImpl(InternalKieModule kieModule, List<URI> dependencies) {
        this.kieModule = kieModule;
        this.dependencyFilter = DependencyFilter.TAKE_ALL_FILTER;
        this.indexKieModule(kieModule);
        this.init(dependencies);
    }

    private void indexKieModule(InternalKieModule kieModule) {
        for (String file : kieModule.getFileNames()) {
            if (this.indexClass(file) || !file.endsWith(KieModuleModelImpl.KMODULE_INFO_JAR_PATH.asString())) continue;
            this.indexMetaInfo(kieModule.getBytes(file));
        }
    }

    @Override
    public Collection<String> getPackages() {
        return this.packages;
    }

    @Override
    public Collection<String> getClasses(String packageName) {
        Collection<String> classesInPkg = this.classes.get(packageName);
        return classesInPkg != null ? classesInPkg : Collections.emptyList();
    }

    @Override
    public Class<?> getClass(String pkgName, String className) {
        try {
            return Class.forName(pkgName == null || pkgName.trim().length() == 0 ? className : pkgName + "." + className, false, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public TypeMetaInfo getTypeMetaInfo(Class<?> clazz) {
        TypeMetaInfo typeMetaInfo = this.typeMetaInfos.get(clazz.getName());
        return typeMetaInfo != null ? typeMetaInfo : new TypeMetaInfo(clazz);
    }

    @Override
    public Collection<String> getRuleNamesInPackage(String packageName) {
        Set<String> rulesPerPackage = this.rulesByPackage.get(packageName);
        return rulesPerPackage != null ? rulesPerPackage : Collections.emptyList();
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            URL[] urls = new URL[this.jars.size()];
            int i = 0;
            for (File jar : this.jars.values()) {
                try {
                    urls[i++] = jar.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            this.classLoader = ProjectClassLoader.createProjectClassLoader((ClassLoader)new URLClassLoader(urls, this.getClass().getClassLoader()));
            if (this.kieModule != null) {
                Map classes = this.kieModule.getClassesMap();
                for (Map.Entry entry : classes.entrySet()) {
                    this.classLoader.storeClass(ClassUtils.convertResourceToClassName((String)((String)entry.getKey())), (String)entry.getKey(), (byte[])entry.getValue());
                }
            }
        }
        return this.classLoader;
    }

    private void init(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            return;
        }
        if (this.releaseId != null) {
            this.addArtifact(artifactResolver.resolveArtifact(this.releaseId));
        }
        if (this.kieModule != null && this.kieModule.getPomModel() != null) {
            for (ReleaseId releaseId : this.kieModule.getPomModel().getDependencies(this.dependencyFilter)) {
                this.addArtifact(artifactResolver.resolveArtifact(releaseId));
            }
        } else {
            for (DependencyDescriptor dep : artifactResolver.getAllDependecies(this.dependencyFilter)) {
                this.addArtifact(artifactResolver.resolveArtifact(dep.getReleaseId()));
            }
        }
        this.packages.addAll(this.classes.keySet());
        this.packages.addAll(this.rulesByPackage.keySet());
    }

    private void init(List<URI> dependencies) {
        for (URI uri : dependencies) {
            this.addJar(new File(uri), uri);
        }
        this.packages.addAll(this.classes.keySet());
        this.packages.addAll(this.rulesByPackage.keySet());
    }

    private void addArtifact(Artifact artifact) {
        if (artifact != null && artifact.getExtension() != null && artifact.getExtension().equals("jar")) {
            File jarFile = artifact.getFile();
            this.addJar(jarFile, jarFile.toURI());
        }
    }

    private void addJar(File jarFile, URI uri) {
        if (!this.jars.containsKey(uri)) {
            this.jars.put(uri, jarFile);
            this.scanJar(jarFile);
        }
    }

    private void scanJar(File jarFile) {
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String pathName = entry.getName();
                if (KieModuleMetaDataImpl.isProcessFile(pathName)) {
                    this.processes.put(pathName, new String(IoUtils.readBytesFromZipEntry((File)jarFile, (ZipEntry)entry), IoUtils.UTF8_CHARSET));
                } else if (KieModuleMetaDataImpl.isFormFile(pathName)) {
                    this.forms.put(pathName, new String(IoUtils.readBytesFromZipEntry((File)jarFile, (ZipEntry)entry), IoUtils.UTF8_CHARSET));
                }
                if (this.indexClass(pathName) || !pathName.endsWith(KieModuleModelImpl.KMODULE_INFO_JAR_PATH.asString())) continue;
                this.indexMetaInfo(IoUtils.readBytesFromZipEntry((File)jarFile, (ZipEntry)entry));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean indexClass(String pathName) {
        if (!pathName.endsWith(".class")) {
            return false;
        }
        int separator = pathName.lastIndexOf(47);
        String packageName = separator > 0 ? pathName.substring(0, separator).replace('/', '.') : "";
        String className = pathName.substring(separator + 1, pathName.length() - ".class".length());
        Collection pkg = this.classes.computeIfAbsent(packageName, k -> new HashSet());
        pkg.add(className);
        return true;
    }

    private void indexMetaInfo(byte[] bytes) {
        KieModuleMetaInfo info = KieModuleMetaInfo.unmarshallMetaInfos((String)new String(bytes, IoUtils.UTF8_CHARSET));
        this.typeMetaInfos.putAll(info.getTypeMetaInfos());
        this.rulesByPackage.putAll(info.getRulesByPackage());
    }

    @Override
    public Map<String, String> getProcesses() {
        return this.processes;
    }

    @Override
    public Map<String, String> getForms() {
        return this.forms;
    }

    static boolean isFormFile(String pathName) {
        return pathName.endsWith("frm");
    }

    static boolean isProcessFile(String pathName) {
        return pathName.endsWith("bpmn") || pathName.endsWith("bpmn2") || pathName.endsWith("bpmn-cm");
    }
}

