/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.commands.IdentifiableResult;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.RegistryContext;

@XmlAccessorType(value=XmlAccessType.NONE)
public class CreateProcessInstanceCommand
implements ExecutableCommand<ProcessInstance>,
IdentifiableResult {
    @XmlAttribute(required=true)
    private String processId;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="parameter")
    private Map<String, Object> parameters = new HashMap<String, Object>();
    @XmlElementWrapper(name="data")
    private List<Object> data = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public CreateProcessInstanceCommand() {
    }

    public CreateProcessInstanceCommand(String processId) {
        this.processId = processId;
    }

    public CreateProcessInstanceCommand(String processId, String outIdentifier) {
        this(processId);
        this.outIdentifier = outIdentifier;
    }

    public CreateProcessInstanceCommand(String processId, Map<String, Object> parameters) {
        this(processId);
        this.parameters = parameters;
    }

    public CreateProcessInstanceCommand(String processId, Map<String, Object> parameters, String outIdentifier) {
        this(processId, outIdentifier);
        this.parameters = parameters;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap<String, Object>();
    }

    public void putParameter(String key, Object value) {
        this.getParameters().put(key, value);
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public ProcessInstance execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        if (this.data != null) {
            for (Object o : this.data) {
                ksession.insert(o);
            }
        }
        ProcessInstance processInstance = ksession.createProcessInstance(this.processId, this.parameters);
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).setResult(this.outIdentifier, (Object)processInstance.getId());
        }
        return processInstance;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("session.createProcessInstance(");
        result.append(this.processId);
        result.append(", [");
        if (this.parameters != null) {
            int i = 0;
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                if (i++ > 0) {
                    result.append(", ");
                }
                result.append(entry.getKey());
                result.append("=");
                result.append(entry.getValue());
            }
        }
        result.append("]);");
        return result.toString();
    }
}

