/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.commands.IdentifiableResult;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.xml.jaxb.util.JaxbListAdapter;
import org.drools.util.StringUtils;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;

@XmlAccessorType(value=XmlAccessType.NONE)
public class InsertElementsCommand
implements ExecutableCommand<Collection<FactHandle>>,
IdentifiableResult {
    private static final long serialVersionUID = 510L;
    @XmlJavaTypeAdapter(value=JaxbListAdapter.class)
    @XmlElement(name="list")
    public Collection<Object> objects;
    @XmlAttribute
    private String outIdentifier;
    @XmlAttribute(name="return-objects")
    private boolean returnObject = true;
    @XmlAttribute(name="entry-point")
    private String entryPoint = "DEFAULT";

    public InsertElementsCommand() {
        this.objects = new ArrayList<Object>();
    }

    public InsertElementsCommand(Collection<Object> objects) {
        this.objects = objects;
    }

    public InsertElementsCommand(String outIdentifier) {
        this();
        this.outIdentifier = outIdentifier;
    }

    public Collection<Object> getObjects() {
        return this.objects;
    }

    public void setObjects(Collection<Object> objects) {
        this.objects = objects;
    }

    public Collection<FactHandle> execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        Object wmep = StringUtils.isEmpty((CharSequence)this.entryPoint) ? ksession : ksession.getEntryPoint(this.entryPoint);
        for (Object object : this.objects) {
            handles.add(wmep.insert(object));
        }
        if (this.outIdentifier != null) {
            if (this.returnObject) {
                ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).setResult(this.outIdentifier, this.objects);
            }
            ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).getFactHandles().put(this.outIdentifier, handles);
        }
        return handles;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public boolean isReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(boolean returnObject) {
        this.returnObject = returnObject;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        if (entryPoint == null) {
            entryPoint = "DEFAULT";
        }
        this.entryPoint = entryPoint;
    }

    public String toString() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : this.objects) {
            list.add(object);
        }
        return "insert " + list;
    }
}

