/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.builder;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Wireable;
import org.drools.core.util.bitmask.BitMask;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.parser.DroolsError;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MVELConsequence;
import org.drools.util.StringUtils;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELConsequenceBuilder
implements ConsequenceBuilder {
    public static final Map<String, Macro> macros = new HashMap<String, Macro>(10);

    public void build(RuleBuildContext context, String consequenceName) {
        context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            RuleDescr ruleDescr = context.getRuleDescr();
            String text = "default".equals(consequenceName) ? (String)ruleDescr.getConsequence() : (String)ruleDescr.getNamedConsequences().get(consequenceName);
            text = MVELConsequenceBuilder.processMacros(text);
            text = MVELConsequenceBuilder.rewriteModify(text);
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            AnalysisResult analysis = dialect.analyzeBlock((PackageBuildContext)context, text, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), (PackageBuildContext)context, Collections.EMPTY_MAP, KnowledgeHelper.class), null, "drools", KnowledgeHelper.class);
            if (analysis == null) {
                return;
            }
            text = MVELConsequenceBuilder.rewriteUpdates(context, analysis, text);
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
            String[] declrStr = new String[declarations.length];
            int j = 0;
            Iterator iterator = usedIdentifiers.getDeclrClasses().keySet().iterator();
            while (iterator.hasNext()) {
                String str;
                declrStr[j] = str = (String)iterator.next();
                declarations[j++] = (Declaration)decls.get(str);
            }
            Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
            for (int i = 0; i < declrStr.length; ++i) {
                declrStr[i] = declarations[i].getIdentifier();
            }
            context.getRule().setRequiredDeclarationsForConsequence(consequenceName, declrStr);
            MVELCompilationUnit unit = MVELDialect.getMVELCompilationUnit(text, analysis, declarations, null, null, (PackageBuildContext)context, "drools", KnowledgeHelper.class, false, MVELCompilationUnit.Scope.CONSEQUENCE);
            MVELConsequence expr = new MVELConsequence(unit, dialect.getId(), consequenceName);
            if ("default".equals(consequenceName)) {
                context.getRule().setConsequence((Consequence)expr);
            } else {
                context.getRule().addNamedConsequence(consequenceName, (Consequence)expr);
            }
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)context.getRule(), expr);
            expr.compile(data, context.getRule());
        }
        catch (Exception e) {
            AsmUtil.copyErrorLocation(e, (BaseDescr)context.getRuleDescr());
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)context.getRuleDescr(), null, "Unable to build expression for 'consequence': " + e.getMessage() + " '" + context.getRuleDescr().getConsequence() + "'"));
        }
    }

    private static String rewriteModify(String text) {
        int modifyPos = text.indexOf("@Modify with");
        if (modifyPos < 0) {
            return text;
        }
        int modifyArgStart = text.indexOf(40, modifyPos);
        int modifyArgEnd = text.indexOf(41, modifyPos);
        String modified = text.substring(modifyArgStart + 1, modifyArgEnd).trim();
        int modifyBlockStart = text.indexOf(123, modifyArgEnd);
        int modifyBlockEnd = StringUtils.findEndOfBlockIndex((CharSequence)text, (int)modifyBlockStart);
        String modifyBlock = text.substring(modifyBlockStart + 1, modifyBlockEnd).trim();
        StringBuilder sb = new StringBuilder();
        for (String statement : StringUtils.codeAwareSplitOnChar((CharSequence)modifyBlock, (boolean)true, (char[])new char[]{';', ',', '\n'})) {
            sb.append(modified).append(".").append(statement.trim()).append(";\n");
        }
        sb.append("drools.update(").append(modified).append(");\n");
        return MVELConsequenceBuilder.rewriteModify(text.substring(0, modifyPos) + sb + text.substring(modifyBlockEnd + 1));
    }

    private static String rewriteUpdates(RuleBuildContext context, AnalysisResult analysis, String text) {
        return MVELConsequenceBuilder.rewriteUpdates(arg_0 -> ((BoundIdentifiers)analysis.getBoundIdentifiers()).resolveType(arg_0), (Class<?> c) -> {
            TypeDeclaration typeDeclaration = context.getKnowledgeBuilder().getTypeDeclaration(c);
            if (typeDeclaration != null && typeDeclaration.isPropertyReactive()) {
                typeDeclaration.setTypeClass(c);
                return typeDeclaration.getAccessibleProperties();
            }
            return Collections.emptyList();
        }, text);
    }

    public static String rewriteUpdates(Function<String, Class<?>> classResolver, Function<Class<?>, List<String>> propsResolver, String text) {
        int updatePos;
        int start = 0;
        while ((updatePos = text.indexOf("drools.update(", start)) >= 0) {
            List<String> settableProperties;
            int end;
            start = updatePos + "drools.update(".length();
            String identifier = text.substring(start, end = text.indexOf(41, start)).trim();
            Class<?> updatedType = classResolver.apply(identifier);
            if (updatedType == null || (settableProperties = propsResolver.apply(updatedType)).isEmpty()) continue;
            BitMask modificationMask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
            for (String expr : StringUtils.splitStatements((CharSequence)text)) {
                int index;
                if (!expr.startsWith(identifier + ".")) continue;
                int fieldEnd = identifier.length() + 1;
                while (Character.isJavaIdentifierPart(expr.charAt(fieldEnd))) {
                    ++fieldEnd;
                }
                String propertyName = expr.substring(identifier.length() + 1, fieldEnd);
                if (propertyName.length() > 3) {
                    if (propertyName.startsWith("set")) {
                        propertyName = Character.toLowerCase(propertyName.charAt(3)) + propertyName.substring(4);
                    } else if (propertyName.startsWith("get")) {
                        int endMethodName = expr.indexOf(40);
                        int endMethodArgs = StringUtils.findEndOfMethodArgsIndex((CharSequence)expr, (int)endMethodName);
                        String methodParams = expr.substring(endMethodName + 1, endMethodArgs).trim();
                        if (expr.length() > endMethodArgs + 1 && expr.substring(endMethodArgs + 1).trim().startsWith(".")) {
                            propertyName = Character.toLowerCase(propertyName.charAt(3)) + propertyName.substring(4);
                        }
                    }
                }
                if ((index = settableProperties.indexOf(propertyName)) >= 0) {
                    modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)modificationMask, (int)index);
                    continue;
                }
                modificationMask = PropertySpecificUtil.allSetButTraitBitMask();
                break;
            }
            String updateArgs = ", " + modificationMask.getInstancingStatement() + ", " + updatedType.getCanonicalName() + ".class";
            text = text.substring(0, end) + updateArgs + text.substring(end);
            start = end + updateArgs.length();
        }
        return text;
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELConsequenceBuilder.delimitExpressions(consequence));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String delimitExpressions(String s) {
        int i;
        StringBuilder result = new StringBuilder();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int skippedNewLines = 0;
        boolean inString = false;
        char lastNonWhite = ';';
        block12: for (i = 0; i < cs.length; ++i) {
            char c;
            block31: {
                block32: {
                    int start;
                    c = cs[i];
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            if (!inString && MVELConsequenceBuilder.lookAhead(cs, i + 1) == '.') {
                                continue block12;
                            }
                            break block32;
                        }
                        case '\"': {
                            if (i == 0 || cs[i - 1] != '\\') {
                                inString = !inString;
                            }
                            break block32;
                        }
                        case '/': {
                            if (i < cs.length - 1 && cs[i + 1] == '*' && !inString) {
                                start = i;
                                i += 2;
                                break;
                            }
                            if (i < cs.length - 1 && cs[i + 1] != '/') break block32;
                        }
                        case '#': {
                            lastNonWhite = MVELConsequenceBuilder.checkAndAddSemiColon(result, inString, brace, sqre, crly, lastNonWhite);
                            if (inString) {
                                result.append(c);
                                continue block12;
                            }
                            i = MVELConsequenceBuilder.processLineComment(cs, i, result);
                            continue block12;
                        }
                        {
                        }
                        case '(': {
                            ++brace;
                            break block32;
                        }
                        case '{': {
                            ++crly;
                            break block32;
                        }
                        case '[': {
                            ++sqre;
                            break block32;
                        }
                        case ')': {
                            --brace;
                            break block32;
                        }
                        case '}': {
                            --crly;
                            break block32;
                        }
                        case ']': {
                            --sqre;
                            break block32;
                        }
                    }
                    while (i < cs.length) {
                        if (cs[i] == '*' && i < cs.length - 1 && cs[i + 1] == '/') {
                            ++i;
                            break;
                        }
                        if (cs[i] == '\n' || cs[i] == '\r') {
                            lastNonWhite = MVELConsequenceBuilder.checkAndAddSemiColon(result, inString, brace, sqre, crly, lastNonWhite);
                        }
                        ++i;
                    }
                    result.append(cs, start, i - start);
                }
                if (c == '\n' || c == '\r') {
                    if (brace == 0 && sqre == 0 && crly == 0 && lastNonWhite != '.' && MVELConsequenceBuilder.lookAhead(cs, i + 1) != '.') {
                        if (lastNonWhite != ';') {
                            result.append(';');
                            lastNonWhite = ';';
                        }
                        for (int j = 0; j < skippedNewLines; ++j) {
                            result.append("\n");
                        }
                        skippedNewLines = 0;
                        break block31;
                    } else {
                        ++skippedNewLines;
                        continue;
                    }
                }
                if (!Character.isWhitespace(c)) {
                    lastNonWhite = c;
                }
            }
            result.append(c);
        }
        i = 0;
        while (i < skippedNewLines) {
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    private static char lookAhead(char[] cs, int pos) {
        for (int i = pos; i < cs.length; ++i) {
            if (Character.isWhitespace(cs[i])) continue;
            return cs[i];
        }
        return ' ';
    }

    private static int processLineComment(char[] cs, int i, StringBuilder result) {
        while (i < cs.length) {
            result.append(cs[i]);
            if (cs[i] == '\n' || cs[i] == '\r') break;
            ++i;
        }
        return i;
    }

    private static char checkAndAddSemiColon(StringBuilder result, boolean inString, int brace, int sqre, int crly, char lastNonWhite) {
        if (!inString && brace == 0 && sqre == 0 && crly == 0 && lastNonWhite != ';') {
            result.append(';');
            lastNonWhite = (char)59;
        }
        return lastNonWhite;
    }

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        macros.put("insertLogical", new Macro(){

            public String doMacro() {
                return "drools.insertLogical";
            }
        });
        macros.put("bolster", new Macro(){

            public String doMacro() {
                return "drools.bolster";
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
        macros.put("entryPoints", new Macro(){

            public String doMacro() {
                return "drools.entryPoints";
            }
        });
        macros.put("exitPoints", new Macro(){

            public String doMacro() {
                return "drools.exitPoints";
            }
        });
        macros.put("don", new Macro(){

            public String doMacro() {
                return "drools.don";
            }
        });
        macros.put("shed", new Macro(){

            public String doMacro() {
                return "drools.shed";
            }
        });
    }
}

