/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.TypeDeclarationUtils;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.rule.builder.util.AnnotationFactory;
import org.drools.core.base.ClassFieldInspector;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.EnumClassDefinition;
import org.drools.core.factmodel.EnumLiteralDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.rule.TypeDeclaration;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.AnnotationDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.EnumDeclarationDescr;
import org.drools.drl.ast.descr.EnumLiteralDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.QualifiedName;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.drools.util.ClassUtils;
import org.drools.util.TypeResolver;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Position;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.definition.GenericTypeDefinition;

public class ClassDefinitionFactory {
    protected TypeDeclarationContext context;

    public ClassDefinitionFactory(TypeDeclarationContext context) {
        this.context = context;
    }

    public ClassDefinition generateDeclaredBean(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, List<TypeDefinition> unresolvedTypeDefinitions, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        boolean success;
        ClassDefinition def = this.createClassDefinition(typeDescr, type);
        boolean bl = success = this.wireAnnotationDefs(typeDescr, def, pkgRegistry.getTypeResolver()) && this.wireEnumLiteralDefs(typeDescr, type, def) && this.wireFields(typeDescr, def, pkgRegistry, unresolvedTypeDefinitions);
        if (!success) {
            unprocesseableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
        }
        type.setTypeClassDef(def);
        return def;
    }

    protected ClassDefinition createClassDefinition(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type) {
        ClassDefinition def;
        Traitable traitableAnn;
        String fullName = typeDescr.getType().getFullName();
        if (type.getKind().equals((Object)TypeDeclaration.Kind.CLASS)) {
            TypeDeclarationDescr tdescr = (TypeDeclarationDescr)typeDescr;
            if (tdescr.getSuperTypes().size() > 1) {
                this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, "Declared class " + fullName + "  - has more than one supertype;"));
                return null;
            }
            if (tdescr.getSuperTypes().isEmpty()) {
                tdescr.addSuperType("java.lang.Object");
            }
        }
        boolean traitable = (traitableAnn = AnnotationFactory.getTypedAnnotation((AnnotatedBaseDescr)typeDescr, Traitable.class)) != null;
        String[] fullSuperTypes = new String[typeDescr.getSuperTypes().size() + 1];
        int j = 0;
        for (QualifiedName qname : typeDescr.getSuperTypes()) {
            fullSuperTypes[j++] = qname.getFullName();
        }
        fullSuperTypes[j] = Thing.class.getName();
        ArrayList<String> interfaceList = new ArrayList<String>();
        interfaceList.add(traitable ? Externalizable.class.getName() : Serializable.class.getName());
        if (traitable) {
            interfaceList.add(TraitableBean.class.getName());
        }
        String[] interfaces = interfaceList.toArray(new String[interfaceList.size()]);
        switch (type.getKind()) {
            case TRAIT: {
                def = new ClassDefinition(fullName, Object.class.getName(), fullSuperTypes);
                break;
            }
            case ENUM: {
                def = new EnumClassDefinition(fullName, fullSuperTypes[0], null);
                break;
            }
            default: {
                def = new ClassDefinition(fullName, fullSuperTypes[0], interfaces);
                def.setTraitable(traitable, traitableAnn != null && traitableAnn.logical());
            }
        }
        return def;
    }

    protected boolean wireAnnotationDefs(AbstractClassTypeDeclarationDescr typeDescr, ClassDefinition def, TypeResolver resolver) {
        for (AnnotationDescr annotationDescr : typeDescr.getAnnotations()) {
            Class annotation;
            try {
                annotation = annotationDescr.getFullyQualifiedName() != null ? resolver.resolveType(annotationDescr.getFullyQualifiedName()) : null;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (annotation != null && annotation.isAnnotation()) {
                try {
                    AnnotationDefinition annotationDefinition = AnnotationDefinition.build((Class)annotation, (Map)annotationDescr.getValueMap(), (TypeResolver)resolver);
                    def.addAnnotation(annotationDefinition);
                }
                catch (NoSuchMethodException nsme) {
                    this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, "Annotated type " + typeDescr.getType().getFullName() + "  - undefined property in @annotation " + annotationDescr.getName() + ": " + nsme.getMessage() + ";"));
                }
            }
            if (annotation != null && !annotation.getCanonicalName().startsWith("org.kie.api.definition.type")) continue;
            def.addMetaData(annotationDescr.getName(), annotationDescr.getSingleValue());
        }
        return true;
    }

    protected boolean wireEnumLiteralDefs(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, ClassDefinition def) {
        if (type.getKind() == TypeDeclaration.Kind.ENUM) {
            for (EnumLiteralDescr lit : ((EnumDeclarationDescr)typeDescr).getLiterals()) {
                ((EnumClassDefinition)def).addLiteral(new EnumLiteralDefinition(lit.getName(), lit.getConstructorArgs()));
            }
        }
        return true;
    }

    protected boolean wireFields(AbstractClassTypeDeclarationDescr typeDescr, ClassDefinition def, PackageRegistry pkgRegistry, List<TypeDefinition> unresolvedTypeDefinitions) {
        if (!typeDescr.getFields().isEmpty()) {
            if (unresolvedTypeDefinitions != null && !unresolvedTypeDefinitions.isEmpty()) {
                for (TypeFieldDescr fld : typeDescr.getFields().values()) {
                    for (TypeDefinition typeDef : unresolvedTypeDefinitions) {
                        if (!fld.getPattern().getObjectType().equals(typeDef.getTypeClassName())) continue;
                        return false;
                    }
                }
            }
            List<FieldDefinition> fieldDefs = ClassDefinitionFactory.sortFields(typeDescr.getFields(), pkgRegistry.getTypeResolver(), this.context);
            int i = 0;
            for (FieldDefinition fieldDef : fieldDefs) {
                fieldDef.setIndex(i++);
                def.addField(fieldDef);
            }
        }
        return true;
    }

    private static List<FieldDefinition> sortFields(Map<String, TypeFieldDescr> fields, TypeResolver typeResolver, TypeDeclarationContext tdContext) {
        ArrayList<FieldDefinition> fieldDefs = new ArrayList<FieldDefinition>(fields.size());
        int maxDeclaredPos = 0;
        BitSet occupiedPositions = new BitSet(fields.size());
        for (TypeFieldDescr field : fields.values()) {
            GenericTypeDefinition genericType = field.getPattern().getGenericType().map(type -> TypeDeclarationUtils.toBuildableType(type, tdContext != null ? tdContext.getRootClassLoader() : null));
            FieldDefinition fieldDef = new FieldDefinition(field.getFieldName(), genericType);
            fieldDefs.add(fieldDef);
            if (field.hasOverride()) {
                fieldDef.setOverriding(field.getOverriding().getPattern().getObjectType());
            }
            fieldDef.setInherited(field.isInherited());
            fieldDef.setRecursive(field.isRecursive());
            fieldDef.setInitExpr(TypeDeclarationUtils.rewriteInitExprWithImports(field.getInitExpr(), typeResolver));
            if (field.getIndex() >= 0) {
                int pos = field.getIndex();
                occupiedPositions.set(pos);
                maxDeclaredPos = Math.max(maxDeclaredPos, pos);
                fieldDef.addMetaData("position", (Object)pos);
            } else {
                Position position = AnnotationFactory.getTypedAnnotation((AnnotatedBaseDescr)field, Position.class);
                if (position != null) {
                    int pos = position.value();
                    field.setIndex(pos);
                    occupiedPositions.set(pos);
                    maxDeclaredPos = Math.max(maxDeclaredPos, pos);
                    fieldDef.addMetaData("position", (Object)pos);
                }
            }
            if (field.hasAnnotation(Key.class)) {
                fieldDef.setKey(true);
                fieldDef.addMetaData("key", null);
            }
            for (AnnotationDescr annotationDescr : field.getAnnotations()) {
                Annotation annotation;
                if (annotationDescr.getFullyQualifiedName() == null) {
                    if (annotationDescr.isStrict()) {
                        tdContext.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)field, "Unknown annotation @" + annotationDescr.getName() + " on field " + field.getFieldName()));
                    } else {
                        fieldDef.addMetaData(annotationDescr.getName(), annotationDescr.getSingleValue());
                        continue;
                    }
                }
                if ((annotation = AnnotationFactory.buildAnnotation(typeResolver, annotationDescr)) != null) {
                    try {
                        AnnotationDefinition annotationDefinition = AnnotationDefinition.build(annotation.annotationType(), (Map)field.getAnnotation(annotationDescr.getFullyQualifiedName()).getValueMap(), (TypeResolver)typeResolver);
                        fieldDef.addAnnotation(annotationDefinition);
                    }
                    catch (Exception e) {
                        tdContext.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)field, "Annotated field " + field.getFieldName() + "  - undefined property in @annotation " + annotationDescr.getName() + ": " + e.getMessage() + ";"));
                    }
                    continue;
                }
                if (!annotationDescr.isStrict()) continue;
                tdContext.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)field, "Unknown annotation @" + annotationDescr.getName() + " on field " + field.getFieldName()));
            }
            fieldDef.setDeclIndex(field.getIndex());
        }
        int curr = 0;
        for (FieldDefinition fieldDef : fieldDefs) {
            if (fieldDef.getDeclIndex() < 0) {
                int freePos = occupiedPositions.nextClearBit(0);
                if (freePos < maxDeclaredPos) {
                    occupiedPositions.set(freePos);
                } else {
                    freePos = maxDeclaredPos + 1;
                }
                fieldDef.setPriority(freePos * 256 + curr++);
                continue;
            }
            fieldDef.setPriority(fieldDef.getDeclIndex() * 256 + curr++);
        }
        Collections.sort(fieldDefs);
        return fieldDefs;
    }

    public static ClassDefinition createClassDefinition(Class<?> typeClass, Resource resource) {
        ClassDefinition clsDef = new ClassDefinition();
        ClassDefinitionFactory.populateDefinitionFromClass(clsDef, resource, typeClass, typeClass.getAnnotation(Trait.class) != null);
        return clsDef;
    }

    public static void populateDefinitionFromClass(ClassDefinition def, Resource resource, Class<?> concrete, boolean asTrait) {
        try {
            def.setClassName(concrete.getName());
            if (concrete.getSuperclass() != null) {
                def.setSuperClass(concrete.getSuperclass().getName());
            }
            ClassFieldInspector inspector = CoreComponentsBuilder.get().createClassFieldInspector(concrete);
            Map methods = inspector.getGetterMethods();
            Map setters = inspector.getSetterMethods();
            HashMap<String, TypeFieldDescr> fields = new HashMap<String, TypeFieldDescr>();
            for (String fieldName : methods.keySet()) {
                if (asTrait && ("core".equals(fieldName) || "fields".equals(fieldName)) || inspector.isNonGetter(fieldName) || !setters.containsKey(fieldName)) continue;
                Position position = null;
                if (!concrete.isInterface()) {
                    try {
                        Field fld = concrete.getDeclaredField(fieldName);
                        position = fld.getAnnotation(Position.class);
                    }
                    catch (NoSuchFieldException fld) {
                        // empty catch block
                    }
                }
                Class<?> ret = ((Method)methods.get(fieldName)).getReturnType();
                TypeFieldDescr field = new TypeFieldDescr();
                field.setResource(resource);
                field.setFieldName(fieldName);
                field.setPattern(new PatternDescr(ret.getName()));
                field.setIndex(position != null ? position.value() : -1);
                fields.put(fieldName, field);
            }
            if (!fields.isEmpty()) {
                List<FieldDefinition> fieldDefs = ClassDefinitionFactory.sortFields(fields, null, null);
                int i = 0;
                for (FieldDefinition fieldDef : fieldDefs) {
                    fieldDef.setIndex(i++);
                    def.addField(fieldDef);
                }
            }
            HashSet<String> interfaces = new HashSet<String>();
            Collections.addAll(interfaces, def.getInterfaces());
            for (Class iKlass : ClassUtils.getAllImplementedInterfaceNames(concrete)) {
                interfaces.add(iKlass.getName());
            }
            def.setInterfaces(interfaces.toArray(new String[interfaces.size()]));
            def.setDefinedClass(concrete);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

