/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.lang.annotation.Annotation;
import java.util.Set;

public interface TypeResolver {
    public static final AcceptAllClassFilter ACCEPT_ALL_CLASS_FILTER = new AcceptAllClassFilter();
    public static final ExcludeAnnotationClassFilter EXCLUDE_ANNOTATION_CLASS_FILTER = new ExcludeAnnotationClassFilter();
    public static final OnlyAnnotationClassFilter ONLY_ANNOTATION_CLASS_FILTER = new OnlyAnnotationClassFilter();

    public Set<String> getImports();

    public void addImport(String var1);

    public void addImplicitImport(String var1);

    public Class<?> resolveType(String var1) throws ClassNotFoundException;

    public Class<?> resolveType(String var1, ClassFilter var2) throws ClassNotFoundException;

    public void registerClass(String var1, Class<?> var2);

    public String getFullTypeName(String var1) throws ClassNotFoundException;

    public ClassLoader getClassLoader();

    public static class OnlyAnnotationClassFilter
    implements ClassFilter {
        @Override
        public boolean accept(Class<?> clazz) {
            return Annotation.class.isAssignableFrom(clazz);
        }
    }

    public static class ExcludeAnnotationClassFilter
    implements ClassFilter {
        @Override
        public boolean accept(Class<?> clazz) {
            return !Annotation.class.isAssignableFrom(clazz);
        }
    }

    public static class AcceptAllClassFilter
    implements ClassFilter {
        @Override
        public boolean accept(Class<?> clazz) {
            return true;
        }
    }

    public static interface ClassFilter {
        public boolean accept(Class<?> var1);
    }
}

