/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.io;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.util.IoUtils;
import org.drools.util.StringUtils;
import org.drools.util.io.BaseResource;
import org.drools.util.io.InternalResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class FileSystemResource
extends BaseResource
implements InternalResource,
Externalizable {
    private File file;
    private String encoding;

    public FileSystemResource() {
    }

    public FileSystemResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        this.file = new File(StringUtils.cleanPath(file.getPath()));
        try {
            this.setSourcePath(file.getCanonicalPath());
        }
        catch (IOException e) {
            this.setSourcePath(file.getAbsolutePath());
        }
        this.setResourceType(ResourceType.determineResourceType((String)this.getSourcePath()));
    }

    public FileSystemResource(File file, String encoding) {
        this(file);
        this.encoding = encoding;
    }

    public FileSystemResource(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null");
        }
        this.file = new File(StringUtils.cleanPath(path));
        this.setSourcePath(path);
        this.setResourceType(ResourceType.determineResourceType((String)this.getSourcePath()));
    }

    public FileSystemResource(String path, String encoding) {
        this(path);
        this.encoding = encoding;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.file);
        out.writeObject(this.encoding);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.file = (File)in.readObject();
        this.encoding = (String)in.readObject();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public InputStream getInputStream() throws IOException {
        return this.bytes != null ? new ByteArrayInputStream(this.bytes) : new FileInputStream(this.file);
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream(), IoUtils.UTF8_CHARSET);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public Collection<Resource> listResources() {
        File[] files = this.file.listFiles();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (File file : files) {
            resources.add(new FileSystemResource(file));
        }
        return resources;
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public boolean hasURL() {
        return true;
    }

    @Override
    public String toString() {
        return "FileResource[file=" + this.file.toString() + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object == this || object instanceof FileSystemResource && this.file.equals(((FileSystemResource)object).file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }
}

