/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.PhreakSubnetworkNotExistsNode;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.util.FastIterator;

public class PhreakNotNode {
    public void doNode(NotNode notNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        if (!notNode.isRightInputIsRiaNode()) {
            this.doNormalNode(notNode, sink, bm, reteEvaluator, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        } else {
            PhreakSubnetworkNotExistsNode.doSubNetworkNode(notNode, sink, bm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
    }

    public void doNormalNode(NotNode notNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleSets<RightTuple> srcRightTuples = bm.getStagedRightTuples().takeAll();
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(bm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesExistentialReorderLeftMemory(bm, srcLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesExistentialReorderRightMemory(bm, notNode, srcRightTuples);
        }
        if (srcRightTuples.getInsertFirst() != null) {
            this.doRightInserts(notNode, bm, reteEvaluator, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            this.doRightUpdates(notNode, sink, bm, reteEvaluator, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getDeleteFirst() != null) {
            this.doRightDeletes(notNode, sink, bm, reteEvaluator, srcRightTuples, trgLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(notNode, sink, bm, reteEvaluator, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(notNode, sink, bm, reteEvaluator, srcLeftTuples, trgLeftTuples);
        }
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(NotNode notNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = notNode.getRawConstraints();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(notNode, leftTuple);
            constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
            RuleNetworkEvaluator.findLeftTupleBlocker(notNode, rtm, contextEntry, constraints, leftTuple, useLeftMemory);
            if (leftTuple.getBlocker() == null) {
                PhreakNotNode.insertChildLeftTuple(sink, trgLeftTuples, ltm, leftTuple, leftTuple.getPropagationContext(), useLeftMemory);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightInserts(NotNode notNode, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = notNode.getRawConstraints();
        PhreakNotNode.unlinkNotNodeOnRightInsert(notNode, bm, reteEvaluator);
        RightTuple rightTuple = srcRightTuples.getInsertFirst();
        while (rightTuple != null) {
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            rtm.add(rightTuple);
            if (ltm != null && ltm.size() > 0) {
                FastIterator it = notNode.getLeftIterator(ltm);
                constraints.updateFromFactHandle(contextEntry, reteEvaluator, rightTuple.getFactHandleForEvaluation());
                LeftTuple leftTuple = notNode.getFirstLeftTuple(rightTuple, ltm, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        if (childLeftTuple != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public static void unlinkNotNodeOnRightInsert(NotNode notNode, BetaMemory bm, ReteEvaluator reteEvaluator) {
        if (bm.getSegmentMemory().isSegmentLinked() && notNode.isEmptyBetaConstraints()) {
            bm.unlinkNode(reteEvaluator);
        }
    }

    public void doLeftUpdates(NotNode notNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = notNode.getRawConstraints();
        boolean leftUpdateOptimizationAllowed = notNode.isLeftUpdateOptimizationAllowed();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            FastIterator rightIt = notNode.getRightIterator(rtm);
            RightTuple firstRightTuple = notNode.getFirstRightTuple(leftTuple, rtm, rightIt);
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
            } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                blocker.removeBlocked(leftTuple);
                blocker = null;
            }
            constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
            if (!leftUpdateOptimizationAllowed && blocker != null) {
                blocker.removeBlocked(leftTuple);
                blocker = null;
            }
            if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandleForEvaluation())) {
                if (blocker != null) {
                    blocker.removeBlocked(leftTuple);
                }
                RightTuple newBlocker = firstRightTuple;
                while (newBlocker != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandleForEvaluation())) {
                        leftTuple.setBlocker(newBlocker);
                        newBlocker.addBlocked(leftTuple);
                        break;
                    }
                    newBlocker = (RightTuple)rightIt.next(newBlocker);
                }
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (leftTuple.getBlocker() != null) {
                    if (childLeftTuple != null) {
                        childLeftTuple.setPropagationContext(leftTuple.getBlocker().getPropagationContext());
                        RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                } else if (childLeftTuple == null) {
                    PhreakNotNode.insertChildLeftTuple(sink, trgLeftTuples, ltm, leftTuple, leftTuple.getPropagationContext(), true);
                } else {
                    PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
                    ltm.add(leftTuple);
                    childLeftTuple.reAddLeft();
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightUpdates(NotNode notNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = notNode.getRawConstraints();
        boolean iterateFromStart = notNode.isIndexedUnificationJoin() || rtm.getIndexType().isComparison();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            if (ltm != null && ltm.size() > 0) {
                LeftTuple firstLeftTuple;
                constraints.updateFromFactHandle(contextEntry, reteEvaluator, rightTuple.getFactHandleForEvaluation());
                FastIterator leftIt = notNode.getLeftIterator(ltm);
                LeftTuple leftTuple = firstLeftTuple = notNode.getFirstLeftTuple(rightTuple, ltm, leftIt);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        if (childLeftTuple != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
            }
            iterateFromStart = PhreakNotNode.updateBlockersAndPropagate(notNode, rightTuple, reteEvaluator, rtm, contextEntry, constraints, iterateFromStart, sink, trgLeftTuples, ltm);
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
        constraints.resetTuple(contextEntry);
    }

    public static boolean updateBlockersAndPropagate(NotNode notNode, RightTuple rightTuple, ReteEvaluator reteEvaluator, TupleMemory rtm, ContextEntry[] contextEntry, BetaConstraints constraints, boolean iterateFromStart, LeftTupleSink sink, TupleSets<LeftTuple> trgLeftTuples, TupleMemory ltm) {
        LeftTuple firstBlocked = rightTuple.getTempBlocked();
        if (firstBlocked != null) {
            RightTuple rootBlocker = rightTuple.getTempNextRightTuple();
            if (rootBlocker == null) {
                iterateFromStart = true;
            }
            FastIterator rightIt = notNode.getRightIterator(rtm);
            LeftTuple leftTuple = firstBlocked;
            while (leftTuple != null) {
                LeftTuple temp = leftTuple.getBlockedNext();
                leftTuple.clearBlocker();
                if (leftTuple.getStagedType() == 2) {
                    leftTuple.setBlocker(rightTuple);
                    rightTuple.addBlocked(leftTuple);
                    leftTuple = temp;
                    continue;
                }
                constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
                if (iterateFromStart) {
                    rootBlocker = notNode.getFirstRightTuple(leftTuple, rtm, rightIt);
                }
                RightTuple newBlocker = rootBlocker;
                while (newBlocker != null) {
                    if (leftTuple.getStagedType() != 3 && newBlocker.getStagedType() != 3 && constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandleForEvaluation())) {
                        leftTuple.setBlocker(newBlocker);
                        newBlocker.addBlocked(leftTuple);
                        break;
                    }
                    newBlocker = (RightTuple)rightIt.next(newBlocker);
                }
                if (trgLeftTuples != null && leftTuple.getBlocker() == null) {
                    PhreakNotNode.insertChildLeftTuple(sink, trgLeftTuples, ltm, leftTuple, rightTuple.getPropagationContext(), true);
                }
                leftTuple = temp;
            }
        }
        return iterateFromStart;
    }

    public void doLeftDeletes(BetaMemory bm, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                LeftTuple childLeftTuple;
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
                if ((childLeftTuple = leftTuple.getFirstChild()) != null) {
                    childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                }
            } else {
                blocker.removeBlocked(leftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doRightDeletes(NotNode notNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = notNode.getRawConstraints();
        RightTuple rightTuple = srcRightTuples.getDeleteFirst();
        while (rightTuple != null) {
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rtm.remove(rightTuple);
            }
            if (rightTuple.getBlocked() != null) {
                FastIterator it = notNode.getRightIterator(rtm);
                LeftTuple leftTuple = rightTuple.getBlocked();
                while (leftTuple != null) {
                    RightTuple rootBlocker;
                    LeftTuple temp = leftTuple.getBlockedNext();
                    leftTuple.clearBlocker();
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
                    RightTuple newBlocker = rootBlocker = (RightTuple)rtm.getFirst(leftTuple);
                    while (newBlocker != null) {
                        if (!newBlocker.isDeleted() && constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandleForEvaluation())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)it.next(newBlocker);
                    }
                    if (leftTuple.getBlocker() == null) {
                        PhreakNotNode.insertChildLeftTuple(sink, trgLeftTuples, ltm, leftTuple, rightTuple.getPropagationContext(), true);
                    }
                    leftTuple = temp;
                }
            }
            rightTuple.setBlocked(null);
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    private static void insertChildLeftTuple(LeftTupleSink sink, TupleSets<LeftTuple> trgLeftTuples, TupleMemory ltm, LeftTuple leftTuple, PropagationContext pctx, boolean useLeftMemory) {
        if (!leftTuple.isExpired()) {
            if (useLeftMemory) {
                ltm.add(leftTuple);
            }
            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, pctx, useLeftMemory));
        }
    }
}

