/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.accessors;

import java.lang.reflect.Method;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ValueType;

public abstract class BaseFloatClassFieldWriter
extends BaseClassFieldWriter {
    private static final long serialVersionUID = 510L;

    public BaseFloatClassFieldWriter(Class<?> clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseFloatClassFieldWriter(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    public BaseFloatClassFieldWriter() {
    }

    public void setValue(Object bean, Object value) {
        this.setFloatValue(bean, value == null ? 0.0f : ((Number)value).floatValue());
    }

    public void setBooleanValue(Object bean, boolean value) {
        throw new RuntimeException("Conversion to float not supported from boolean");
    }

    public void setByteValue(Object bean, byte value) {
        this.setFloatValue(bean, value);
    }

    public void setCharValue(Object bean, char value) {
        throw new RuntimeException("Conversion to float not supported from char");
    }

    public void setDoubleValue(Object bean, double value) {
        this.setFloatValue(bean, (float)value);
    }

    public abstract void setFloatValue(Object var1, float var2);

    public void setIntValue(Object bean, int value) {
        this.setFloatValue(bean, value);
    }

    public void setLongValue(Object bean, long value) {
        this.setFloatValue(bean, value);
    }

    public void setShortValue(Object bean, short value) {
        this.setFloatValue(bean, value);
    }

    public Method getNativeWriteMethod() {
        try {
            return ((Object)((Object)this)).getClass().getDeclaredMethod("setFloatValue", Object.class, Float.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }
}

